/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import org.lwjgl.input.Keyboard;

public class GuiSubworldEdit
extends GuiScreenMinimap
implements GuiYesNoCallback {
    private GuiScreen parent;
    private IWaypointManager waypointManager;
    private ArrayList<String> knownSubworldNames;
    private String originalSubworldName = "";
    private String currentSubworldName = "";
    private GuiTextField subworldNameField;
    private boolean deleteClicked = false;

    public GuiSubworldEdit(GuiScreen parent, IVoxelMap master, String subworldName) {
        this.parent = parent;
        this.waypointManager = master.getWaypointManager();
        this.originalSubworldName = subworldName;
        this.knownSubworldNames = new ArrayList<String>(this.waypointManager.getKnownSubworldNames());
    }

    public void func_73876_c() {
        this.subworldNameField.func_146178_a();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.getButtonList().clear();
        this.getButtonList().add(new GuiButton(0, this.getWidth() / 2 - 155, this.getHeight() / 6 + 168, 150, 20, I18nUtils.getString("gui.done", new Object[0])));
        this.getButtonList().add(new GuiButton(1, this.getWidth() / 2 + 5, this.getHeight() / 6 + 168, 150, 20, I18nUtils.getString("gui.cancel", new Object[0])));
        this.subworldNameField = new GuiTextField(2, this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0 + 13, 200, 20);
        this.subworldNameField.func_146195_b(true);
        this.subworldNameField.func_146180_a(this.originalSubworldName);
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        this.getButtonList().add(new GuiButton(7, this.getWidth() / 2 - 50, buttonListY + 24, 100, 20, I18nUtils.getString("selectServer.delete", new Object[0])));
        this.getButtonList().get((int)0).field_146124_l = this.isNameAcceptable();
        this.getButtonList().get((int)2).field_146124_l = this.originalSubworldName.equals(this.subworldNameField.func_146179_b());
    }

    @Override
    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            if (par1GuiButton.field_146127_k == 0) {
                if (!this.currentSubworldName.equals(this.originalSubworldName)) {
                    this.waypointManager.changeSubworldName(this.originalSubworldName, this.currentSubworldName);
                }
                this.getMinecraft().func_147108_a(this.parent);
            } else if (par1GuiButton.field_146127_k == 1) {
                this.getMinecraft().func_147108_a(this.parent);
            } else if (par1GuiButton.field_146127_k == 7) {
                this.deleteClicked = true;
                String var4 = I18nUtils.getString("worldmap.subworld.deleteconfirm", new Object[0]);
                String var5 = "'" + this.originalSubworldName + "' " + I18nUtils.getString("selectServer.deleteWarning", new Object[0]);
                String var6 = I18nUtils.getString("selectServer.deleteButton", new Object[0]);
                String var7 = I18nUtils.getString("gui.cancel", new Object[0]);
                GuiYesNo var8 = new GuiYesNo((GuiYesNoCallback)this, var4, var5, var6, var7, 0);
                this.getMinecraft().func_147108_a((GuiScreen)var8);
            }
        }
    }

    public void func_73878_a(boolean par1, int par2) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointManager.deleteSubworld(this.originalSubworldName);
            }
            this.getMinecraft().func_147108_a(this.parent);
        }
    }

    protected void func_73869_a(char character, int keycode) throws IOException {
        super.func_73869_a(character, keycode);
        this.subworldNameField.func_146201_a(character, keycode);
        boolean acceptable = this.isNameAcceptable();
        if (character == '\r' && acceptable) {
            this.func_146284_a(this.getButtonList().get(0));
        }
        this.getButtonList().get((int)0).field_146124_l = acceptable;
        this.getButtonList().get((int)2).field_146124_l = this.originalSubworldName.equals(this.subworldNameField.func_146179_b());
    }

    protected void func_73864_a(int mouseX, int mouseY, int par3) throws IOException {
        super.func_73864_a(mouseX, mouseY, par3);
        this.subworldNameField.func_146192_a(mouseX, mouseY, par3);
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        super.drawMap();
        this.func_146276_q_();
        this.func_73732_a(this.getFontRenderer(), I18nUtils.getString("worldmap.subworld.edit", new Object[0]), this.getWidth() / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.getFontRenderer(), I18nUtils.getString("worldmap.subworld.name", new Object[0]), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0, 0xA0A0A0);
        this.subworldNameField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, par3);
    }

    private boolean isNameAcceptable() {
        boolean acceptable = true;
        this.currentSubworldName = this.subworldNameField.func_146179_b();
        acceptable = acceptable && this.currentSubworldName.length() > 0;
        acceptable = acceptable && (this.currentSubworldName.equals(this.originalSubworldName) || !this.knownSubworldNames.contains(this.currentSubworldName));
        return acceptable;
    }
}

