/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui.overridden;

import com.mamiyaotaru.voxelmap.util.GLShim;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public abstract class GuiSlotMinimap {
    private final Minecraft mc;
    protected int width;
    private int height;
    protected int top;
    protected int bottom;
    protected int right;
    protected int left;
    protected int slotWidth = 220;
    protected final int slotHeight;
    private int scrollUpButtonID;
    private int scrollDownButtonID;
    protected int mouseX;
    protected int mouseY;
    protected boolean centerListVertically = true;
    private float initialClickY = -2.0f;
    private float scrollMultiplier;
    private float amountScrolled;
    private int selectedElement = -1;
    private long lastClicked;
    private long lastClickedTouch = 0L;
    private boolean showSelectionBox = true;
    private boolean showTopBottomBG = true;
    private boolean showSlotBG = true;
    private boolean hasListHeader;
    protected int headerPadding;
    private boolean enabled = true;

    public GuiSlotMinimap(Minecraft par1Minecraft, int width, int height, int top, int bottom, int slotHeight) {
        this.mc = par1Minecraft;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.slotHeight = slotHeight;
        this.left = 0;
        this.right = width;
    }

    public void setDimensions(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setShowSelectionBox(boolean showSelectionBox) {
        this.showSelectionBox = showSelectionBox;
    }

    public void setShowTopBottomBG(boolean showTopBottomBG) {
        this.showTopBottomBG = showTopBottomBG;
    }

    public void setShowSlotBG(boolean showSlotBG) {
        this.showSlotBG = showSlotBG;
    }

    protected void setHasListHeader(boolean hasListHeader, int headerPadding) {
        this.hasListHeader = hasListHeader;
        this.headerPadding = headerPadding;
        if (!hasListHeader) {
            this.headerPadding = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2, int var3, int var4);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight + this.headerPadding;
    }

    protected abstract void drawBackground();

    protected void updateItemPos(int entryID, int insideLeft, int yPos, float partialTicks) {
    }

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, int var5, int var6, float var7);

    protected void drawListHeader(int insideLeft, int insideTop, Tessellator tessellatorIn) {
    }

    protected void clickedHeader(int p_148132_1_, int p_148132_2_) {
    }

    protected void renderDecorations(int mouseXIn, int mouseYIn) {
    }

    public int getSlotIndexFromScreenCoords(int x, int y) {
        int slotLeft = this.left + this.width / 2 - this.getListWidth() / 2;
        int slotRight = this.left + this.width / 2 + this.getListWidth() / 2;
        int yInSlotList = y - this.top - this.headerPadding + (int)this.amountScrolled - 4;
        int slotIndex = yInSlotList / this.slotHeight;
        return x < this.getScrollBarX() && x >= slotLeft && x <= slotRight && slotIndex >= 0 && yInSlotList >= 0 && slotIndex < this.getSize() ? slotIndex : -1;
    }

    public void registerScrollButtons(int scrollUpButtonID, int scrollDownButtonID) {
        this.scrollUpButtonID = scrollUpButtonID;
        this.scrollDownButtonID = scrollDownButtonID;
    }

    protected void bindAmountScrolled() {
        this.amountScrolled = MathHelper.func_76131_a((float)this.amountScrolled, (float)0.0f, (float)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - (this.bottom - this.top - 4));
    }

    public int getAmountScrolled() {
        return (int)this.amountScrolled;
    }

    public boolean isMouseYWithinSlotBounds(int mouseY) {
        return mouseY >= this.top && mouseY <= this.bottom;
    }

    public boolean isMouseXYWithinSlotBounds(int mouseX, int mouseY) {
        return mouseX > this.left && mouseX < this.right && mouseY >= this.top && mouseY <= this.bottom;
    }

    public void scrollBy(int scrollBy) {
        this.amountScrolled += (float)scrollBy;
        this.bindAmountScrolled();
        this.initialClickY = -2.0f;
    }

    public void actionPerformed(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.scrollUpButtonID) {
                this.amountScrolled -= (float)(this.slotHeight * 2 / 3);
                this.initialClickY = -2.0f;
                this.bindAmountScrolled();
            } else if (button.field_146127_k == this.scrollDownButtonID) {
                this.amountScrolled += (float)(this.slotHeight * 2 / 3);
                this.initialClickY = -2.0f;
                this.bindAmountScrolled();
            }
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        int maxScroll;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawBackground();
        int scrollBarLeft = this.getScrollBarX();
        int scrollBarRight = scrollBarLeft + 6;
        this.bindAmountScrolled();
        GLShim.glDisable(2896);
        GLShim.glDisable(2912);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        if (this.showSlotBG) {
            this.mc.func_110434_K().func_110577_a(Gui.field_110325_k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b((double)this.left, (double)this.bottom, 0.0).func_187315_a((double)((float)this.left / f), (double)((float)(this.bottom + (int)this.amountScrolled) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)this.right, (double)this.bottom, 0.0).func_187315_a((double)((float)this.right / f), (double)((float)(this.bottom + (int)this.amountScrolled) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)this.right, (double)this.top, 0.0).func_187315_a((double)((float)this.right / f), (double)((float)(this.top + (int)this.amountScrolled) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)this.left, (double)this.top, 0.0).func_187315_a((double)((float)this.left / f), (double)((float)(this.top + (int)this.amountScrolled) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        int leftEdge = this.left + this.width / 2 - this.getListWidth() / 2 + 2;
        int topOfListYPos = this.top + 4 - (int)this.amountScrolled;
        if (this.hasListHeader) {
            this.drawListHeader(leftEdge, topOfListYPos, tessellator);
        }
        this.drawSelectionBox(leftEdge, topOfListYPos, mouseX, mouseY, partialTicks);
        GLShim.glDisable(2929);
        int topBottomFadeHeight = 4;
        if (this.showTopBottomBG) {
            this.overlayBackground(0, this.top, 255, 255);
            this.overlayBackground(this.bottom, this.height, 255, 255);
        }
        GLShim.glEnable(3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)0, (int)1);
        GLShim.glDisable(3008);
        GLShim.glShadeModel(7425);
        GLShim.glDisable(3553);
        if (this.showTopBottomBG) {
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b((double)this.left, (double)(this.top + topBottomFadeHeight), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            vertexBuffer.func_181662_b((double)this.right, (double)(this.top + topBottomFadeHeight), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            vertexBuffer.func_181662_b((double)this.right, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)this.left, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b((double)this.left, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)this.right, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)this.right, (double)(this.bottom - topBottomFadeHeight), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            vertexBuffer.func_181662_b((double)this.left, (double)(this.bottom - topBottomFadeHeight), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
        }
        if ((maxScroll = this.getMaxScroll()) > 0) {
            int k1 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            int l1 = (int)this.amountScrolled * (this.bottom - this.top - (k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.bottom - this.top - 8)))) / maxScroll + this.top;
            if (l1 < this.top) {
                l1 = this.top;
            }
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b((double)scrollBarLeft, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)scrollBarRight, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)scrollBarRight, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)scrollBarLeft, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b((double)scrollBarLeft, (double)(l1 + k1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)scrollBarRight, (double)(l1 + k1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)scrollBarRight, (double)l1, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)scrollBarLeft, (double)l1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            tessellator.func_78381_a();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b((double)scrollBarLeft, (double)(l1 + k1 - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)(scrollBarRight - 1), (double)(l1 + k1 - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)(scrollBarRight - 1), (double)l1, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)scrollBarLeft, (double)l1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        this.renderDecorations(mouseX, mouseY);
        GLShim.glEnable(3553);
        GLShim.glShadeModel(7424);
        GLShim.glEnable(3008);
        GLShim.glDisable(3042);
    }

    public void handleMouseInput() {
        if (this.isMouseYWithinSlotBounds(this.mouseY)) {
            if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && this.mouseY >= this.top && this.mouseY <= this.bottom) {
                int leftEdge = this.left + this.width / 2 - this.getListWidth() / 2;
                int rightEdge = this.left + this.width / 2 + this.getListWidth() / 2;
                int mouseYInList = this.mouseY - this.top - this.headerPadding + (int)this.amountScrolled - 4;
                int slotIndex = mouseYInList / this.slotHeight;
                if (slotIndex < this.getSize() && this.mouseX >= leftEdge && this.mouseX <= rightEdge && slotIndex >= 0 && mouseYInList >= 0) {
                    this.elementClicked(slotIndex, false, this.mouseX, this.mouseY);
                    this.selectedElement = slotIndex;
                } else if (this.mouseX >= leftEdge && this.mouseX <= rightEdge && mouseYInList < 0) {
                    this.clickedHeader(this.mouseX - leftEdge, this.mouseY - this.top + (int)this.amountScrolled - 4);
                }
            }
            if (Mouse.isButtonDown((int)0) && this.getEnabled()) {
                if (this.initialClickY == -1.0f) {
                    boolean flag1 = true;
                    if (this.mouseY >= this.top && this.mouseY <= this.bottom) {
                        int leftEdge = this.left + this.width / 2 - this.getListWidth() / 2;
                        int rightEdge = this.left + this.width / 2 + this.getListWidth() / 2;
                        int mouseYInList = this.mouseY - this.top - this.headerPadding + (int)this.amountScrolled - 4;
                        int slotIndex = mouseYInList / this.slotHeight;
                        if (slotIndex < this.getSize() && this.mouseX >= leftEdge && this.mouseX <= rightEdge && slotIndex >= 0 && mouseYInList >= 0) {
                            this.selectedElement = slotIndex;
                            this.lastClicked = Minecraft.func_71386_F();
                        } else if (this.mouseX >= leftEdge && this.mouseX <= rightEdge && mouseYInList < 0) {
                            this.clickedHeader(this.mouseX - leftEdge, this.mouseY - this.top + (int)this.amountScrolled - 4);
                            flag1 = false;
                        }
                        int scrollBarLeft = this.getScrollBarX();
                        int scrollBarRight = scrollBarLeft + 6;
                        if (this.mouseX >= scrollBarLeft && this.mouseX <= scrollBarRight) {
                            this.scrollMultiplier = -1.0f;
                            int k1 = this.getMaxScroll();
                            if (k1 < 1) {
                                k1 = 1;
                            }
                            int l1 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight());
                            l1 = MathHelper.func_76125_a((int)l1, (int)32, (int)(this.bottom - this.top - 8));
                            this.scrollMultiplier /= (float)(this.bottom - this.top - l1) / (float)k1;
                        } else {
                            this.scrollMultiplier = 1.0f;
                        }
                        this.initialClickY = flag1 ? (float)this.mouseY : -2.0f;
                    } else {
                        this.initialClickY = -2.0f;
                    }
                } else if (this.initialClickY >= 0.0f) {
                    this.amountScrolled -= ((float)this.mouseY - this.initialClickY) * this.scrollMultiplier;
                    this.initialClickY = this.mouseY;
                }
            } else {
                this.initialClickY = -1.0f;
            }
            int mouseRoll = Mouse.getEventDWheel();
            if (mouseRoll != 0) {
                if (mouseRoll > 0) {
                    mouseRoll = -1;
                } else if (mouseRoll < 0) {
                    mouseRoll = 1;
                }
                this.amountScrolled += (float)(mouseRoll * this.slotHeight / 2);
            }
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseEvent) {
        int i;
        if (this.isMouseYWithinSlotBounds(mouseY) && (i = this.getSlotIndexFromScreenCoords(mouseX, mouseY)) >= 0) {
            boolean flag;
            int j = this.left + this.width / 2 - this.getListWidth() / 2 + 2;
            int k = this.top + 4 - this.getAmountScrolled() + i * this.slotHeight + this.headerPadding;
            int l = mouseX - j;
            int i1 = mouseY - k;
            boolean bl = flag = i == this.selectedElement && Minecraft.func_71386_F() - this.lastClickedTouch < 250L;
            if (flag) {
                this.setEnabled(false);
                this.elementClicked(i, flag, this.mouseX, this.mouseY);
                return true;
            }
            this.lastClickedTouch = Minecraft.func_71386_F();
        }
        return false;
    }

    public boolean mouseReleased(int x, int y, int mouseEvent) {
        for (int i = 0; i < this.getSize(); ++i) {
            int j = this.left + this.width / 2 - this.getListWidth() / 2 + 2;
            int k = this.top + 4 - this.getAmountScrolled() + i * this.slotHeight + this.headerPadding;
            int l = x - j;
            int n = y - k;
        }
        this.setEnabled(true);
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getListWidth() {
        return this.slotWidth;
    }

    public void setSlotWidth(int slotWidth) {
        this.slotWidth = slotWidth;
    }

    protected void drawSelectionBox(int leftEdge, int topOfListYPos, int mouseX, int mouseY, float partialTicks) {
        int numberOfSlots = this.getSize();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        for (int slotIndexIterator = 0; slotIndexIterator < numberOfSlots; ++slotIndexIterator) {
            int bottomFudge;
            int slotYPos = topOfListYPos + slotIndexIterator * this.slotHeight + this.headerPadding;
            int topFudge = this.showTopBottomBG ? this.slotHeight - 4 : 0;
            int n = bottomFudge = this.showTopBottomBG ? 0 : this.slotHeight - 4;
            if (slotYPos + bottomFudge > this.bottom || slotYPos + topFudge < this.top) continue;
            if (this.showSelectionBox && this.isSelected(slotIndexIterator)) {
                int i1 = this.left + (this.width / 2 - this.getListWidth() / 2);
                int j1 = this.left + this.width / 2 + this.getListWidth() / 2;
                GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                GLShim.glDisable(3553);
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                vertexBuffer.func_181662_b((double)i1, (double)(slotYPos + topFudge + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                vertexBuffer.func_181662_b((double)j1, (double)(slotYPos + topFudge + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                vertexBuffer.func_181662_b((double)j1, (double)(slotYPos - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                vertexBuffer.func_181662_b((double)i1, (double)(slotYPos - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                vertexBuffer.func_181662_b((double)(i1 + 1), (double)(slotYPos + topFudge + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                vertexBuffer.func_181662_b((double)(j1 - 1), (double)(slotYPos + topFudge + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                vertexBuffer.func_181662_b((double)(j1 - 1), (double)(slotYPos - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                vertexBuffer.func_181662_b((double)(i1 + 1), (double)(slotYPos - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                GLShim.glEnable(3553);
            }
            this.drawSlot(slotIndexIterator, leftEdge, slotYPos, topFudge, mouseX, mouseY, partialTicks);
        }
    }

    protected int getScrollBarX() {
        return this.right - 6;
    }

    protected void overlayBackground(int startY, int endY, int startAlpha, int endAlpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        this.mc.func_110434_K().func_110577_a(Gui.field_110325_k);
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexBuffer.func_181662_b((double)this.left, (double)endY, 0.0).func_187315_a(0.0, (double)((float)endY / 32.0f)).func_181669_b(64, 64, 64, endAlpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(this.left + this.width), (double)endY, 0.0).func_187315_a((double)((float)this.width / 32.0f), (double)((float)endY / 32.0f)).func_181669_b(64, 64, 64, endAlpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(this.left + this.width), (double)startY, 0.0).func_187315_a((double)((float)this.width / 32.0f), (double)((float)startY / 32.0f)).func_181669_b(64, 64, 64, startAlpha).func_181675_d();
        vertexBuffer.func_181662_b((double)this.left, (double)startY, 0.0).func_187315_a(0.0, (double)((float)startY / 32.0f)).func_181669_b(64, 64, 64, startAlpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public void setSlotXBoundsFromLeft(int left) {
        this.left = left;
        this.right = left + this.width;
    }

    public int getSlotHeight() {
        return this.slotHeight;
    }
}

