package net.decentstudio.spawners.network.packets;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = net.decentstudio.spawners.network.packets.S0SaveSpawner.class
)
public class S0SaveSpawnerSerializer implements ISerializer<S0SaveSpawner> {
  public void serialize(S0SaveSpawner value, ByteBuf acc) {
    serialize_S0SaveSpawner_Generic(value, acc);
  }

  public S0SaveSpawner unserialize(ByteBuf buf) {
    return unserialize_S0SaveSpawner_Generic(buf);
  }

  void serialize_S0SaveSpawner_Generic(S0SaveSpawner value, ByteBuf acc) {
    serialize_S0SaveSpawner_Concretic(value, acc);
  }

  S0SaveSpawner unserialize_S0SaveSpawner_Generic(ByteBuf buf) {
    return unserialize_S0SaveSpawner_Concretic(buf);
  }

  void serialize_S0SaveSpawner_Concretic(S0SaveSpawner value, ByteBuf acc) {
    serialize_BlockPos_Generic(value.pos, acc);
    serialize_NBTTagCompound_Generic(value.nbtTagCompound, acc);
  }

  S0SaveSpawner unserialize_S0SaveSpawner_Concretic(ByteBuf buf) {
    S0SaveSpawner value = new S0SaveSpawner(unserialize_BlockPos_Generic(buf), unserialize_NBTTagCompound_Generic(buf));
    return value;
  }
}
