package net.decentstudio.spawners.network.packets;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = net.decentstudio.spawners.network.packets.S1OpenDropMenu.class
)
public class S1OpenDropMenuSerializer implements ISerializer<S1OpenDropMenu> {
  public void serialize(S1OpenDropMenu value, ByteBuf acc) {
    serialize_S1OpenDropMenu_Generic(value, acc);
  }

  public S1OpenDropMenu unserialize(ByteBuf buf) {
    return unserialize_S1OpenDropMenu_Generic(buf);
  }

  void serialize_S1OpenDropMenu_Generic(S1OpenDropMenu value, ByteBuf acc) {
    serialize_S1OpenDropMenu_Concretic(value, acc);
  }

  S1OpenDropMenu unserialize_S1OpenDropMenu_Generic(ByteBuf buf) {
    return unserialize_S1OpenDropMenu_Concretic(buf);
  }

  void serialize_S1OpenDropMenu_Concretic(S1OpenDropMenu value, ByteBuf acc) {
    serialize_Int_Generic(value.entityId, acc);
    serialize_BlockPos_Generic(value.pos, acc);
  }

  S1OpenDropMenu unserialize_S1OpenDropMenu_Concretic(ByteBuf buf) {
    S1OpenDropMenu value = new S1OpenDropMenu(unserialize_Int_Generic(buf), unserialize_BlockPos_Generic(buf));
    return value;
  }
}
