/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques;

import com.anthonyhilyard.advancementplaques.config.AdvancementPlaquesConfig;
import com.anthonyhilyard.advancementplaques.ui.AdvancementPlaquesToastGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="advancementplaques", name="Advancement Plaques", version="1.4.10", acceptedMinecraftVersions="[1.12.2]", clientSideOnly=true)
@Mod.EventBusSubscriber(modid="advancementplaques", value={Side.CLIENT})
public class AdvancementPlaques {
    public static final String MODID = "advancementplaques";
    public static final String MODNAME = "Advancement Plaques";
    public static final String MODVERSION = "1.4.10";
    public static final Logger LOGGER = LogManager.getLogger((String)"advancementplaques");
    public static final ResourceLocation TEXTURE_PLAQUES = new ResourceLocation("advancementplaques", "textures/gui/plaques.png");
    public static final ResourceLocation TEXTURE_PLAQUE_EFFECTS = new ResourceLocation("advancementplaques", "textures/gui/plaqueeffect.png");
    public static final SoundEvent TASK_COMPLETE = new SoundEvent(new ResourceLocation("advancementplaques", "ui.toast.task_complete"));
    public static final SoundEvent GOAL_COMPLETE = new SoundEvent(new ResourceLocation("advancementplaques", "ui.toast.goal_complete"));

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register(TASK_COMPLETE.setRegistryName(MODID, "ui.toast.task_complete"));
        event.getRegistry().register(GOAL_COMPLETE.setRegistryName(MODID, "ui.toast.goal_complete"));
    }

    @Mod.EventHandler
    public void onClientSetup(FMLPreInitializationEvent event) {
        AdvancementPlaquesConfig.loadConfig(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void onClientSetup(FMLInitializationEvent event) {
        try {
            AdvancementPlaquesToastGui newToastGui = Loader.isModLoaded((String)"toastcontrol") ? (GuiToast)Class.forName("com.anthonyhilyard.advancementplaques.ui.AdvancementPlaquesToastGuiWithToastControl").getConstructor(Minecraft.class).newInstance(Minecraft.func_71410_x()) : new AdvancementPlaquesToastGui(Minecraft.func_71410_x());
            if (newToastGui != null) {
                Minecraft.func_71410_x().field_193034_aS = newToastGui;
            } else {
                LOGGER.debug("Unable to update Toast GUI, Advancement Plaques will not function properly. Maybe another mod is interfering?");
            }
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

