/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.ui.render;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import com.anthonyhilyard.advancementplaques.config.AdvancementPlaquesConfig;
import com.anthonyhilyard.advancementplaques.ui.AdvancementPlaquesToastGui;
import com.anthonyhilyard.advancementplaques.util.ColorUtil;
import com.anthonyhilyard.advancementplaques.util.CustomItemRenderer;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.toasts.AdvancementToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;

public class AdvancementPlaque {
    private final AdvancementToast toast;
    private long animationTime = -1L;
    private long visibleTime = -1L;
    private boolean hasPlayedSound = false;
    private IToast.Visibility visibility = IToast.Visibility.SHOW;
    private Minecraft minecraft;
    private CustomItemRenderer itemRenderer;

    public AdvancementPlaque(AdvancementToast toastIn, Minecraft mcIn, CustomItemRenderer itemRendererIn) {
        this.toast = toastIn;
        this.minecraft = mcIn;
        this.itemRenderer = itemRendererIn;
    }

    public AdvancementToast getToast() {
        return this.toast;
    }

    public int width() {
        return 256;
    }

    public int height() {
        return 32;
    }

    private float getVisibility(long currentTime) {
        float f = MathHelper.func_76131_a((float)((float)(currentTime - this.animationTime) / 200.0f), (float)0.0f, (float)1.0f);
        f *= f;
        return this.visibility == IToast.Visibility.HIDE ? 1.0f - f : f;
    }

    private IToast.Visibility drawPlaque(long displayTime) {
        DisplayInfo displayInfo = this.toast.field_193679_c.func_192068_c();
        if (displayInfo != null) {
            float alpha;
            float duration;
            float fadeOutTime;
            float fadeInTime;
            switch (displayInfo.func_192291_d()) {
                default: {
                    fadeInTime = (float)((double)AdvancementPlaquesConfig.INSTANCE.taskEffectFadeInTime * 1000.0);
                    fadeOutTime = (float)((double)AdvancementPlaquesConfig.INSTANCE.taskEffectFadeOutTime * 1000.0);
                    duration = (float)((double)AdvancementPlaquesConfig.INSTANCE.taskDuration * 1000.0);
                    break;
                }
                case GOAL: {
                    fadeInTime = (float)((double)AdvancementPlaquesConfig.INSTANCE.goalEffectFadeInTime * 1000.0);
                    fadeOutTime = (float)((double)AdvancementPlaquesConfig.INSTANCE.goalEffectFadeOutTime * 1000.0);
                    duration = (float)((double)AdvancementPlaquesConfig.INSTANCE.goalDuration * 1000.0);
                    break;
                }
                case CHALLENGE: {
                    fadeInTime = (float)((double)AdvancementPlaquesConfig.INSTANCE.challengeEffectFadeInTime * 1000.0);
                    fadeOutTime = (float)((double)AdvancementPlaquesConfig.INSTANCE.challengeEffectFadeOutTime * 1000.0);
                    duration = (float)((double)AdvancementPlaquesConfig.INSTANCE.challengeDuration * 1000.0);
                }
            }
            if ((float)displayTime >= fadeInTime) {
                alpha = 1.0f;
                if ((float)displayTime > duration) {
                    alpha = Math.max(0.0f, Math.min(1.0f, 1.0f - ((float)displayTime - duration) / 1000.0f));
                }
                int tempColor = ColorUtil.parseColor(AdvancementPlaquesConfig.INSTANCE.titleColor);
                int tempAlpha = (int)((float)(tempColor >> 24 & 0xFF) * alpha);
                int titleColor = tempColor & 0xFFFFFF | tempAlpha << 24;
                tempColor = ColorUtil.parseColor(AdvancementPlaquesConfig.INSTANCE.nameColor);
                tempAlpha = (int)((float)(tempColor >> 24 & 0xFF) * alpha);
                int nameColor = tempColor & 0xFFFFFF | tempAlpha << 24;
                this.minecraft.func_110434_K().func_110577_a(AdvancementPlaques.TEXTURE_PLAQUES);
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                int frameOffset = 0;
                if (displayInfo.func_192291_d() == FrameType.GOAL) {
                    frameOffset = 1;
                } else if (displayInfo.func_192291_d() == FrameType.CHALLENGE) {
                    frameOffset = 2;
                }
                AdvancementPlaquesToastGui.func_146110_a((int)-1, (int)-1, (float)0.0f, (float)(this.height() * frameOffset), (int)this.width(), (int)this.height(), (float)256.0f, (float)256.0f);
                if (alpha > 0.1f) {
                    int typeWidth = this.minecraft.field_71466_p.func_78256_a(I18n.func_135052_a((String)("advancements.toast." + displayInfo.func_192291_d().func_192307_a()), (Object[])new Object[0]));
                    this.minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)("advancements.toast." + displayInfo.func_192291_d().func_192307_a()), (Object[])new Object[0]), (int)((float)(this.width() - typeWidth) / 2.0f + 15.0f), 5, titleColor);
                    int titleWidth = this.minecraft.field_71466_p.func_78256_a(displayInfo.func_192297_a().func_150254_d());
                    if ((float)titleWidth <= 146.66667f) {
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.0f);
                        this.minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)displayInfo.func_192297_a().func_150254_d(), (Object[])new Object[0]), (int)(((float)this.width() / 1.5f - (float)titleWidth) / 2.0f + 10.0f), 9, nameColor);
                        GlStateManager.func_179121_F();
                    } else {
                        this.minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)displayInfo.func_192297_a().func_150254_d(), (Object[])new Object[0]), (int)((float)(this.width() - titleWidth) / 2.0f + 15.0f), 15, nameColor);
                    }
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.0f);
                this.itemRenderer.renderItemModelIntoGUIWithAlpha(displayInfo.func_192298_b(), 1, 1, alpha);
                GlStateManager.func_179121_F();
                if (!this.hasPlayedSound) {
                    this.hasPlayedSound = true;
                    try {
                        switch (displayInfo.func_192291_d()) {
                            case TASK: {
                                if (!AdvancementPlaquesConfig.INSTANCE.muteTasks) {
                                    this.minecraft.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_194007_a((SoundEvent)AdvancementPlaques.TASK_COMPLETE, (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                            case GOAL: {
                                if (!AdvancementPlaquesConfig.INSTANCE.muteGoals) {
                                    this.minecraft.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_194007_a((SoundEvent)AdvancementPlaques.GOAL_COMPLETE, (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                            default: {
                                if (!AdvancementPlaquesConfig.INSTANCE.muteChallenges) {
                                    this.minecraft.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_194007_a((SoundEvent)SoundEvents.field_194228_if, (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        AdvancementPlaques.LOGGER.warn("Tried to play a custom sound for an advancement, but that sound was not registered!  Install Advancement Plaques on the server or mute tasks and goals in the config file.");
                    }
                }
            }
            if ((float)displayTime < fadeInTime + fadeOutTime) {
                alpha = 1.0f - ((float)displayTime - fadeInTime) / fadeOutTime;
                if ((float)displayTime < fadeInTime) {
                    alpha = (float)displayTime / fadeInTime;
                }
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)95.0f);
                this.minecraft.func_110434_K().func_110577_a(AdvancementPlaques.TEXTURE_PLAQUE_EFFECTS);
                if (displayInfo.func_192291_d() == FrameType.CHALLENGE) {
                    AdvancementPlaquesToastGui.func_146110_a((int)-16, (int)-16, (float)0.0f, (float)(this.height() + 32), (int)(this.width() + 32), (int)(this.height() + 32), (float)512.0f, (float)512.0f);
                } else {
                    AdvancementPlaquesToastGui.func_146110_a((int)-16, (int)-16, (float)0.0f, (float)0.0f, (int)(this.width() + 32), (int)(this.height() + 32), (float)512.0f, (float)512.0f);
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            return (float)displayTime >= fadeInTime + fadeOutTime + duration ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
        }
        return IToast.Visibility.HIDE;
    }

    public boolean render(int screenWidth, int screenHeight, int index) {
        long currentTime = Minecraft.func_71386_F();
        if (this.animationTime == -1L) {
            this.animationTime = currentTime;
            this.visibility.func_194169_a(this.minecraft.func_147118_V());
        }
        if (this.visibility == IToast.Visibility.SHOW && currentTime - this.animationTime <= 200L) {
            this.visibleTime = currentTime;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        if (AdvancementPlaquesConfig.INSTANCE.onTop) {
            GlStateManager.func_179109_b((float)((float)(screenWidth - this.width()) / 2.0f), (float)AdvancementPlaquesConfig.INSTANCE.distance, (float)(500.0f + (float)index));
        } else {
            GlStateManager.func_179109_b((float)((float)(screenWidth - this.width()) / 2.0f), (float)(screenHeight - (this.height() + AdvancementPlaquesConfig.INSTANCE.distance)), (float)(500.0f + (float)index));
        }
        IToast.Visibility newVisibility = this.drawPlaque(currentTime - this.visibleTime);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        if (newVisibility != this.visibility) {
            this.animationTime = currentTime - (long)((int)((1.0f - this.getVisibility(currentTime)) * 200.0f));
            this.visibility = newVisibility;
        }
        return this.visibility == IToast.Visibility.HIDE && currentTime - this.animationTime > 200L;
    }
}

