/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.util;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;

public class CustomItemRenderer {
    private static Framebuffer iconFrameBuffer = null;
    private static int recreationCount = -1;
    private Minecraft minecraft;
    private final RenderItem itemRenderer;

    public CustomItemRenderer(Minecraft mcIn) {
        this.itemRenderer = mcIn.func_175599_af();
        this.minecraft = mcIn;
        if (iconFrameBuffer == null) {
            CustomItemRenderer.recreateFramebuffer();
            AdvancementPlaques.LOGGER.info("Created icon framebuffer with ID " + CustomItemRenderer.iconFrameBuffer.field_147616_f);
            AdvancementPlaques.LOGGER.info(OpenGlHelper.func_153172_c());
        }
    }

    private static void recreateFramebuffer() {
        if (iconFrameBuffer != null) {
            if (++recreationCount > 1) {
                AdvancementPlaques.LOGGER.error("An error occurred that required the Advancement Plaques framebuffer to be recreated.");
            }
            iconFrameBuffer.func_147608_a();
        }
        iconFrameBuffer = new Framebuffer(96, 96, true);
        iconFrameBuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
    }

    private static boolean tryBindFramebuffer() {
        GlStateManager.func_187434_L();
        iconFrameBuffer.func_147610_a(true);
        if (GlStateManager.func_187434_L() != 0) {
            CustomItemRenderer.recreateFramebuffer();
            iconFrameBuffer.func_147610_a(true);
            if (GlStateManager.func_187434_L() != 0) {
                return false;
            }
        }
        return true;
    }

    public void renderItemModelIntoGUIWithAlpha(ItemStack stack, int x, int y, float alpha) {
        if (!CustomItemRenderer.tryBindFramebuffer()) {
            return;
        }
        IBakedModel bakedModel = this.itemRenderer.func_184393_a(stack, null, null);
        Framebuffer lastFrameBuffer = this.minecraft.func_147110_a();
        iconFrameBuffer.func_147614_f();
        iconFrameBuffer.func_147610_a(true);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)CustomItemRenderer.iconFrameBuffer.field_147622_a, (double)CustomItemRenderer.iconFrameBuffer.field_147620_b, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        this.minecraft.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        this.minecraft.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)48.0f, (float)48.0f, (float)200.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)96.0f, (float)96.0f, (float)96.0f);
        if (bakedModel.func_177556_c()) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
        bakedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        this.itemRenderer.func_180454_a(stack, bakedModel);
        GlStateManager.func_179126_j();
        GlStateManager.func_179140_f();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        this.minecraft.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        this.minecraft.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        if (lastFrameBuffer != null) {
            lastFrameBuffer.func_147610_a(true);
            iconFrameBuffer.func_147612_c();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            Gui.func_152125_a((int)x, (int)(y - 18), (float)0.0f, (float)0.0f, (int)CustomItemRenderer.iconFrameBuffer.field_147621_c, (int)CustomItemRenderer.iconFrameBuffer.field_147618_d, (int)16, (int)16, (float)CustomItemRenderer.iconFrameBuffer.field_147621_c, (float)CustomItemRenderer.iconFrameBuffer.field_147618_d);
            iconFrameBuffer.func_147606_d();
        } else {
            iconFrameBuffer.func_147609_e();
        }
    }

    public static void drawModalRectWithCustomSizedTexture(int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight, float alpha) {
        GlStateManager.func_179098_w();
        GlStateManager.func_179142_g();
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tessellator.func_78381_a();
    }
}

