/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.borutomodaddononero.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.mcreator.borutomodaddononero.ElementsBorutomodaddononeroMod;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.procedure.ProcedureUtils;

@ElementsBorutomodaddononeroMod.ModElement.Tag
public class EntityScalableProjectile
extends ElementsBorutomodaddononeroMod.ModElement {
    public EntityScalableProjectile(ElementsBorutomodaddononeroMod instance) {
        super(instance, 520);
    }

    public static RayTraceResult forwardsRaycastBlocks(Entity projectile) {
        return EntityScalableProjectile.forwardsRaycast(projectile, false, false, null);
    }

    public static RayTraceResult forwardsRaycast(Entity projectile, boolean includeEntities, boolean ignoreExcludedEntity, @Nullable Entity excludedEntity) {
        World world = projectile.field_70170_p;
        Vec3d vec3d = new Vec3d(projectile.field_70165_t, projectile.field_70163_u + (double)(projectile.field_70131_O / 2.0f), projectile.field_70161_v);
        Vec3d vec3d1 = new Vec3d(projectile.field_70159_w, projectile.field_70181_x, projectile.field_70179_y);
        Vec3d vec3d2 = vec3d.func_178787_e(vec3d1);
        AxisAlignedBB bigAABB = projectile.func_174813_aQ().func_72321_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c).func_186662_g(1.0);
        double d0 = 0.0;
        BlockPos blockpos = null;
        EnumFacing facing = null;
        RayTraceResult raytraceresult = null;
        for (AxisAlignedBB aabb : world.func_184144_a(null, bigAABB)) {
            double d;
            RayTraceResult result = aabb.func_72314_b((double)(projectile.field_70130_N / 2.0f), (double)(projectile.field_70131_O / 2.0f), (double)(projectile.field_70130_N / 2.0f)).func_72327_a(vec3d, vec3d2);
            if (result == null || !((d = projectile.func_70092_e(ProcedureUtils.BB.getCenterX((AxisAlignedBB)aabb), ProcedureUtils.BB.getCenterY((AxisAlignedBB)aabb), ProcedureUtils.BB.getCenterZ((AxisAlignedBB)aabb))) < d0) && d0 != 0.0) continue;
            blockpos = new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
            facing = result.field_178784_b;
            d0 = d;
        }
        if (blockpos != null) {
            raytraceresult = new RayTraceResult(new Vec3d(blockpos), facing, blockpos);
        }
        if (includeEntities) {
            Entity entity = null;
            Vec3d hitvec = null;
            for (Entity entity1 : world.func_72839_b(projectile, bigAABB)) {
                double d;
                AxisAlignedBB aabb;
                RayTraceResult result;
                if (!entity1.func_70067_L() || !ignoreExcludedEntity && entity1.equals((Object)excludedEntity) || entity1.field_70145_X || (result = (aabb = entity1.func_174813_aQ().func_72314_b((double)(projectile.field_70130_N / 2.0f), (double)(projectile.field_70131_O / 2.0f), (double)(projectile.field_70130_N / 2.0f))).func_72327_a(vec3d, vec3d2)) == null || !((d = vec3d.func_72438_d(result.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                hitvec = result.field_72307_f;
                d0 = d;
            }
            if (entity != null) {
                raytraceresult = new RayTraceResult(entity, hitvec);
            }
        }
        return raytraceresult;
    }

    public Vec3d getCenter(AxisAlignedBB bb) {
        return new Vec3d(bb.field_72340_a + (bb.field_72336_d - bb.field_72340_a) * 0.5, bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) * 0.5, bb.field_72339_c + (bb.field_72334_f - bb.field_72339_c) * 0.5);
    }

    public static abstract class Base
    extends Entity
    implements IProjectile {
        private static final DataParameter<Float> MODEL_SCALE = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private float ogWidth;
        private float ogHeight;
        public EntityLivingBase shootingEntity;
        private double accelerationX;
        private double accelerationY;
        private double accelerationZ;
        protected int ticksAlive;
        protected int ticksInAir;
        protected int ticksInGround;
        protected int maxInGroundTime = 1200;
        private float motionFactor;
        private float waterSlowdown = 0.8f;

        public Base(World world) {
            super(world);
            this.field_70178_ae = false;
        }

        public Base(EntityLivingBase shooter) {
            this(shooter.field_70170_p);
            this.shootingEntity = shooter;
            this.func_189654_d(true);
            this.func_174805_g(false);
        }

        protected void func_70088_a() {
            this.func_184212_Q().func_187214_a(MODEL_SCALE, (Object)Float.valueOf(1.0f));
        }

        protected void setOGSize(float width, float height) {
            this.ogWidth = width;
            this.ogHeight = height;
            if (this.field_70148_d) {
                this.func_70105_a(width, height);
            }
        }

        public float getEntityScale() {
            return ((Float)this.func_184212_Q().func_187225_a(MODEL_SCALE)).floatValue();
        }

        public void setEntityScale(float scale) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184212_Q().func_187227_b(MODEL_SCALE, (Object)Float.valueOf(scale));
                double x = this.field_70165_t;
                double y = this.field_70163_u;
                double z = this.field_70161_v;
                this.func_70105_a(this.ogWidth * scale, this.ogHeight * scale);
                this.func_70107_b(x, y, z);
            }
        }

        public void func_184206_a(DataParameter<?> key) {
            super.func_184206_a(key);
            if (MODEL_SCALE.equals(key) && this.field_70170_p.field_72995_K) {
                float scale = this.getEntityScale();
                this.func_70105_a(this.ogWidth * scale, this.ogHeight * scale);
            }
        }

        public boolean isLaunched() {
            return this.motionFactor > 0.0f;
        }

        public void haltMotion() {
            this.motionFactor = 0.0f;
            this.accelerationX = 0.0;
            this.accelerationY = 0.0;
            this.accelerationZ = 0.0;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }

        protected void setWaterSlowdown(float f) {
            this.waterSlowdown = f;
        }

        public void func_70186_c(double x, double y, double z, float speed, float inaccuracy) {
            this.shoot(x, y, z, speed, inaccuracy, true);
        }

        public void shoot(double x, double y, double z, float speed, float inaccuracy, boolean updateRotations) {
            x += this.field_70146_Z.nextGaussian() * (double)inaccuracy;
            y += this.field_70146_Z.nextGaussian() * (double)inaccuracy;
            z += this.field_70146_Z.nextGaussian() * (double)inaccuracy;
            if (updateRotations) {
                float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
                this.field_70177_z = (float)(-MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
                this.field_70125_A = (float)(-MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
                if (this.motionFactor == 0.0f) {
                    this.field_70126_B = this.field_70177_z;
                    this.field_70127_C = this.field_70125_A;
                }
            }
            double d0 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            if (this.func_189652_ae()) {
                this.accelerationX = x / d0 * 0.1;
                this.accelerationY = y / d0 * 0.1;
                this.accelerationZ = z / d0 * 0.1;
            } else {
                this.field_70159_w = x / d0 * (double)speed;
                this.field_70181_x = y / d0 * (double)speed;
                this.field_70179_y = z / d0 * (double)speed;
            }
            this.motionFactor = speed;
        }

        public double getAcceleration() {
            return MathHelper.func_76133_a((double)(this.accelerationX * this.accelerationX + this.accelerationY * this.accelerationY + this.accelerationZ * this.accelerationZ)) * this.motionFactor;
        }

        public boolean func_70067_L() {
            return true;
        }

        protected void checkOnGround() {
            AxisAlignedBB aabb;
            BlockPos pos = new BlockPos((Entity)this);
            if (!this.field_70170_p.func_175623_d(pos) && (aabb = this.field_70170_p.func_180495_p(pos).func_185890_d((IBlockAccess)this.field_70170_p, pos)) != Block.field_185506_k && aabb.func_186670_a(pos).func_72318_a(this.func_174791_d())) {
                this.field_70122_E = true;
            }
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            ++this.ticksAlive;
            if (!this.field_70170_p.field_72995_K && this.shootingEntity != null && this.shootingEntity.field_70128_L || !this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
                this.func_70106_y();
            } else {
                this.checkOnGround();
                if (this.field_70122_E) {
                    this.motionFactor = 0.0f;
                    if (++this.ticksInGround > this.maxInGroundTime) {
                        this.func_70106_y();
                    }
                } else {
                    float f = this.motionFactor;
                    if (f > 0.0f) {
                        ++this.ticksInAir;
                        RayTraceResult raytraceresult = this.forwardsRaycast(true, this.ticksInAir >= 25, (Entity)this.shootingEntity);
                        if (raytraceresult != null) {
                            this.onImpact(raytraceresult);
                        }
                    }
                    this.field_70165_t += this.field_70159_w;
                    this.field_70163_u += this.field_70181_x;
                    this.field_70161_v += this.field_70179_y;
                    if (f > 0.0f && !this.func_189652_ae()) {
                        this.updateInFlightRotations();
                    }
                    if (f > 0.0f && this.func_70090_H()) {
                        for (int i = 0; i < 4; ++i) {
                            this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                        }
                        f *= this.waterSlowdown;
                    }
                    if (f > 0.0f && this.func_189652_ae()) {
                        this.field_70159_w += this.accelerationX;
                        this.field_70181_x += this.accelerationY;
                        this.field_70179_y += this.accelerationZ;
                        this.field_70159_w *= (double)f;
                        this.field_70181_x *= (double)f;
                        this.field_70179_y *= (double)f;
                    }
                    if (!this.func_189652_ae()) {
                        this.field_70159_w *= 0.98;
                        this.field_70179_y *= 0.98;
                        this.field_70181_x = this.field_70181_x * 0.98 - 0.04;
                    }
                    this.renderParticles();
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
            }
        }

        protected RayTraceResult forwardsRaycast(boolean includeEntities, boolean ignoreExcludedEntity, @Nullable Entity excludedEntity) {
            RayTraceResult res = EntityScalableProjectile.forwardsRaycast(this, includeEntities, ignoreExcludedEntity, excludedEntity);
            return res != null && res.field_72308_g instanceof Base && ((Base)res.field_72308_g).shootingEntity != null && ((Base)res.field_72308_g).shootingEntity.equals((Object)this.shootingEntity) ? null : res;
        }

        public Random getRNG() {
            return this.field_70146_Z;
        }

        protected abstract void onImpact(RayTraceResult var1);

        public void updateInFlightRotations() {
            double d = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            float yaw = -((float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232));
            float pitch = -((float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)d) * 57.29577951308232));
            while (yaw - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (yaw - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            while (pitch - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (pitch - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (pitch - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (yaw - this.field_70126_B) * 0.2f;
        }

        public void renderParticles() {
            if (this.motionFactor > 0.0f && this.field_70170_p instanceof WorldServer) {
                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, (int)this.getEntityScale(), (double)this.field_70130_N * 0.5, (double)this.field_70131_O * 0.5, (double)this.field_70130_N * 0.5, 0.0, new int[0]);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_70112_a(double distance) {
            return distance <= 4096.0 || super.func_70112_a(distance);
        }

        protected void func_70037_a(NBTTagCompound compound) {
            NBTTagList nbttaglist;
            if (compound.func_150297_b("power", 9) && (nbttaglist = compound.func_150295_c("power", 6)).func_74745_c() == 3) {
                this.accelerationX = nbttaglist.func_150309_d(0);
                this.accelerationY = nbttaglist.func_150309_d(1);
                this.accelerationZ = nbttaglist.func_150309_d(2);
            }
            if (compound.func_150297_b("direction", 9) && compound.func_150295_c("direction", 6).func_74745_c() == 3) {
                NBTTagList nbttaglist1 = compound.func_150295_c("direction", 6);
                this.field_70159_w = nbttaglist1.func_150309_d(0);
                this.field_70181_x = nbttaglist1.func_150309_d(1);
                this.field_70179_y = nbttaglist1.func_150309_d(2);
            } else {
                this.func_70106_y();
            }
            this.setEntityScale(compound.func_74760_g("scale"));
            this.func_70105_a(this.ogWidth * this.getEntityScale(), this.ogHeight * this.getEntityScale());
            this.motionFactor = compound.func_74760_g("speed");
            this.ticksAlive = compound.func_74762_e("life");
            this.ticksInAir = compound.func_74762_e("flighttime");
            this.ticksInGround = compound.func_74762_e("groundtime");
        }

        protected void func_70014_b(NBTTagCompound compound) {
            compound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
            compound.func_74782_a("power", (NBTBase)this.func_70087_a(new double[]{this.accelerationX, this.accelerationY, this.accelerationZ}));
            compound.func_74776_a("scale", this.getEntityScale());
            compound.func_74776_a("speed", this.motionFactor);
            compound.func_74768_a("life", this.ticksAlive);
            compound.func_74768_a("flighttime", this.ticksInAir);
            compound.func_74768_a("groundtime", this.ticksInGround);
        }
    }
}

