/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.box;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxFace;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;

public class BoxPlane {
    public final BoxFace face;
    public final Vector3d normal;
    public final Vector3d origin;

    public BoxPlane(Vector3d[] corners, BoxFace face) {
        this.face = face;
        this.origin = face.first(corners);
        this.normal = face.normal(corners);
    }

    public double getIntersectingScale(Vector3d rayOrigin, Vector3d ray) {
        Double result = BoxPlane.linePlaneIntersection(ray, rayOrigin, this.normal, this.origin);
        if (result == null || result < 0.0) {
            return Double.MAX_VALUE;
        }
        return result;
    }

    public static Double linePlaneIntersection(Vector3d ray, Vector3d rayOrigin, Vector3d normal, Vector3d origin) {
        Double d = normal.dot(origin);
        if (normal.dot(ray) == 0.0) {
            return null;
        }
        return (d - normal.dot(rayOrigin)) / normal.dot(ray);
    }

    public static BoxPlane createPlane(EnumFacing.Axis axis, Vector3d direction, Vector3d[] corners) {
        double value = RotationUtils.get(axis, (Tuple3d)direction);
        if (value == 0.0) {
            return null;
        }
        return new BoxPlane(corners, BoxFace.get(axis, value > 0.0));
    }

    public static BoxPlane createOppositePlane(EnumFacing.Axis axis, Vector3d direction, Vector3d[] corners) {
        double value = RotationUtils.get(axis, (Tuple3d)direction);
        if (value == 0.0) {
            return null;
        }
        return new BoxPlane(corners, BoxFace.get(axis, value < 0.0));
    }
}

