/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.box;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import com.creativemd.creativecore.common.utils.math.collision.CollisionCoordinator;
import com.creativemd.creativecore.common.utils.math.vec.IVecOrigin;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class BoxUtils {
    public static boolean equals(double a, double b, double deviation) {
        return a == b ? true : Math.abs(a - b) < deviation;
    }

    public static boolean greaterEquals(double a, double b, double deviation) {
        return a >= (b > 0.0 ? b - deviation : b + deviation);
    }

    public static boolean insideRect(double one, double two, double minOne, double minTwo, double maxOne, double maxTwo) {
        return one > minOne && one < maxOne && two > minTwo && two < maxTwo;
    }

    public static Vector3d[] getCorners(AxisAlignedBB box) {
        Vector3d[] corners = new Vector3d[BoxCorner.values().length];
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = BoxCorner.values()[i].getVector(box);
        }
        return corners;
    }

    private static double lengthIgnoreAxis(Vector3d vec, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return Math.sqrt(vec.y * vec.y + vec.z * vec.z);
            }
            case Y: {
                return Math.sqrt(vec.x * vec.x + vec.z * vec.z);
            }
            case Z: {
                return Math.sqrt(vec.x * vec.x + vec.y * vec.y);
            }
        }
        return 0.0;
    }

    private static void includeMaxRotationInBox(Box box, Vector3d vec, EnumFacing.Axis axis, CollisionCoordinator coordinator) {
        EnumFacing facing;
        int quarterRotation;
        double rotation = coordinator.getRotationDegree(axis);
        if (rotation == 0.0) {
            return;
        }
        Matrix3d matrix = coordinator.getRotationMatrix(axis);
        Double length = null;
        RotationUtils.BooleanRotation state = RotationUtils.BooleanRotation.getRotationState(axis, vec);
        boolean positive = rotation > 0.0;
        if (rotation >= 90.0) {
            for (quarterRotation = 90; (double)quarterRotation <= Math.abs(rotation) && quarterRotation < 360; quarterRotation += 90) {
                EnumFacing enumFacing = facing = positive ? state.clockwiseMaxFacing() : state.counterMaxClockwiseFacing();
                if (length == null) {
                    length = BoxUtils.lengthIgnoreAxis(vec, axis);
                }
                box.include(facing, length);
                if (coordinator.translation != null) {
                    box.include(facing, length + RotationUtils.get(facing.func_176740_k(), (Tuple3d)coordinator.translation));
                }
                state = state.clockwise();
            }
        }
        matrix.transform((Tuple3d)vec);
        box.include(vec);
        if (quarterRotation <= 360 && !state.is(vec)) {
            EnumFacing enumFacing = facing = positive ? state.clockwiseMaxFacing() : state.counterMaxClockwiseFacing();
            if (length == null) {
                length = BoxUtils.lengthIgnoreAxis(vec, axis);
            }
            box.include(facing, length);
            if (coordinator.translation != null) {
                box.include(facing, length + RotationUtils.get(facing.func_176740_k(), (Tuple3d)coordinator.translation));
            }
        }
    }

    public static AxisAlignedBB getRotatedSurrounding(AxisAlignedBB boundingBox, CollisionCoordinator coordinator) {
        Vector3d[] corners = BoxUtils.getRotatedCorners(boundingBox, coordinator.origin);
        Box bb = new Box();
        for (int i = 0; i < corners.length; ++i) {
            Vector3d vec = corners[i];
            bb.include(vec);
            if (coordinator.hasOnlyTranslation()) {
                vec.add((Tuple3d)coordinator.translation);
                bb.include(vec);
                continue;
            }
            BoxUtils.includeMaxRotationInBox(bb, new Vector3d(vec), EnumFacing.Axis.X, coordinator);
            BoxUtils.includeMaxRotationInBox(bb, new Vector3d(vec), EnumFacing.Axis.Y, coordinator);
            BoxUtils.includeMaxRotationInBox(bb, new Vector3d(vec), EnumFacing.Axis.Z, coordinator);
            coordinator.transform(vec, 1.0);
            bb.include(vec);
        }
        return bb.getAxisBB();
    }

    public static Vector3d[] getRotatedCorners(AxisAlignedBB box, IVecOrigin origin) {
        Vector3d[] corners = BoxUtils.getCorners(box);
        for (int i = 0; i < corners.length; ++i) {
            Vector3d vec = corners[i];
            origin.transformPointToWorld(vec);
        }
        return corners;
    }

    public static Vector3d[] getOuterCorner(EnumFacing facing, IVecOrigin origin, AxisAlignedBB box, double minOne, double minTwo, double maxOne, double maxTwo) {
        Vector3d[] corners = BoxUtils.getCorners(box);
        boolean positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
        double value = 0.0;
        Enum selected = null;
        EnumFacing.Axis axis = facing.func_176740_k();
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst(axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond(axis);
        for (int i = 0; i < corners.length; ++i) {
            Vector3d vec = corners[i];
            origin.transformPointToWorld(vec);
            double vectorValue = RotationUtils.get(axis, (Tuple3d)vec);
            if (selected != null && !(positive ? vectorValue > value : vectorValue < value)) continue;
            selected = BoxCorner.values()[i];
            value = vectorValue;
        }
        return new Vector3d[]{corners[selected.ordinal()], corners[((BoxCorner)selected).neighborOne.ordinal()], corners[((BoxCorner)selected).neighborTwo.ordinal()], corners[((BoxCorner)selected).neighborThree.ordinal()]};
    }

    private static class Box {
        public double minX = Double.MAX_VALUE;
        public double minY = Double.MAX_VALUE;
        public double minZ = Double.MAX_VALUE;
        public double maxX = -1.7976931348623157E308;
        public double maxY = -1.7976931348623157E308;
        public double maxZ = -1.7976931348623157E308;

        public void include(Vector3d vec) {
            this.minX = Math.min(this.minX, vec.x);
            this.minY = Math.min(this.minY, vec.y);
            this.minZ = Math.min(this.minZ, vec.z);
            this.maxX = Math.max(this.maxX, vec.x);
            this.maxY = Math.max(this.maxY, vec.y);
            this.maxZ = Math.max(this.maxZ, vec.z);
        }

        public void include(EnumFacing facing, double value) {
            switch (facing) {
                case EAST: {
                    this.maxX = Math.max(this.maxX, value);
                    break;
                }
                case WEST: {
                    this.minX = Math.min(this.minX, value);
                    break;
                }
                case UP: {
                    this.maxY = Math.max(this.maxY, value);
                    break;
                }
                case DOWN: {
                    this.minY = Math.min(this.minY, value);
                    break;
                }
                case SOUTH: {
                    this.maxZ = Math.max(this.maxZ, value);
                    break;
                }
                case NORTH: {
                    this.minZ = Math.min(this.minZ, value);
                }
            }
        }

        public void translate(Vector3d translation) {
            this.minX += translation.x;
            this.minY += translation.y;
            this.minZ += translation.z;
            this.maxX += translation.x;
            this.maxY += translation.y;
            this.maxZ += translation.z;
        }

        public AxisAlignedBB getAxisBB() {
            return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }
}

