/*
 * Decompiled with CFR 0.152.
 */
package lumien.custommainmenu.handler;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import lumien.custommainmenu.CustomMainMenu;
import lumien.custommainmenu.gui.GuiCustom;
import lumien.custommainmenu.gui.GuiCustomButton;
import lumien.custommainmenu.gui.GuiCustomWrappedButton;
import lumien.custommainmenu.gui.GuiFakeMain;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Level;

public class CMMEventHandler {
    public long displayMs = -1L;
    Field guiField;
    GuiCustom actualGui;

    public CMMEventHandler() {
        try {
            this.guiField = GuiScreenEvent.class.getDeclaredField("gui");
            this.guiField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void openGui(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu) {
            GuiCustom customMainMenu = CustomMainMenu.INSTANCE.config.getGUI("mainmenu");
            if (customMainMenu != null) {
                event.setGui((GuiScreen)customMainMenu);
            }
        } else if (event.getGui() instanceof GuiCustom) {
            GuiCustom custom = (GuiCustom)event.getGui();
            GuiCustom target = CustomMainMenu.INSTANCE.config.getGUI(custom.guiConfig.name);
            if (target != custom) {
                event.setGui((GuiScreen)target);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void initGuiPostEarly(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiCustom) {
            GuiCustom custom = (GuiCustom)event.getGui();
            if (custom.guiConfig.name.equals("mainmenu")) {
                event.setButtonList(new ArrayList());
                this.actualGui = custom;
                try {
                    this.guiField.set(event, (Object)new GuiFakeMain());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void initGuiPost(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiFakeMain) {
            GuiFakeMain fake = (GuiFakeMain)event.getGui();
            HashMap<Integer, GuiButton> removedButtons = new HashMap<Integer, GuiButton>();
            Iterator iterator = event.getButtonList().iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                GuiButton b = (GuiButton)o;
                if (b instanceof GuiCustomButton) continue;
                iterator.remove();
                removedButtons.put(b.field_146127_k, b);
                if (b.field_146127_k == 666 && Loader.isModLoaded((String)"OpenEye")) {
                    CustomMainMenu.INSTANCE.logger.log(Level.DEBUG, "Found OpenEye button, use a wrapped button to config this. (" + b.field_146127_k + ")");
                    continue;
                }
                if (b.field_146127_k == 404 && Loader.isModLoaded((String)"VersionChecker")) {
                    CustomMainMenu.INSTANCE.logger.log(Level.DEBUG, "Found VersionChecker button, use a wrapped button to config this. (" + b.field_146127_k + ")");
                    continue;
                }
                CustomMainMenu.INSTANCE.logger.log(Level.DEBUG, "Found unsupported button, use a wrapped button to config this. (" + b.field_146127_k + ")");
            }
            for (GuiButton o : this.actualGui.getButtonList()) {
                if (!(o instanceof GuiCustomWrappedButton)) continue;
                GuiCustomWrappedButton b = (GuiCustomWrappedButton)o;
                CustomMainMenu.INSTANCE.logger.log(Level.DEBUG, "Initiating Wrapped Button " + b.wrappedButtonID + " with " + removedButtons.get(b.wrappedButtonID));
                b.init((GuiButton)removedButtons.get(b.wrappedButtonID));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (this.displayMs != -1L) {
            if (System.currentTimeMillis() - this.displayMs < 5000L) {
                Minecraft.func_71410_x().field_71466_p.func_175063_a("Error loading config file, see console for more information", 0.0f, 80.0f, 0xFF0000);
            } else {
                this.displayMs = -1L;
            }
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && CustomMainMenu.INSTANCE.config != null) {
            CustomMainMenu.INSTANCE.config.tick();
        }
    }
}

