/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.EventHooks;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.WorldEvent;
import noppes.npcs.api.wrapper.WorldWrapper;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.ForgeScriptData;

public class CmdScript
extends CommandNoppesBase {
    @CommandNoppesBase.SubCommand(desc="Reload scripts and saved data from disks script folder.")
    public Boolean reload(MinecraftServer server, ICommandSender sender, String[] args) {
        ScriptController.Instance.loadCategories();
        if (ScriptController.Instance.loadStoredData()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reload stored data succesfully"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Failed reloading stored data"));
        }
        if (ScriptController.Instance.loadPlayerScripts()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reload player scripts succesfully"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Failed reloading player scripts"));
        }
        if (ScriptController.Instance.loadForgeScripts()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reload forge scripts succesfully"));
            ForgeScriptData data = ScriptController.Instance.forgeScripts;
            data.runScript("onIWorldInitEvent", (Event)new WorldWrapper.onInitIWorldEvent(NpcAPI.Instance().getIWorld(0)));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Failed reloading forge scripts"));
        }
        return true;
    }

    @CommandNoppesBase.SubCommand(desc="Runs scriptCommand in the players scripts", usage="[args]")
    public Boolean run(MinecraftServer server, ICommandSender sender, String[] args) {
        IWorld world = NpcAPI.Instance().getIWorld((WorldServer)sender.func_130014_f_());
        BlockPos bpos = sender.func_180425_c();
        IPos pos = NpcAPI.Instance().getIPos(bpos.func_177958_n(), bpos.func_177956_o(), bpos.func_177952_p());
        WorldEvent.ScriptCommandEvent event = new WorldEvent.ScriptCommandEvent(world, pos, args);
        EventHooks.onWorldScriptEvent(event);
        return true;
    }

    public String func_71517_b() {
        return "script";
    }

    @Override
    public String getDescription() {
        return "Commands for scripts";
    }
}

