/*
 * Decompiled with CFR 0.152.
 */
package sheen.npcs.helper.map;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sheen.npcs.helper.map.QuestWayPointManager;

public class QuestWaypointsNetwork
implements IMessage {
    private int x;
    private int y;
    private int z;
    private Task task;
    private String name;

    public QuestWaypointsNetwork() {
    }

    public QuestWaypointsNetwork(int x, int y, int z, Task task, String name) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.task = task;
        this.name = name;
    }

    public void fromBytes(ByteBuf buf) {
        this.task = Task.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.task.name());
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
    }

    public static enum Task {
        remove,
        add;

    }

    public static class QuestWaypointsNetworkHandle
    implements IMessageHandler<QuestWaypointsNetwork, IMessage> {
        public IMessage onMessage(QuestWaypointsNetwork message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> QuestWaypointsNetworkHandle.add(message));
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private static void add(QuestWaypointsNetwork message) {
            switch (message.task) {
                case add: {
                    QuestWayPointManager.addWayPointClient(message.x, message.y, message.z, message.name);
                    break;
                }
                case remove: {
                    QuestWayPointManager.removeWaypointClient(message.x, message.y, message.z, message.name);
                }
            }
        }
    }
}

