/*
 * Decompiled with CFR 0.152.
 */
package sheen.npcs.helper.render;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTracker;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sheen.npcs.helper.render.FMLMessage;

public class EntitySpawnMessageHelper {
    public static ByteBuf toBytes(FMLMessage.EntitySpawnMessage m, ByteBuf buf) {
        m.toBytes(buf);
        return buf;
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawn(ByteBuf buffer) {
        FMLMessage.EntitySpawnMessage msg = new FMLMessage.EntitySpawnMessage();
        msg.fromBytes(buffer);
        EntitySpawnMessageHelper.spawn(msg);
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawn(FMLMessage.EntitySpawnMessage entitySpawnMessage) {
        EntitySpawnMessageHelper.spawnEntity(entitySpawnMessage);
    }

    public static FMLMessage.EntitySpawnMessage fromBytes(ByteBuf buf) {
        FMLMessage.EntitySpawnMessage msg = new FMLMessage.EntitySpawnMessage();
        msg.fromBytes(buf);
        return msg;
    }

    @SideOnly(value=Side.CLIENT)
    private static void spawnEntity(FMLMessage.EntitySpawnMessage spawnMsg) {
        ModContainer mc = (ModContainer)Loader.instance().getIndexedModList().get(spawnMsg.modId);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, spawnMsg.modEntityTypeId);
        if (er == null) {
            throw new RuntimeException("Could not spawn mod entity ModID: " + spawnMsg.modId + " EntityID: " + spawnMsg.modEntityTypeId + " at ( " + spawnMsg.rawX + "," + spawnMsg.rawY + ", " + spawnMsg.rawZ + ") Please contact mod author or server admin.");
        }
        WorldClient wc = FMLClientHandler.instance().getWorldClient();
        try {
            Entity[] parts;
            Entity entity = er.newInstance((World)wc);
            int offset = spawnMsg.entityId - entity.func_145782_y();
            entity.func_145769_d(spawnMsg.entityId);
            entity.func_184221_a(spawnMsg.entityUUID);
            entity.func_70012_b(spawnMsg.rawX, spawnMsg.rawY, spawnMsg.rawZ, spawnMsg.scaledYaw, spawnMsg.scaledPitch);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).field_70759_as = spawnMsg.scaledHeadYaw;
            }
            if ((parts = entity.func_70021_al()) != null) {
                for (int j = 0; j < parts.length; ++j) {
                    parts[j].func_145769_d(parts[j].func_145782_y() + offset);
                }
            }
            EntityTracker.func_187254_a((Entity)entity, (double)spawnMsg.rawX, (double)spawnMsg.rawY, (double)spawnMsg.rawZ);
            EntityPlayerSP clientPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (entity instanceof IThrowableEntity) {
                EntityPlayerSP thrower = clientPlayer.func_145782_y() == spawnMsg.throwerId ? clientPlayer : wc.func_73045_a(spawnMsg.throwerId);
                ((IThrowableEntity)entity).setThrower((Entity)thrower);
            }
            if (spawnMsg.dataWatcherList != null) {
                entity.func_184212_Q().func_187218_a(spawnMsg.dataWatcherList);
            }
            if (spawnMsg.throwerId > 0) {
                entity.func_70016_h(spawnMsg.speedScaledX, spawnMsg.speedScaledY, spawnMsg.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)entity).readSpawnData(spawnMsg.dataStream);
            }
            wc.func_73027_a(spawnMsg.entityId, entity);
        }
        catch (Exception e) {
            throw new RuntimeException("A severe problem occurred during the spawning of an entity at (" + spawnMsg.rawX + ", " + spawnMsg.rawY + ", " + spawnMsg.rawZ + ")", e);
        }
    }
}

