/*
 * Decompiled with CFR 0.152.
 */
package sheen.npcs.helper.render;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public abstract class FMLMessage {
    abstract void toBytes(ByteBuf var1);

    abstract void fromBytes(ByteBuf var1);

    public static class EntitySpawnMessage
    extends EntityMessage {
        String modId;
        int modEntityTypeId;
        public UUID entityUUID;
        double rawX;
        double rawY;
        double rawZ;
        float scaledYaw;
        float scaledPitch;
        float scaledHeadYaw;
        int throwerId;
        double speedScaledX;
        double speedScaledY;
        double speedScaledZ;
        List<EntityDataManager.DataEntry<?>> dataWatcherList;
        ByteBuf dataStream;

        public EntitySpawnMessage() {
        }

        public EntitySpawnMessage(EntityRegistry.EntityRegistration er, Entity entity, ModContainer modContainer) {
            super(entity);
            this.modId = modContainer.getModId();
            this.modEntityTypeId = er.getModEntityId();
        }

        @Override
        void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modId);
            buf.writeInt(this.modEntityTypeId);
            buf.writeLong(this.entity.func_110124_au().getMostSignificantBits());
            buf.writeLong(this.entity.func_110124_au().getLeastSignificantBits());
            buf.writeDouble(this.entity.field_70165_t);
            buf.writeDouble(this.entity.field_70163_u);
            buf.writeDouble(this.entity.field_70161_v);
            buf.writeByte((int)((byte)(this.entity.field_70177_z * 256.0f / 360.0f)));
            buf.writeByte((int)((byte)(this.entity.field_70125_A * 256.0f / 360.0f)));
            if (this.entity instanceof EntityLivingBase) {
                buf.writeByte((int)((byte)(((EntityLivingBase)this.entity).field_70759_as * 256.0f / 360.0f)));
            } else {
                buf.writeByte(0);
            }
            ByteBuf tmpBuf = Unpooled.buffer();
            PacketBuffer pb = new PacketBuffer(tmpBuf);
            try {
                this.entity.func_184212_Q().func_187216_a(pb);
            }
            catch (IOException e) {
                FMLLog.log.fatal("Encountered fatal exception trying to send entity spawn data watchers", (Throwable)e);
                throw new RuntimeException(e);
            }
            buf.writeBytes(tmpBuf);
            if (this.entity instanceof IThrowableEntity) {
                Entity owner = ((IThrowableEntity)this.entity).getThrower();
                buf.writeInt(owner == null ? this.entity.func_145782_y() : owner.func_145782_y());
                double maxVel = 3.9;
                double mX = this.entity.field_70159_w;
                double mY = this.entity.field_70181_x;
                double mZ = this.entity.field_70179_y;
                if (mX < -maxVel) {
                    mX = -maxVel;
                }
                if (mY < -maxVel) {
                    mY = -maxVel;
                }
                if (mZ < -maxVel) {
                    mZ = -maxVel;
                }
                if (mX > maxVel) {
                    mX = maxVel;
                }
                if (mY > maxVel) {
                    mY = maxVel;
                }
                if (mZ > maxVel) {
                    mZ = maxVel;
                }
                buf.writeInt((int)(mX * 8000.0));
                buf.writeInt((int)(mY * 8000.0));
                buf.writeInt((int)(mZ * 8000.0));
            } else {
                buf.writeInt(0);
            }
            if (this.entity instanceof IEntityAdditionalSpawnData) {
                tmpBuf = Unpooled.buffer();
                ((IEntityAdditionalSpawnData)this.entity).writeSpawnData(tmpBuf);
                buf.writeBytes(tmpBuf);
            }
        }

        @Override
        void fromBytes(ByteBuf dat) {
            super.fromBytes(dat);
            this.modId = ByteBufUtils.readUTF8String((ByteBuf)dat);
            this.modEntityTypeId = dat.readInt();
            this.entityUUID = new UUID(dat.readLong(), dat.readLong());
            this.rawX = dat.readDouble();
            this.rawY = dat.readDouble();
            this.rawZ = dat.readDouble();
            this.scaledYaw = (float)dat.readByte() * 360.0f / 256.0f;
            this.scaledPitch = (float)dat.readByte() * 360.0f / 256.0f;
            this.scaledHeadYaw = (float)dat.readByte() * 360.0f / 256.0f;
            try {
                this.dataWatcherList = EntityDataManager.func_187215_b((PacketBuffer)new PacketBuffer(dat));
            }
            catch (IOException e) {
                FMLLog.log.fatal("There was a critical error decoding the datawatcher stream for a mod entity.", (Throwable)e);
                throw new RuntimeException(e);
            }
            this.throwerId = dat.readInt();
            if (this.throwerId != 0) {
                this.speedScaledX = (double)dat.readInt() / 8000.0;
                this.speedScaledY = (double)dat.readInt() / 8000.0;
                this.speedScaledZ = (double)dat.readInt() / 8000.0;
            }
            this.dataStream = dat.retain();
        }
    }

    public static abstract class EntityMessage
    extends FMLMessage {
        Entity entity;
        int entityId;

        public EntityMessage() {
        }

        EntityMessage(Entity entity) {
            this.entity = entity;
        }

        @Override
        void toBytes(ByteBuf buf) {
            buf.writeInt(this.entity.func_145782_y());
        }

        @Override
        void fromBytes(ByteBuf buf) {
            this.entityId = buf.readInt();
        }
    }
}

