/*
 * Decompiled with CFR 0.152.
 */
package net.decentstudio.jutsublocker.hooklib.minecraft;

import java.util.Map;
import java.util.Optional;
import net.decentstudio.jutsublocker.hooklib.asm.AsmHook;
import net.decentstudio.jutsublocker.hooklib.asm.ClassMetadataReader;
import net.decentstudio.jutsublocker.hooklib.asm.HookClassTransformer;
import net.decentstudio.jutsublocker.hooklib.minecraft.DeobfuscationMetadataReader;
import net.decentstudio.jutsublocker.hooklib.minecraft.HookLibPlugin;
import net.decentstudio.jutsublocker.hooklib.minecraft.MinecraftClassTransformer;
import net.decentstudio.jutsublocker.hooklib.minecraft.PrimaryClassTransformer;
import net.minecraftforge.fml.common.asm.transformers.DeobfuscationTransformer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;

public abstract class HookLoader
implements IFMLLoadingPlugin {
    private static Optional<DeobfuscationTransformer> deobfuscationTransformer = Optional.empty();
    private static ClassMetadataReader deobfuscationMetadataReader = new DeobfuscationMetadataReader();

    static Optional<DeobfuscationTransformer> deobfuscationTransformer() {
        if (HookLibPlugin.getObfuscated() && !deobfuscationTransformer.isPresent()) {
            deobfuscationTransformer = Optional.of(new DeobfuscationTransformer());
        }
        return deobfuscationTransformer;
    }

    public static HookClassTransformer getTransformer() {
        return PrimaryClassTransformer.instance.registeredSecondTransformer ? MinecraftClassTransformer.instance : PrimaryClassTransformer.instance;
    }

    public static void registerHook(AsmHook hook) {
        HookLoader.getTransformer().registerHook(hook);
    }

    public static void registerHookContainer(String className) {
        HookLoader.getTransformer().registerHookContainer(className);
    }

    public static ClassMetadataReader getDeobfuscationMetadataReader() {
        return deobfuscationMetadataReader;
    }

    public String[] getLibraryRequestClass() {
        return null;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        this.registerHooks();
    }

    protected abstract void registerHooks();
}

