/*
 * Decompiled with CFR 0.152.
 */
package net.decentstudio.jutsublocker.manager;

import java.util.HashMap;
import java.util.Map;
import net.decentstudio.jutsublocker.dto.RegionDTO;
import net.decentstudio.jutsublocker.util.TargetUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class RegionsManager {
    public static Map<Integer, RegionDTO> regions = new HashMap<Integer, RegionDTO>();

    public static boolean setRegions(Map<Integer, RegionDTO> regions) {
        if (regions == null || regions.isEmpty()) {
            return false;
        }
        if (RegionsManager.regions.keySet().isEmpty()) {
            RegionsManager.regions = regions;
            return true;
        }
        return false;
    }

    public static boolean addRegion(Integer id, RegionDTO region) {
        if (region != null && !regions.containsKey(id)) {
            regions.put(id, region);
            return true;
        }
        return false;
    }

    public static boolean removeRegion(Integer id) {
        if (id >= 0) {
            regions.remove(id);
            return true;
        }
        return false;
    }

    public static boolean canUseJutsu(boolean atLookLocation, boolean atCurrentLocation, Entity entity) {
        return RegionsManager.canUseJutsu(atLookLocation, atCurrentLocation, entity, "all");
    }

    public static boolean canUseJutsu(boolean atLookLocation, boolean atCurrentLocation, Entity entity, String jutsuName) {
        BlockPos lookPos;
        if (entity == null) {
            return true;
        }
        boolean can = true;
        if (atCurrentLocation) {
            BlockPos entityPos = entity.func_180425_c();
            for (RegionDTO region : regions.values()) {
                if (!region.isInRegion(entityPos) || !region.isJutsuBlocked(jutsuName)) continue;
                can = false;
                break;
            }
        }
        if (can && atLookLocation && (lookPos = TargetUtils.getBlockLookAt(entity, 50)) != null) {
            for (RegionDTO region : regions.values()) {
                if (!region.isInRegion(lookPos) || !region.isJutsuBlocked(jutsuName)) continue;
                can = false;
                break;
            }
        }
        if (!can && entity instanceof EntityPlayer) {
            entity.func_145747_a((ITextComponent)new TextComponentTranslation("jutsublocker.message.jutsu_blocked_in_region", new Object[0]));
        }
        return can;
    }

    public static boolean canPlaceAmaterasu(BlockPos pos) {
        if (pos == null) {
            return true;
        }
        for (RegionDTO region : regions.values()) {
            if (!region.isJutsuBlocked("amaterasu") || !region.isInRegion(pos)) continue;
            return false;
        }
        return true;
    }
}

