/*
 * Decompiled with CFR 0.152.
 */
package net.decentstudio.jutsublocker.network.mod;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.decentstudio.jutsublocker.dto.RegionDTO;
import net.decentstudio.jutsublocker.manager.RegionsManager;
import net.decentstudio.jutsublocker.util.Pair;
import net.decentstudio.jutsublocker.util.RegionDTOMapper;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class C1LoadRegionsPacket
implements IMessage {
    public Map<Integer, RegionDTO> regions = new HashMap<Integer, RegionDTO>();

    public C1LoadRegionsPacket() {
    }

    public C1LoadRegionsPacket(Map<Integer, RegionDTO> regions) {
        this.regions = regions;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        if (size == 0) {
            return;
        }
        for (int index = 0; index < size; ++index) {
            String region = ByteBufUtils.readUTF8String((ByteBuf)buf);
            Pair<Integer, RegionDTO> regionDTO = RegionDTOMapper.toRegionDTO(region);
            this.regions.put(regionDTO.getKey(), regionDTO.getValue());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.regions == null ? 0 : this.regions.size());
        for (Map.Entry<Integer, RegionDTO> entry : this.regions.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)RegionDTOMapper.toBatch(entry.getKey(), entry.getValue()));
        }
    }

    public static class Handler
    implements IMessageHandler<C1LoadRegionsPacket, IMessage> {
        public IMessage onMessage(C1LoadRegionsPacket packet, MessageContext ctx) {
            RegionsManager.setRegions(packet.regions);
            return null;
        }
    }
}

