/*
 * Decompiled with CFR 0.152.
 */
package net.decentstudio.jutsublocker.network.mod;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.decentstudio.jutsublocker.JutsuBlockerMod;
import net.decentstudio.jutsublocker.dto.RegionDTO;
import net.decentstudio.jutsublocker.manager.RegionsManager;
import net.decentstudio.jutsublocker.network.mod.C1LoadRegionsPacket;
import net.decentstudio.jutsublocker.util.Pair;
import net.decentstudio.jutsublocker.util.RegionDTOMapper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class S1LoadRegionsPacket
implements IMessage {
    public Map<Integer, RegionDTO> regions = new HashMap<Integer, RegionDTO>();

    public S1LoadRegionsPacket() {
    }

    public S1LoadRegionsPacket(Map<Integer, RegionDTO> regions) {
        this.regions = regions;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        if (size == 0) {
            return;
        }
        for (int index = 0; index < size; ++index) {
            String region = ByteBufUtils.readUTF8String((ByteBuf)buf);
            Pair<Integer, RegionDTO> regionDTO = RegionDTOMapper.toRegionDTO(region);
            this.regions.put(regionDTO.getKey(), regionDTO.getValue());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.regions == null ? 0 : this.regions.size());
        for (Map.Entry<Integer, RegionDTO> entry : this.regions.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)RegionDTOMapper.toBatch(entry.getKey(), entry.getValue()));
        }
    }

    public static class Handler
    implements IMessageHandler<S1LoadRegionsPacket, IMessage> {
        public IMessage onMessage(S1LoadRegionsPacket packet, MessageContext ctx) {
            if (ctx.side.isServer() && RegionsManager.setRegions(packet.regions)) {
                List playersOnline = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
                for (EntityPlayerMP player : playersOnline) {
                    JutsuBlockerMod.NETWORK.sendTo((IMessage)new C1LoadRegionsPacket(packet.regions), player);
                }
            }
            return null;
        }
    }
}

