/*
 * Decompiled with CFR 0.152.
 */
package net.decentstudio.jutsublocker.network.mod;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.decentstudio.jutsublocker.JutsuBlockerMod;
import net.decentstudio.jutsublocker.dto.RegionDTO;
import net.decentstudio.jutsublocker.manager.RegionsManager;
import net.decentstudio.jutsublocker.network.mod.C2AddRegionPacket;
import net.decentstudio.jutsublocker.util.Pair;
import net.decentstudio.jutsublocker.util.RegionDTOMapper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class S2AddRegionPacket
implements IMessage {
    public Pair<Integer, RegionDTO> regionDTO = null;

    public S2AddRegionPacket() {
    }

    public S2AddRegionPacket(Pair<Integer, RegionDTO> regionDTO) {
        this.regionDTO = regionDTO;
    }

    public void fromBytes(ByteBuf buf) {
        String region = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.regionDTO = RegionDTOMapper.toRegionDTO(region);
    }

    public void toBytes(ByteBuf buf) {
        if (this.regionDTO != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)RegionDTOMapper.toBatch(this.regionDTO.getKey(), this.regionDTO.getValue()));
        }
    }

    public static class Handler
    implements IMessageHandler<S2AddRegionPacket, IMessage> {
        public IMessage onMessage(S2AddRegionPacket packet, MessageContext ctx) {
            if (ctx.side.isServer() && RegionsManager.addRegion(packet.regionDTO.getKey(), packet.regionDTO.getValue())) {
                List playersOnline = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
                for (EntityPlayerMP player : playersOnline) {
                    if (player.equals((Object)ctx.getServerHandler().field_147369_b)) continue;
                    JutsuBlockerMod.NETWORK.sendTo((IMessage)new C2AddRegionPacket(packet.regionDTO), player);
                }
            }
            return null;
        }
    }
}

