/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.item.ItemEightGates;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class PlayerTracker
extends ElementsNarutomodMod.ModElement {
    private static final String BATTLEXP = NarutomodModVariables.BATTLEXP;
    private static final String KEEPXP_RULE = "keepNinjaXp";
    public static final String FORCE_DOJUTSU_DROP_RULE = "forceDojutsuDropOnDeath";
    private static final String FORCE_SEND = "forceSendBattleXP2self";
    private static final String UPDATE_HEALTH = "forceUpdateHealth";

    public PlayerTracker(ElementsNarutomodMod instance) {
        super(instance, 181);
    }

    public static boolean keepNinjaXp(World world) {
        return world.func_82736_K().func_82766_b(KEEPXP_RULE);
    }

    public static boolean isNinja(EntityPlayer player) {
        return player.getEntityData().func_74769_h(BATTLEXP) > 0.0;
    }

    public static double getBattleXp(EntityPlayer player) {
        return player.getEntityData().func_74769_h(BATTLEXP);
    }

    public static double getNinjaLevel(EntityPlayer player) {
        return MathHelper.func_76133_a((double)PlayerTracker.getBattleXp(player));
    }

    public static void addBattleXp(EntityPlayer entity, double xp) {
        PlayerTracker.addBattleXp(entity, xp, true);
    }

    private static void addBattleXp(EntityPlayer entity, double xp, boolean sendMessage) {
        entity.getEntityData().func_74780_a(BATTLEXP, Math.min(PlayerTracker.getBattleXp(entity) + xp, 100000.0));
        if (entity instanceof EntityPlayerMP) {
            PlayerTracker.sendBattleXPToTracking((EntityPlayerMP)entity);
            if (sendMessage) {
                entity.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"chattext.ninjaexperience") + String.format("%.1f", PlayerTracker.getBattleXp(entity))), true);
            }
        }
    }

    private static void logBattleExp(EntityPlayer entity, double xp) {
        if (entity instanceof EntityPlayerMP && ProcedureUtils.advancementAchieved((EntityPlayerMP)entity, "narutomod:ninjaachievement")) {
            PlayerTracker.addBattleXp((EntityPlayer)((EntityPlayerMP)entity), xp);
            ItemEightGates.logBattleXP(entity);
            ItemJutsu.logBattleXP(entity);
            entity.getEntityData().func_74768_a("lastLoggedXpTime", entity.field_70173_aa);
        }
    }

    private static void sendBattleXPToSelf(EntityPlayerMP player) {
        ProcedureSync.EntityNBTTag.sendToSelf(player, BATTLEXP, PlayerTracker.getBattleXp((EntityPlayer)player));
    }

    private static void sendBattleXPToTracking(EntityPlayerMP player) {
        ProcedureSync.EntityNBTTag.sendToTracking((Entity)player, BATTLEXP, PlayerTracker.getBattleXp((EntityPlayer)player));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerHook());
    }

    public class PlayerHook {
        private final Map<Integer, Map<String, Object>> persistentDataMap = Maps.newHashMap();
        private final UUID hp_uuid = UUID.fromString("84d6711b-c26d-4dfa-b0c5-1ff54395f4de");

        @SubscribeEvent
        public void onTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END && event.player instanceof EntityPlayerMP) {
                IAttributeInstance maxHealthAttr;
                AttributeModifier attr;
                double d = PlayerTracker.getBattleXp(event.player) * 0.005;
                if (d > 0.0 && ((attr = (maxHealthAttr = event.player.func_110148_a(SharedMonsterAttributes.field_111267_a)).func_111127_a(this.hp_uuid)) == null || (int)attr.func_111164_d() / 2 != (int)d / 2)) {
                    if (attr != null) {
                        maxHealthAttr.func_188479_b(this.hp_uuid);
                    }
                    maxHealthAttr.func_111121_a(new AttributeModifier(this.hp_uuid, "ninja.maxhealth", d, 0));
                    event.player.func_70606_j(event.player.func_110143_aJ() + 0.1f);
                }
                if (event.player.getEntityData().func_74767_n(PlayerTracker.FORCE_SEND)) {
                    event.player.getEntityData().func_82580_o(PlayerTracker.FORCE_SEND);
                    PlayerTracker.sendBattleXPToTracking((EntityPlayerMP)event.player);
                }
                if (event.player.getEntityData().func_74767_n(PlayerTracker.UPDATE_HEALTH)) {
                    event.player.getEntityData().func_82580_o(PlayerTracker.UPDATE_HEALTH);
                    event.player.func_70606_j(event.player.func_110143_aJ());
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onDeath(LivingDeathEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            if (entity instanceof EntityPlayerMP) {
                Deaths.log((EntityPlayer)entity);
                entity.func_70674_bp();
            }
        }

        private boolean isOffCooldown(Entity entity) {
            int i = entity.field_70173_aa - entity.getEntityData().func_74762_e("lastLoggedXpTime");
            return i < 0 || i > 20;
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void onDamaged(LivingDamageEvent event) {
            Entity targetEntity = event.getEntity();
            Entity sourceEntity = event.getSource().func_76346_g();
            float amount = event.getAmount();
            if (!targetEntity.equals((Object)sourceEntity) && sourceEntity instanceof EntityLivingBase && amount > 0.0f) {
                if (this.isOffCooldown(targetEntity) && targetEntity instanceof EntityPlayer && amount < ((EntityPlayer)targetEntity).func_110143_aJ()) {
                    double bxp = PlayerTracker.getBattleXp((EntityPlayer)targetEntity);
                    PlayerTracker.logBattleExp((EntityPlayer)targetEntity, bxp < 1.0 ? 1.0 : (double)(amount / MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)bxp))));
                }
                if (sourceEntity instanceof EntityPlayer) {
                    double xp = 0.0;
                    if ((targetEntity instanceof EntityPlayer || targetEntity instanceof EntityLiving && !((EntityLiving)targetEntity).func_175446_cd()) && this.isOffCooldown(sourceEntity)) {
                        EntityLivingBase target = (EntityLivingBase)targetEntity;
                        int resistance = target.func_70644_a(MobEffects.field_76429_m) ? target.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 2 : 1;
                        double x = MathHelper.func_76133_a((double)((double)target.func_110138_aP() * ProcedureUtils.getModifiedAttackDamage(target) * (double)MathHelper.func_76133_a((double)(ProcedureUtils.getArmorValue(target) + 1.0)) * (double)Math.min(resistance, 6)));
                        xp = Math.min(x * (double)Math.min(amount / target.func_110138_aP(), 1.0f), 60.0);
                        xp *= sourceEntity.getEntityData().func_74764_b("VEZx") ? sourceEntity.getEntityData().func_74769_h("VEZx") : 0.5;
                    }
                    if (xp > 0.0) {
                        PlayerTracker.logBattleExp((EntityPlayer)sourceEntity, xp);
                    }
                }
            }
        }

        @SubscribeEvent
        public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.player.field_70170_p.field_72995_K) {
                event.player.func_174805_g(true);
                event.player.getEntityData().func_74757_a(PlayerTracker.FORCE_SEND, true);
                event.player.getEntityData().func_74757_a(PlayerTracker.UPDATE_HEALTH, true);
            }
        }

        @SubscribeEvent
        public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (event.player instanceof EntityPlayerMP) {
                event.player.getEntityData().func_74757_a(PlayerTracker.FORCE_SEND, true);
            }
        }

        @SubscribeEvent
        public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Integer i = event.player.func_145782_y();
            if (this.persistentDataMap.containsKey(i)) {
                Map<String, Object> map = this.persistentDataMap.get(i);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    if (entry.getValue() instanceof Boolean) {
                        event.player.getEntityData().func_74757_a(entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                        continue;
                    }
                    if (entry.getValue() instanceof Integer) {
                        event.player.getEntityData().func_74768_a(entry.getKey(), ((Integer)entry.getValue()).intValue());
                        continue;
                    }
                    if (entry.getValue() instanceof Float) {
                        event.player.getEntityData().func_74776_a(entry.getKey(), ((Float)entry.getValue()).floatValue());
                        continue;
                    }
                    if (!(entry.getValue() instanceof Double)) continue;
                    event.player.getEntityData().func_74780_a(entry.getKey(), ((Double)entry.getValue()).doubleValue());
                }
                this.persistentDataMap.remove(i);
            }
        }

        @SubscribeEvent
        public void onClone(PlayerEvent.Clone event) {
            EntityPlayer oldPlayer = event.getOriginal();
            HashMap map = Maps.newHashMap();
            map.put(BATTLEXP, PlayerTracker.getBattleXp(oldPlayer));
            map.put(PlayerTracker.FORCE_SEND, true);
            map.put("MedicalNinjaChecked", oldPlayer.getEntityData().func_74767_n("MedicalNinjaChecked"));
            if (event.isWasDeath()) {
                map.put("ForceExtinguish", 5);
            } else {
                map.put(NarutomodModVariables.FirstGotNinjutsu, oldPlayer.getEntityData().func_74767_n(NarutomodModVariables.FirstGotNinjutsu));
            }
            this.persistentDataMap.put(oldPlayer.func_145782_y(), map);
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            World world = event.getWorld();
            if (!world.field_72995_K && !world.func_82736_K().func_82765_e(PlayerTracker.KEEPXP_RULE)) {
                world.func_82736_K().func_180262_a(PlayerTracker.KEEPXP_RULE, "false", GameRules.ValueType.BOOLEAN_VALUE);
            }
            if (!world.field_72995_K && !world.func_82736_K().func_82765_e(PlayerTracker.FORCE_DOJUTSU_DROP_RULE)) {
                world.func_82736_K().func_180262_a(PlayerTracker.FORCE_DOJUTSU_DROP_RULE, "false", GameRules.ValueType.BOOLEAN_VALUE);
            }
        }
    }

    public static class Deaths {
        private static final List<Deaths> deadPlayers = Lists.newArrayList();
        private final UUID playerId;
        private final double x;
        private final double y;
        private final double z;
        private final long time;
        private final Team team;
        private final double lastXp;

        private Deaths(EntityPlayer player) {
            this.playerId = player.func_110124_au();
            this.x = player.field_70165_t;
            this.y = player.field_70163_u;
            this.z = player.field_70161_v;
            this.time = player.field_70170_p.func_82737_E();
            this.team = player.func_96124_cp();
            this.lastXp = PlayerTracker.getBattleXp(player);
        }

        public static void log(EntityPlayer entity) {
            Iterator<Deaths> iter = deadPlayers.iterator();
            while (iter.hasNext()) {
                Deaths death = iter.next();
                if (!death.playerId.equals(entity.func_110124_au())) continue;
                iter.remove();
            }
            deadPlayers.add(new Deaths(entity));
            if (!PlayerTracker.keepNinjaXp(entity.field_70170_p)) {
                entity.getEntityData().func_74780_a(BATTLEXP, 0.0);
                if (entity instanceof EntityPlayerMP) {
                    PlayerTracker.sendBattleXPToTracking((EntityPlayerMP)entity);
                }
            }
        }

        public static void clear() {
            deadPlayers.clear();
        }

        public static Deaths mostRecent() {
            if (!deadPlayers.isEmpty()) {
                return deadPlayers.get(deadPlayers.size());
            }
            return null;
        }

        public static boolean hasRecentNearby(EntityPlayer player, double distance, double timeframe) {
            return Deaths.hasRecentNearby(player, distance, timeframe, true);
        }

        public static boolean hasRecentNearby(EntityPlayer player, double distance, double timeframe, boolean checkTeam) {
            if (deadPlayers.isEmpty()) {
                return false;
            }
            int i = deadPlayers.size();
            while (--i >= 0) {
                double d2;
                double d1;
                double d0;
                double d3;
                Deaths deadguy = deadPlayers.get(i);
                if (deadguy.playerId.equals(player.func_110124_au()) || !((d3 = (d0 = deadguy.x - player.field_70165_t) * d0 + (d1 = deadguy.y - player.field_70163_u) * d1 + (d2 = deadguy.z - player.field_70161_v) * d2) < distance * distance) || !((double)(player.field_70170_p.func_82737_E() - deadguy.time) <= timeframe) || checkTeam && !player.func_184194_a(deadguy.team)) continue;
                return true;
            }
            return false;
        }

        public static boolean hasRecentMatching(EntityPlayer player, double timeframe) {
            if (!deadPlayers.isEmpty()) {
                int i = deadPlayers.size();
                while (--i >= 0) {
                    Deaths deadguy = deadPlayers.get(i);
                    if (!deadguy.playerId.equals(player.func_110124_au())) continue;
                    return true;
                }
            }
            return false;
        }

        public static long mostRecentTime(EntityPlayer player) {
            if (!deadPlayers.isEmpty()) {
                int i = deadPlayers.size();
                while (--i >= 0) {
                    Deaths deadguy = deadPlayers.get(i);
                    if (!deadguy.playerId.equals(player.func_110124_au())) continue;
                    return deadguy.time;
                }
            }
            return 0L;
        }

        public static double getXpBeforeDeath(EntityPlayer player) {
            if (!deadPlayers.isEmpty()) {
                int i = deadPlayers.size();
                while (--i >= 0) {
                    Deaths deadguy = deadPlayers.get(i);
                    if (!deadguy.playerId.equals(player.func_110124_au())) continue;
                    return deadguy.lastXp;
                }
            }
            return 0.0;
        }
    }
}

