/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod;

import java.util.Arrays;
import java.util.List;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityEightTails;
import net.narutomod.entity.EntityFiveTails;
import net.narutomod.entity.EntityFourTails;
import net.narutomod.entity.EntityNineTails;
import net.narutomod.entity.EntityOneTail;
import net.narutomod.entity.EntitySevenTails;
import net.narutomod.entity.EntitySixTails;
import net.narutomod.entity.EntityTenTails;
import net.narutomod.entity.EntityThreeTails;
import net.narutomod.entity.EntityTwoTails;
import net.narutomod.event.SpecialEvent;

@ElementsNarutomodMod.ModElement.Tag
public class SaveData
extends ElementsNarutomodMod.ModElement {
    private static final List<ISaveData> savedataList = Arrays.asList(new SpecialEvent.Save(), new EntityTenTails.Save(), new EntityNineTails.Save(), new EntityEightTails.Save(), new EntitySevenTails.Save(), new EntitySixTails.Save(), new EntityFiveTails.Save(), new EntityFourTails.Save(), new EntityThreeTails.Save(), new EntityTwoTails.Save(), new EntityOneTail.Save());

    public SaveData(ElementsNarutomodMod instance) {
        super(instance, 334);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHook());
    }

    public class EventHook {
        private boolean loaded = false;

        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload event) {
            World world = event.getWorld();
            if (!world.field_72995_K && world.field_73011_w.getDimension() == 0) {
                for (ISaveData savedata : savedataList) {
                    savedata.resetData();
                }
                this.loaded = false;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onEntityJoinWorld(EntityJoinWorldEvent event) {
            if (!event.getWorld().field_72995_K && !this.loaded) {
                System.out.println("Loading all save data for mod narutomod");
                for (ISaveData savedata : savedataList) {
                    savedata.loadData();
                }
                this.loaded = true;
            }
        }
    }

    public static interface ISaveData {
        public WorldSavedData loadData();

        public void resetData();
    }
}

