/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.event.EventDelayedCallback;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class BlockPortalBlock
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:portalblock")
    public static final Block block = null;

    public BlockPortalBlock(ElementsNarutomodMod instance) {
        super(instance, 276);
    }

    @Override
    public void initElements() {
        this.elements.blocks.add(() -> new BlockCustom());
        this.elements.items.add(() -> (Item)new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntityCustom.class, (String)"narutomod:tileentityportalblock");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:portalblock", "inventory"));
    }

    public static class TileEntityCustom
    extends TileEntityEndPortal {
        private static final EventCallback CB = new EventCallback();
        private EnumFacing facing;
        private BlockPos pairPos;
        private int ticksExisted;
        private int cooldown = 10;

        public TileEntityCustom(EnumFacing side) {
            this.facing = side;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_184313_a(EnumFacing side) {
            return side == this.facing;
        }

        public void setPair(BlockPos pos) {
            this.pairPos = pos;
        }

        public void update() {
            ++this.ticksExisted;
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }

        public void teleportEntity(Entity entity) {
            TileEntity tileentity;
            if (this.pairPos != null && this.cooldown <= 10 && (tileentity = this.field_145850_b.func_175625_s(this.pairPos)) instanceof TileEntityCustom) {
                TileEntityCustom te = (TileEntityCustom)tileentity;
                this.cooldown = 20;
                if (!this.field_145850_b.field_72995_K) {
                    entity.field_70177_z = te.facing.func_185119_l();
                    if (entity instanceof EntityPlayerMP) {
                        ProcedureUtils.setInvulnerableDimensionChange((EntityPlayerMP)entity);
                        new EventDelayedCallback(this.field_145850_b, 0, 0, 0, entity, this.field_145850_b.func_82737_E() + 3L, CB);
                    }
                    entity.func_70634_a((double)this.pairPos.func_177958_n() + 0.5 + (double)te.facing.func_82601_c(), (double)this.pairPos.func_177956_o() - (this.field_145850_b.func_180495_p(this.pairPos.func_177977_b()).func_177230_c() == block ? 1.0 : 0.0), (double)this.pairPos.func_177952_p() + 0.5 + (double)te.facing.func_82599_e());
                }
            }
        }

        public static class EventCallback
        extends EventDelayedCallback.Callback {
            public EventCallback() {
                super(276);
            }

            @Override
            public void execute(World world, int x, int y, int z, @Nullable Entity entity) {
                if (entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).func_184850_K()) {
                    ((EntityPlayerMP)entity).func_184846_L();
                }
            }
        }
    }

    public static class BlockCustom
    extends BlockEndPortal {
        public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
        protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.3);
        protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.7, 1.0, 1.0, 1.0);
        protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.3, 1.0, 1.0);
        protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.7, 0.0, 0.0, 1.0, 1.0, 1.0);

        public BlockCustom() {
            super(Material.field_151567_E);
            this.setRegistryName("portalblock");
            this.func_149663_c("portalblock");
            this.func_149647_a(null);
            this.func_149722_s();
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        }

        public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
            if ((EnumFacing)state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
                return SOUTH_AABB;
            }
            if ((EnumFacing)state.func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
                return EAST_AABB;
            }
            if ((EnumFacing)state.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
                return WEST_AABB;
            }
            return NORTH_AABB;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
            return side != EnumFacing.UP && side != EnumFacing.DOWN;
        }

        public TileEntity func_149915_a(World worldIn, int meta) {
            return new TileEntityCustom(EnumFacing.func_82600_a((int)meta));
        }

        public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }

        public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
            super.func_180650_b(world, pos, state, random);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityCustom) {
                TileEntityCustom te2 = (TileEntityCustom)te;
                te2.update();
                if (te2.cooldown == 0) {
                    world.func_175698_g(pos);
                    return;
                }
            }
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof TileEntityCustom) {
                ((TileEntityCustom)tileentity).teleportEntity(entity);
            }
        }

        public Item func_180660_a(IBlockState state, Random rand, int fortune) {
            return Items.field_190931_a;
        }

        public IBlockState func_176203_a(int meta) {
            EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
            if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
                enumfacing = EnumFacing.NORTH;
            }
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }

        public int func_176201_c(IBlockState state) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{FACING});
        }
    }
}

