/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityBeamBase
extends ElementsNarutomodMod.ModElement {
    private static int texIncrement = 0;

    public EntityBeamBase(ElementsNarutomodMod instance) {
        super(instance, 283);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(Base.class, renderManager -> new Renderer(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public static class Model
    extends ModelBase {
        private final ModelRenderer bone;

        public Model() {
            this(1.0f);
        }

        public Model(float length) {
            this.field_78090_t = 16;
            this.field_78089_u = 16;
            this.bone = new ModelRenderer((ModelBase)this);
            this.bone.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 0, -3.0f, 0.0f, -0.5f, 1, (int)(16.0f * length), 1, 0.0f, true));
            this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 0, 2.0f, 0.0f, -0.5f, 1, (int)(16.0f * length), 1, 0.0f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.bone.func_78785_a(f5);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Renderer<T extends Base>
    extends Render<T> {
        private static final ResourceLocation texture = new ResourceLocation("narutomod:textures/beam.png");

        public Renderer(RenderManager renderManager) {
            super(renderManager);
            this.field_76989_e = 0.1f;
        }

        public Model getMainModel(T entity) {
            return new Model(((Base)((Object)entity)).getBeamLength());
        }

        public boolean shouldRender(T livingEntity, ICamera camera, double camX, double camY, double camZ) {
            return true;
        }

        public void doRender(T bullet, double x, double y, double z, float yaw, float pt) {
            this.func_180548_c((Entity)bullet);
            GlStateManager.func_179094_E();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            GlStateManager.func_179114_b((float)(((Base)((Object)bullet)).field_70126_B + MathHelper.func_76142_g((float)(((Base)((Object)bullet)).field_70177_z - ((Base)((Object)bullet)).field_70126_B)) * pt), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(90.0f - ((Base)((Object)bullet)).field_70127_C - (((Base)((Object)bullet)).field_70125_A - ((Base)((Object)bullet)).field_70127_C) * pt), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float f = --texIncrement;
            GlStateManager.func_179109_b((float)(f * 0.01f), (float)(f * 0.02f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            this.getMainModel(bullet).func_78088_a((Entity)bullet, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179145_e();
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(T entity) {
            return texture;
        }
    }

    public static abstract class Base
    extends Entity {
        private static final DataParameter<Integer> SHOOTER_ID = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Float> BEAM_LENGTH = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        public int ticksAlive;
        public Entity shootingEntity;
        public RayTraceResult hitTrace;

        public Base(World a) {
            super(a);
            this.field_70130_N = 0.125f;
            this.field_70131_O = 0.125f;
            this.ticksAlive = 0;
            this.field_70158_ak = true;
        }

        public Base(World worldIn, double x, double y, double z) {
            this(worldIn);
            this.func_70012_b(x, y, z, 0.0f, 0.0f);
            this.func_174805_g(false);
        }

        public Base(EntityLivingBase shooter) {
            this(shooter.field_70170_p, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
            this.field_70127_C = this.field_70125_A = shooter.field_70125_A;
            this.field_70126_B = this.field_70177_z = shooter.field_70177_z;
            this.setShooter(shooter);
        }

        protected void func_70088_a() {
            this.func_184212_Q().func_187214_a(SHOOTER_ID, (Object)-1);
            this.func_184212_Q().func_187214_a(BEAM_LENGTH, (Object)Float.valueOf(1.0f));
        }

        private void setShooter(EntityLivingBase shooter) {
            this.func_184212_Q().func_187227_b(SHOOTER_ID, (Object)shooter.func_145782_y());
            this.shootingEntity = shooter;
        }

        protected EntityLivingBase getShooter() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(SHOOTER_ID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        public float getBeamLength() {
            return ((Float)this.func_184212_Q().func_187225_a(BEAM_LENGTH)).floatValue();
        }

        protected void setBeamLength(float length) {
            this.func_184212_Q().func_187227_b(BEAM_LENGTH, (Object)Float.valueOf(length));
        }

        public void shoot(double range) {
            if (this.shootingEntity != null) {
                this.hitTrace = ProcedureUtils.objectEntityLookingAt(this.shootingEntity, range);
                this.shoot(this.hitTrace.field_72307_f.field_72450_a - this.field_70165_t, this.hitTrace.field_72307_f.field_72448_b - this.field_70163_u, this.hitTrace.field_72307_f.field_72449_c - this.field_70161_v);
            }
        }

        public void shoot(double x, double y, double z) {
            if (this.hitTrace == null) {
                this.hitTrace = new RayTraceResult(new Vec3d(this.field_70165_t + x, this.field_70163_u + y, this.field_70161_v + z), EnumFacing.func_176737_a((float)((float)x), (float)((float)y), (float)((float)z)).func_176734_d());
            }
            float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            this.setBeamLength(f + 0.1f);
            y /= (double)f;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            float f1 = MathHelper.func_76133_a((double)((x /= (double)f) * x + (z /= (double)f) * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }

        protected void updatePosition() {
        }

        public void func_70071_h_() {
            if (this.field_70170_p.field_72995_K && this.field_70126_B == 0.0f && this.field_70127_C == 0.0f) {
                this.field_70126_B = this.field_70177_z;
                this.field_70127_C = this.field_70125_A;
            }
            this.updatePosition();
            ++this.ticksAlive;
        }

        public void func_174812_G() {
        }

        public void func_70014_b(NBTTagCompound compound) {
            compound.func_74776_a("beamLength", this.getBeamLength());
            compound.func_74768_a("life", this.ticksAlive);
        }

        public void func_70037_a(NBTTagCompound compound) {
            this.setBeamLength(compound.func_74760_g("beamLength"));
            this.ticksAlive = compound.func_74762_e("life");
        }
    }
}

