/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.PlayerTracker;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.item.ItemIryoJutsu;
import net.narutomod.item.ItemJutsu;

@ElementsNarutomodMod.ModElement.Tag
public class EntityCellularActivation
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 213;
    public static final int ENTITYID_RANGED = 214;

    public EntityCellularActivation(ElementsNarutomodMod instance) {
        super(instance, 527);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "cellular_activation"), 213).name("cellular_activation").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderCustom(renderManager));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EC.UserHook());
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends Render<EC> {
        public RenderCustom(RenderManager rendermanager) {
            super(rendermanager);
        }

        public boolean shouldRender(EC livingEntity, ICamera camera, double camX, double camY, double camZ) {
            return true;
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
            EntityLivingBase user = entity.getUser();
            if (user != null && entity.getReductionAmount() > 0) {
                x = user.field_70142_S + (user.field_70165_t - user.field_70142_S) * (double)partialTicks;
                y = user.field_70137_T + (user.field_70163_u - user.field_70137_T) * (double)partialTicks;
                z = user.field_70136_U + (user.field_70161_v - user.field_70136_U) * (double)partialTicks;
                Particles.spawnParticle(entity.field_70170_p, Particles.Types.SMOKE, x, y + (double)(user.field_70131_O / 2.0f), z, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0xFFF6 | 16 + user.func_70681_au().nextInt(32) << 24, 10 + user.func_70681_au().nextInt(25), 5, 240, -1);
            }
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return null;
        }
    }

    public static class EC
    extends Entity {
        private static final DataParameter<Integer> USER_ID = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Integer> REDUCTION = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187192_b);
        private final double chakraBurn;

        public EC(World worldIn) {
            super(worldIn);
            this.chakraBurn = ItemIryoJutsu.MEDMODE.chakraUsage;
            this.func_70105_a(0.01f, 0.01f);
        }

        public EC(EntityLivingBase userIn) {
            this(userIn.field_70170_p);
            this.setUser(userIn);
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
        }

        protected void func_70088_a() {
            this.field_70180_af.func_187214_a(USER_ID, (Object)-1);
            this.field_70180_af.func_187214_a(REDUCTION, (Object)0);
        }

        private void setUser(EntityLivingBase user) {
            this.func_184212_Q().func_187227_b(USER_ID, (Object)user.func_145782_y());
        }

        @Nullable
        protected EntityLivingBase getUser() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(USER_ID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        private void setReductionAmount(int amount) {
            this.func_184212_Q().func_187227_b(REDUCTION, (Object)amount);
        }

        private int getReductionAmount() {
            return (Integer)this.field_70180_af.func_187225_a(REDUCTION);
        }

        public void func_70071_h_() {
            EntityLivingBase user = this.getUser();
            if (user != null) {
                this.func_70107_b(user.field_70165_t, user.field_70163_u, user.field_70161_v);
                int i = this.getReductionAmount();
                if (i > 0) {
                    this.setReductionAmount(i - 1);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        public void reduceDamage(LivingHurtEvent event) {
            EntityLivingBase user = this.getUser();
            if (user != null) {
                int i;
                int n = user instanceof EntityPlayer ? (int)PlayerTracker.getNinjaLevel((EntityPlayer)user) : (i = user instanceof EntityNinjaMob.Base ? ((EntityNinjaMob.Base)user).getNinjaLevel() : 1);
                if (i >= 10) {
                    Chakra.Pathway cp = Chakra.pathway(user);
                    float reduction = event.getAmount() * (1.0f - 1.0f / (float)(i - 8));
                    this.setReductionAmount(this.getReductionAmount() + (int)reduction);
                    double chakrausage = this.chakraBurn * (double)reduction;
                    if (chakrausage > cp.getAmount()) {
                        reduction *= (float)(cp.getAmount() / chakrausage);
                        chakrausage = cp.getAmount();
                    }
                    if (reduction > 0.0f && cp.consume(chakrausage)) {
                        event.setAmount(event.getAmount() - reduction);
                    }
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_70112_a(double distance) {
            double d = 68.5 * this.func_184183_bd();
            return distance < d * d;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class UserHook {
            @SubscribeEvent
            public void onUserDamaged(LivingHurtEvent event) {
                EntityLivingBase entity = event.getEntityLiving();
                Entity entity1 = entity.field_70170_p.func_73045_a(entity.getEntityData().func_74762_e("IryoCellularActivationEntityIdKey"));
                if (entity1 instanceof EC && entity1.func_70089_S()) {
                    ((EC)entity1).reduceDamage(event);
                }
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ID_KEY = "IryoCellularActivationEntityIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Entity entity1 = entity.field_70170_p.func_73045_a(entity.getEntityData().func_74762_e(ID_KEY));
                if (entity1 instanceof EC) {
                    entity1.func_70106_y();
                    return false;
                }
                entity1 = new EC(entity);
                entity.field_70170_p.func_72838_d(entity1);
                entity.getEntityData().func_74768_a(ID_KEY, entity1.func_145782_y());
                return true;
            }
        }
    }
}

