/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.Particles;
import net.narutomod.PlayerTracker;
import net.narutomod.block.BlockLightSource;
import net.narutomod.entity.EntityKageBunshin;
import net.narutomod.entity.EntityLightningArc;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.item.ItemFuton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemRaiton;
import net.narutomod.procedure.ProcedureRenderView;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityChidori
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 141;
    public static final int ENTITYID_RANGED = 142;
    public static final double CHAKRA_USAGE = 150.0;
    private static final double CHAKRA_BURN = 40.0;

    public EntityChidori(ElementsNarutomodMod instance) {
        super(instance, 396);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "chidori"), 141).name("chidori").tracker(64, 3, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(Spear.class).id(new ResourceLocation("narutomod", "chidori_spear"), 142).name("chidori_spear").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderChidori(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderChidori
        extends Render<EC> {
            public RenderChidori(RenderManager renderManagerIn) {
                super(renderManagerIn);
            }

            public boolean shouldRender(EC livingEntity, ICamera camera, double camX, double camY, double camZ) {
                return true;
            }

            private Vec3d transform3rdPerson(Vec3d startvec, Vec3d angles, EntityLivingBase entity, EnumHandSide side, float pt) {
                return ProcedureUtils.rotateRoll(startvec, (float)angles.field_72449_c).func_178789_a((float)(-angles.field_72450_a)).func_178785_b((float)(-angles.field_72448_b)).func_72441_c((double)(0.0586f * (float)(side == EnumHandSide.RIGHT ? -6 : 6)), (double)(1.3f - (entity.func_70093_af() ? 0.3f : 0.0f)), (double)-0.05f).func_178785_b(-this.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, pt) * ((float)Math.PI / 180)).func_72441_c(entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)pt, entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)pt, entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)pt);
            }

            public void doRender(EC entity, double x, double y, double z, float f, float partialTicks) {
                EntityLivingBase user = entity.getOwner();
                if (user != null) {
                    Entity viewer = Minecraft.func_71410_x().func_175606_aa();
                    RenderLivingBase renderer = (RenderLivingBase)this.field_76990_c.func_78713_a((Entity)user);
                    ModelRenderer rightarmModel = ((ModelBiped)renderer.func_177087_b()).field_178723_h;
                    Vec3d rightarmAngles = new Vec3d((double)rightarmModel.field_78795_f, (double)rightarmModel.field_78796_g, (double)rightarmModel.field_78808_h);
                    ModelRenderer leftarmModel = ((ModelBiped)renderer.func_177087_b()).field_178724_i;
                    Vec3d leftarmAngles = new Vec3d((double)leftarmModel.field_78795_f, (double)leftarmModel.field_78796_g, (double)leftarmModel.field_78808_h);
                    EnumHandSide mainhandside = user.func_184591_cq();
                    Vec3d mainarmAngles = mainhandside == EnumHandSide.RIGHT ? rightarmAngles : leftarmAngles;
                    Vec3d offarmAngles = mainhandside == EnumHandSide.RIGHT ? leftarmAngles : rightarmAngles;
                    boolean flag1 = entity.isHoldingWeapon(EnumHand.MAIN_HAND);
                    boolean flag2 = entity.isHoldingWeapon(EnumHand.OFF_HAND);
                    if (!flag1) {
                        mainarmAngles = this.forceRightArmBowPose(mainarmAngles, user, partialTicks);
                        Vec3d vec0 = this.transform3rdPerson(new Vec3d(0.0, -0.7, 0.0), mainarmAngles, user, mainhandside, partialTicks);
                        Particles.spawnParticle(entity.field_70170_p, Particles.Types.SMOKE, vec0.field_72450_a, vec0.field_72448_b, vec0.field_72449_c, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0x20FFFFFF, 5 + user.func_70681_au().nextInt(55), 5, 240, -1, 0);
                        if (!(entity instanceof Spear)) {
                            EntityLightningArc.spawnAsParticle(entity.field_70170_p, vec0.field_72450_a, vec0.field_72448_b, vec0.field_72449_c, entity.getGrowth(), 0.0, 0.0, 0.0, -1073741569, 1);
                        }
                        if (viewer.equals((Object)user)) {
                            ProcedureSync.CPacketVec3d.sendToServer(entity, vec0);
                        }
                    } else {
                        Vec3d vec1;
                        Vec3d vec0;
                        if (flag1 && entity.field_70170_p.field_73012_v.nextFloat() <= 0.01f) {
                            vec0 = this.transform3rdPerson(new Vec3d(0.0, -0.6875, 0.2), mainarmAngles, user, mainhandside, partialTicks);
                            vec1 = this.transform3rdPerson(new Vec3d(0.0, -0.6875, 1.6), mainarmAngles, user, mainhandside, partialTicks).func_178788_d(vec0).func_186678_a(0.2);
                            vec0 = vec0.func_178787_e(vec1);
                            EntityLightningArc.spawnAsParticle(entity.field_70170_p, vec0.field_72450_a, vec0.field_72448_b, vec0.field_72449_c, 0.01, vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, new int[0]);
                            if (viewer.equals((Object)user)) {
                                ProcedureSync.CPacketVec3d.sendToServer(entity, vec0);
                            }
                        }
                        if (flag2 && entity.field_70170_p.field_73012_v.nextFloat() <= 0.01f) {
                            vec0 = this.transform3rdPerson(new Vec3d(0.0, -0.6875, 0.2), offarmAngles, user, mainhandside.func_188468_a(), partialTicks);
                            vec1 = this.transform3rdPerson(new Vec3d(0.0, -0.6875, 1.6), offarmAngles, user, mainhandside.func_188468_a(), partialTicks).func_178788_d(vec0).func_186678_a(0.2);
                            vec0 = vec0.func_178787_e(vec1);
                            EntityLightningArc.spawnAsParticle(entity.field_70170_p, vec0.field_72450_a, vec0.field_72448_b, vec0.field_72449_c, 0.01, vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, new int[0]);
                        }
                    }
                }
            }

            private Vec3d forceRightArmBowPose(Vec3d ogvec, EntityLivingBase owner, float partialTicks) {
                float f = this.interpolateRotation(owner.field_70760_ar, owner.field_70761_aq, partialTicks);
                float f1 = this.interpolateRotation(owner.field_70758_at, owner.field_70759_as, partialTicks);
                float f2 = (f1 - f) * ((float)Math.PI / 180);
                float f7 = (owner.field_70127_C + (owner.field_70125_A - owner.field_70127_C) * partialTicks) * ((float)Math.PI / 180);
                return new Vec3d((double)(-1.5707964f + f7), (double)(-0.1f + f2), ogvec.field_72449_c);
            }

            private float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
                return prevYawOffset + ProcedureUtils.Vec2f.wrapDegrees(yawOffset - prevYawOffset) * partialTicks;
            }

            protected ResourceLocation getEntityTexture(EC entity) {
                return null;
            }
        }
    }

    public static class Spear
    extends EC {
        private boolean ryu;

        public Spear(World worldIn) {
            super(worldIn);
        }

        protected Spear(EntityLivingBase summonerIn, double chakraPerSec) {
            super(summonerIn, chakraPerSec, 81);
            if (summonerIn.func_70093_af()) {
                this.ryu = true;
            }
        }

        @Override
        public void func_70071_h_() {
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1 && this.summoner instanceof EntityPlayer) {
                ProcedureSync.EntityNBTTag.setAndSync((Entity)this.summoner, NarutomodModVariables.forceBowPose, true);
            }
            if (this.summoner != null) {
                this.setPositionToSummoner();
                if (this.field_70173_aa % 20 == 1 && !Chakra.pathway(this.summoner).consume(40.0)) {
                    this.func_70106_y();
                }
            }
            if (this.field_70146_Z.nextFloat() <= 0.3f) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:electricity")), 1.0f, this.field_70146_Z.nextFloat() * 2.0f + 1.5f);
            }
            if (this.summoner != null && this.field_70173_aa <= this.duration) {
                if (this.ryu) {
                    for (Entity entity1 : this.field_70170_p.func_72839_b((Entity)this.summoner, this.summoner.func_174813_aQ().func_186662_g(4.0))) {
                        if (entity1 instanceof EntityLightningArc.Base || this.field_70146_Z.nextInt(3) != 0) continue;
                        EntityLightningArc.Base entity2 = new EntityLightningArc.Base(this.field_70170_p, this.summoner.func_174791_d().func_72441_c(0.0, 1.0, 0.0), entity1.func_174791_d().func_72441_c(0.0, (double)(entity1.field_70131_O / 2.0f), 0.0), -1073741569, 1, 0.0f);
                        entity2.setDamage(ItemJutsu.causeJutsuDamage(this, this.summoner), 10.0f * this.damageMultiplier(), this.summoner);
                        this.field_70170_p.func_72838_d((Entity)entity2);
                    }
                    EntityLightningArc.Base entity = new EntityLightningArc.Base(this.field_70170_p, this.summoner.func_174791_d().func_72441_c(0.0, 1.0, 0.0), this.field_70146_Z.nextDouble() * 3.0 + 1.0, 0.0, 0.0, 0.0);
                    entity.setDamage(ItemJutsu.causeJutsuDamage(this, this.summoner), 10.0f * this.damageMultiplier(), this.summoner);
                    this.field_70170_p.func_72838_d((Entity)entity);
                } else {
                    Vec3d vec0 = this.summoner.func_174824_e(1.0f);
                    Vec3d vec1 = vec0.func_178787_e(this.summoner.func_70040_Z().func_186678_a(6.0));
                    vec0 = this.handPos != null ? this.handPos : vec0.func_178786_a(0.0, 0.5, 0.0);
                    EntityLightningArc.Base entity = new EntityLightningArc.Base(this.field_70170_p, vec0, vec1, -2147483393, 1, 0.0f, 0.04f, 0);
                    entity.setDamage(ItemJutsu.causeJutsuDamage(this, this.summoner), 10.0f * this.damageMultiplier(), this.summoner);
                    this.field_70170_p.func_72838_d((Entity)entity);
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        this.field_70170_p.func_72838_d((Entity)new EntityLightningArc.Base(this.field_70170_p, vec0, vec1, -1073741569, 1, 0.0f));
                    }
                }
            }
            if (!(this.field_70170_p.field_72995_K || this.summoner != null && this.field_70173_aa <= this.duration && this.canUse())) {
                this.func_70106_y();
            }
        }
    }

    public static class EC
    extends Entity
    implements ProcedureSync.CPacketVec3d.IHandler {
        private static final DataParameter<Integer> OWNER_ID = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187192_b);
        private final int growTime = 40;
        protected EntityLivingBase summoner;
        protected Vec3d handPos;
        private float summonerYaw;
        protected int duration;
        private double chakraBurn;
        private int attackTime;
        private int ticksSinceLastSwing;
        private int savedTicksSinceLastSwing;
        private Entity target;

        public EC(World a) {
            super(a);
            this.func_70105_a(0.1f, 0.1f);
        }

        protected EC(EntityLivingBase summonerIn, double chakraBurnPerSec, int durationIn) {
            this(summonerIn.field_70170_p);
            this.setOwner(summonerIn);
            this.chakraBurn = chakraBurnPerSec;
            this.duration = durationIn;
            this.setPositionToSummoner();
            this.func_174805_g(false);
        }

        protected void func_70088_a() {
            this.func_184212_Q().func_187214_a(OWNER_ID, (Object)0);
        }

        public EntityLivingBase getOwner() {
            if (!this.field_70170_p.field_72995_K) {
                return this.summoner;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(OWNER_ID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        protected void setOwner(EntityLivingBase entity) {
            this.func_184212_Q().func_187227_b(OWNER_ID, (Object)entity.func_145782_y());
            this.summoner = entity;
        }

        private float getGrowth() {
            float f = this.field_70173_aa;
            this.getClass();
            return Math.min(f / 40.0f, 1.0f);
        }

        public boolean isHoldingWeapon(EnumHand hand) {
            return this.getOwner() != null && ProcedureUtils.isWeapon(this.getOwner().func_184586_b(hand));
        }

        public boolean canUse() {
            if (this.getOwner() != null) {
                ItemStack item = this.getOwner().func_184614_ca();
                return item.func_190926_b() || item.func_77973_b() instanceof ItemJutsu.Base || this.isHoldingWeapon(EnumHand.MAIN_HAND);
            }
            return false;
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && this.summoner != null) {
                ItemJutsu.IJutsuCallback.JutsuData jd;
                ProcedureSync.EntityNBTTag.removeAndSync((Entity)this.summoner, NarutomodModVariables.forceBowPose);
                if (this.getClass() == EC.class && (jd = ItemRaiton.CHIDORI.jutsu.getData(this.summoner)) != null) {
                    ItemJutsu.Base item = (ItemJutsu.Base)jd.stack.func_77973_b();
                    item.setJutsuCooldown(jd.stack, ItemRaiton.CHIDORI, (long)((float)this.field_70173_aa * item.getModifier(jd.stack, this.summoner)) + 100L);
                    jd.stack.func_77978_p().func_82580_o("ChidoriEntityIdKey");
                }
            }
        }

        public void func_70071_h_() {
            BlockPos pos;
            boolean flag = this.isHoldingWeapon(EnumHand.MAIN_HAND);
            if (!this.field_70170_p.field_72995_K && this.summoner != null && flag != !this.summoner.getEntityData().func_74767_n(NarutomodModVariables.forceBowPose)) {
                ProcedureSync.EntityNBTTag.setAndSync((Entity)this.summoner, NarutomodModVariables.forceBowPose, !flag);
            }
            if (this.summoner != null) {
                this.summoner.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 2, 6, false, false));
                this.setPositionToSummoner();
                if (this.field_70173_aa % 20 == 0 && !Chakra.pathway(this.summoner).consume(this.chakraBurn)) {
                    this.func_70106_y();
                }
            }
            float f = this.getGrowth();
            if (this.field_70146_Z.nextFloat() <= f * 0.3f) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:electricity")), f * 0.5f, this.field_70146_Z.nextFloat() * 2.0f + 1.0f);
            }
            if (this.field_70173_aa > this.growTime / 2 && this.field_70170_p.func_175623_d(pos = this.func_180425_c())) {
                new EventSetBlocks(this.field_70170_p, (Map<BlockPos, IBlockState>)ImmutableMap.of((Object)pos, (Object)BlockLightSource.block.func_176223_P()), 0L, 2, false, false);
            }
            if (this.summoner != null && this.field_70173_aa > this.growTime) {
                boolean flag2;
                boolean bl = flag2 = this.summoner instanceof EntityLiving && ((EntityLiving)this.summoner).func_70638_az() != null;
                if (flag2 || this.summoner instanceof EntityPlayer && this.summoner.field_110158_av == 1) {
                    this.target = (flag2 ? new RayTraceResult((Entity)((EntityLiving)this.summoner).func_70638_az()) : ProcedureUtils.objectEntityLookingAt((Entity)this.summoner, (double)20.0, (double)1.0, (Entity)this)).field_72308_g;
                    this.savedTicksSinceLastSwing = this.ticksSinceLastSwing;
                    this.ticksSinceLastSwing = 0;
                    this.attackTime = 0;
                }
                if (this.target instanceof EntityLivingBase && this.attackTime < 12) {
                    this.summoner.field_70177_z = ProcedureUtils.getYawFromVec(this.target.func_174791_d().func_178788_d(this.summoner.func_174791_d()));
                    if (!flag && this.attackTime % 6 == 0) {
                        this.launchAtTarget((EntityLivingBase)this.target);
                    }
                    if (this.target.func_70068_e((Entity)this.summoner) < 25.0) {
                        float damage = flag ? (float)ProcedureUtils.getMainhandItemDamage(this.summoner) * this.damageMultiplier() * 1.2f : 25.0f * this.damageMultiplier();
                        EntityLightningArc.onStruck(this.target, ItemJutsu.causeJutsuDamage(this, this.summoner), damage * this.getCooledAttackStrength());
                        this.target = null;
                    }
                }
            }
            if (!(this.field_70170_p.field_72995_K || this.summoner != null && this.summoner.func_70089_S() && this.field_70173_aa <= this.duration && this.canUse())) {
                this.func_70106_y();
            }
            ++this.ticksSinceLastSwing;
            ++this.attackTime;
        }

        private void launchAtTarget(EntityLivingBase target) {
            if (!ProcedureUtils.isWearingAnySharingan(this.summoner)) {
                ProcedureRenderView.setFOV((Entity)this.summoner, 100, 10.0f);
            }
            double d0 = target.field_70165_t - this.summoner.field_70165_t;
            double d1 = target.field_70163_u - this.summoner.field_70163_u;
            double d2 = target.field_70161_v - this.summoner.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            ProcedureUtils.setVelocity((Entity)this.summoner, d0 * 0.4, d1 * 0.4 + d3 * 0.02, d2 * 0.4);
        }

        protected void setPositionToSummoner() {
            if (this.handPos != null) {
                this.func_70107_b(this.handPos.field_72450_a, this.handPos.field_72448_b - (double)this.field_70131_O * 0.5, this.handPos.field_72449_c);
            } else {
                this.func_70107_b(this.summoner.field_70165_t, this.summoner.field_70163_u + 1.4, this.summoner.field_70161_v);
            }
        }

        public float getCooledAttackStrength() {
            if (this.summoner != null) {
                float f = (float)(1.0 / ProcedureUtils.getAttackSpeed(this.summoner) * 20.0);
                return MathHelper.func_76131_a((float)((float)this.savedTicksSinceLastSwing / f), (float)0.0f, (float)1.0f);
            }
            return 0.0f;
        }

        protected float damageMultiplier() {
            if (this.summoner instanceof EntityPlayer) {
                return MathHelper.func_76131_a((float)((float)PlayerTracker.getNinjaLevel((EntityPlayer)this.summoner) / 40.0f), (float)1.0f, (float)6.0f);
            }
            return 1.0f;
        }

        @Override
        public void handleClientPacket(Vec3d vec) {
            this.handPos = vec;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ID_KEY = "ChidoriEntityIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Entity entity1 = entity.field_70170_p.func_73045_a(stack.func_77978_p().func_74762_e(ID_KEY));
                if (!(entity instanceof EntityKageBunshin.EC) && entity1 instanceof EC) {
                    entity1.func_70106_y();
                    entity.field_70170_p.func_72838_d((Entity)new Spear(entity, 40.0));
                    return true;
                }
                if (!entity.func_184218_aH()) {
                    EntityLivingBase entity2;
                    if (ItemFuton.CHAKRAFLOW.jutsu.isActivated(entity)) {
                        ItemFuton.CHAKRAFLOW.jutsu.deactivate(entity);
                    }
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:chidori")), SoundCategory.PLAYERS, 1.0f, 1.0f);
                    EntityLivingBase entityLivingBase = entity2 = entity instanceof EntityKageBunshin.EC ? ((EntityKageBunshin.EC)entity).getSummoner() : entity;
                    double ninjalevel = entity2 instanceof EntityPlayer ? PlayerTracker.getNinjaLevel((EntityPlayer)entity2) : (entity2 instanceof EntityNinjaMob.Base ? (double)((EntityNinjaMob.Base)entity2).getNinjaLevel() : 0.0);
                    float f = ((ItemJutsu.Base)stack.func_77973_b()).getCurrentJutsuXpModifier(stack, entity2);
                    entity1 = new EC(entity, 40.0, (int)(ninjalevel * 5.0 / (double)f));
                    entity.field_70170_p.func_72838_d(entity1);
                    stack.func_77978_p().func_74768_a(ID_KEY, entity1.func_145782_y());
                    return true;
                }
                return false;
            }

            @Override
            public boolean isActivated(ItemStack stack) {
                return stack.func_77978_p().func_74764_b(ID_KEY);
            }

            @Override
            public boolean isActivated(EntityLivingBase entity) {
                return this.getData(entity) != null;
            }

            @Override
            public void deactivate(EntityLivingBase entity) {
                ItemJutsu.IJutsuCallback.JutsuData jd = this.getData(entity);
                if (jd != null) {
                    jd.entity.func_70106_y();
                    jd.stack.func_77978_p().func_82580_o(ID_KEY);
                }
            }

            @Override
            @Nullable
            public ItemJutsu.IJutsuCallback.JutsuData getData(EntityLivingBase entity) {
                ItemStack stack;
                if (entity instanceof EntityPlayer && (stack = ProcedureUtils.getMatchingItemStack((EntityPlayer)entity, ItemRaiton.block)) != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(ID_KEY)) {
                    Entity entity1 = entity.field_70170_p.func_73045_a(stack.func_77978_p().func_74762_e(ID_KEY));
                    return entity1 instanceof EC ? new ItemJutsu.IJutsuCallback.JutsuData(entity1, stack) : null;
                }
                return null;
            }
        }
    }
}

