/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.item.ItemOnBody;
import net.narutomod.potion.PotionFeatherFalling;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityClone
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 121;
    public static final int ENTITYID_RANGED = 122;

    public EntityClone(ElementsNarutomodMod instance) {
        super(instance, 365);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(_Base.class, renderManager -> {
            ClientRLM clientRLM = ClientRLM.getInstance();
            clientRLM.getClass();
            return clientRLM.new ClientRLM.RenderClone(renderManager);
        });
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new AITaskHook());
    }

    public static class ClientRLM {
        private static ClientRLM instance;

        public ClientRLM() {
            instance = this;
        }

        public static ClientRLM getInstance() {
            if (instance == null) {
                new ClientRLM();
            }
            return instance;
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelClone
        extends ModelBiped {
            private final boolean smallArms;

            public ModelClone(float modelSize, boolean smallArmsIn) {
                super(modelSize, 0.0f, 64, 64);
                this.smallArms = smallArmsIn;
                if (smallArmsIn) {
                    this.field_178724_i = new ModelRenderer((ModelBase)this);
                    this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 32, 48, -1.0f, -2.0f, -2.0f, 3, 12, 4, modelSize, false));
                    this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 48, 48, -1.0f, -2.0f, -2.0f, 3, 12, 4, modelSize + 0.25f, false));
                    this.field_178724_i.func_78793_a(5.0f, 2.5f, 0.0f);
                    this.field_178723_h = new ModelRenderer((ModelBase)this);
                    this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 16, -2.0f, -2.0f, -2.0f, 3, 12, 4, modelSize, false));
                    this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 32, -2.0f, -2.0f, -2.0f, 3, 12, 4, modelSize + 0.25f, false));
                    this.field_178723_h.func_78793_a(-5.0f, 2.5f, 0.0f);
                } else {
                    this.field_178724_i = new ModelRenderer((ModelBase)this);
                    this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 32, 48, -1.0f, -2.0f, -2.0f, 4, 12, 4, modelSize, false));
                    this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 48, 48, -1.0f, -2.0f, -2.0f, 4, 12, 4, modelSize + 0.25f, false));
                    this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
                    this.field_178723_h = new ModelRenderer((ModelBase)this);
                    this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 16, -3.0f, -2.0f, -2.0f, 4, 12, 4, modelSize, false));
                    this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 32, -3.0f, -2.0f, -2.0f, 4, 12, 4, modelSize + 0.25f, false));
                    this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
                }
                this.field_178722_k = new ModelRenderer((ModelBase)this);
                this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 16, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, modelSize, false));
                this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 0, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, modelSize + 0.25f, false));
                this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
                this.field_178721_j = new ModelRenderer((ModelBase)this);
                this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 16, -2.0f, 0.0f, -2.0f, 4, 12, 4, modelSize, false));
                this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 32, -2.0f, 0.0f, -2.0f, 4, 12, 4, modelSize + 0.25f, false));
                this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
                this.field_78115_e = new ModelRenderer((ModelBase)this);
                this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 16, -4.0f, 0.0f, -2.0f, 8, 12, 4, modelSize, false));
                this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 32, -4.0f, 0.0f, -2.0f, 8, 12, 4, modelSize + 0.25f, false));
                this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
            }

            public void func_78087_a(float limbSwing, float f1, float f2, float f3, float f4, float f5, Entity entityIn) {
                super.func_78087_a(limbSwing * 1.8f / entityIn.field_70131_O, f1, f2, f3, f4, f5, entityIn);
            }

            public void func_187073_a(float scale, EnumHandSide side) {
                ModelRenderer modelrenderer = this.func_187074_a(side);
                if (this.smallArms) {
                    float f = 0.5f * (float)(side == EnumHandSide.RIGHT ? 1 : -1);
                    modelrenderer.field_78800_c += f;
                    modelrenderer.func_78794_c(scale);
                    modelrenderer.field_78800_c -= f;
                } else {
                    modelrenderer.func_78794_c(scale);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class LayerInventoryItem
        implements LayerRenderer<_Base> {
            private final RenderClone renderer;

            public LayerInventoryItem(RenderClone rendererIn) {
                this.renderer = rendererIn;
            }

            public void doRenderLayer(_Base entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                EntityLivingBase e = entityIn.getSummoner();
                if (e instanceof AbstractClientPlayer) {
                    AbstractClientPlayer summoner = (AbstractClientPlayer)e;
                    for (int i = 0; i < summoner.field_71071_by.field_70462_a.size(); ++i) {
                        ItemStack stack = (ItemStack)summoner.field_71071_by.field_70462_a.get(i);
                        if (!(stack.func_77973_b() instanceof ItemOnBody.Interface)) continue;
                        ItemOnBody.Interface item = (ItemOnBody.Interface)stack.func_77973_b();
                        if (item.showSkinLayer()) {
                            this.renderSkinLayer(stack, entityIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                        }
                        if (item.showOnBody() == ItemOnBody.BodyPart.NONE || entityIn.func_184614_ca().func_185136_b(stack)) continue;
                        this.renderItemOnBody(stack, entityIn, item.showOnBody());
                    }
                }
            }

            private void renderSkinLayer(ItemStack stack, _Base entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                String s;
                ModelBiped model = stack.func_77973_b().getArmorModel((EntityLivingBase)entityIn, stack, EntityEquipmentSlot.HEAD, new ModelBiped(1.0f));
                if (model != null && (s = stack.func_77973_b().getArmorTexture(stack, (Entity)entityIn, EntityEquipmentSlot.HEAD, null)) != null) {
                    model.func_78086_a((EntityLivingBase)entityIn, limbSwing, limbSwingAmount, partialTicks);
                    this.renderer.func_110776_a(new ResourceLocation(s));
                    model.func_78088_a((Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                }
            }

            private void renderItemOnBody(ItemStack stack, _Base entityIn, ItemOnBody.BodyPart bodypart) {
                Vec3d offset = ((ItemOnBody.Interface)stack.func_77973_b()).getOffset();
                GlStateManager.func_179094_E();
                ModelBiped model = (ModelBiped)this.renderer.func_177087_b();
                switch (bodypart) {
                    case HEAD: {
                        model.field_78116_c.func_78794_c(0.0625f);
                        break;
                    }
                    case TORSO: {
                        model.field_78115_e.func_78794_c(0.0625f);
                        break;
                    }
                    case RIGHT_ARM: {
                        model.field_178723_h.func_78794_c(0.0625f);
                        break;
                    }
                    case LEFT_ARM: {
                        model.field_178724_i.func_78794_c(0.0625f);
                        break;
                    }
                    case RIGHT_LEG: {
                        model.field_178721_j.func_78794_c(0.0625f);
                        break;
                    }
                    case LEFT_LEG: {
                        model.field_178722_k.func_78794_c(0.0625f);
                    }
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)offset.field_72450_a, (double)(-0.25 + offset.field_72448_b), (double)offset.field_72449_c);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.625f, (float)-0.625f, (float)-0.625f);
                Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)entityIn, stack, ItemCameraTransforms.TransformType.HEAD);
                GlStateManager.func_179121_F();
            }

            public boolean func_177142_b() {
                return false;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class BipedArmorLayer
        extends LayerBipedArmor {
            private final RenderLivingBase<?> renderer;

            public BipedArmorLayer(RenderLivingBase<?> rendererIn) {
                super(rendererIn);
                this.renderer = rendererIn;
            }

            public void func_177141_a(EntityLivingBase entityIn, float limbSwing, float f1, float f2, float f3, float f4, float f5, float f6) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                super.func_177141_a(entityIn, limbSwing * 1.8f / entityIn.field_70131_O, f1, f2, f3, f4, f5, f6);
                GlStateManager.func_179084_k();
            }

            protected void func_188359_a(ModelBiped model, EntityEquipmentSlot slotIn) {
                model.func_178719_a(false);
                ModelBiped rendererModel = (ModelBiped)this.renderer.func_177087_b();
                switch (slotIn) {
                    case HEAD: {
                        if (!rendererModel.field_78116_c.field_78806_j) break;
                        model.field_78116_c.field_78806_j = true;
                        model.field_178720_f.field_78806_j = true;
                        break;
                    }
                    case CHEST: {
                        if (rendererModel.field_78115_e.field_78806_j) {
                            model.field_78115_e.field_78806_j = true;
                        }
                        if (rendererModel.field_178723_h.field_78806_j) {
                            model.field_178723_h.field_78806_j = true;
                        }
                        if (!rendererModel.field_178724_i.field_78806_j) break;
                        model.field_178724_i.field_78806_j = true;
                        break;
                    }
                    case LEGS: {
                        if (rendererModel.field_78115_e.field_78806_j) {
                            model.field_78115_e.field_78806_j = true;
                        }
                        if (rendererModel.field_178721_j.field_78806_j) {
                            model.field_178721_j.field_78806_j = true;
                        }
                        if (!rendererModel.field_178722_k.field_78806_j) break;
                        model.field_178722_k.field_78806_j = true;
                        break;
                    }
                    case FEET: {
                        if (rendererModel.field_178721_j.field_78806_j) {
                            model.field_178721_j.field_78806_j = true;
                        }
                        if (!rendererModel.field_178722_k.field_78806_j) break;
                        model.field_178722_k.field_78806_j = true;
                    }
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderClone<T extends _Base>
        extends RenderLivingBase<T> {
            private final ModelClone altModel;

            public RenderClone(RenderManager renderManager) {
                super(renderManager, (ModelBase)new ModelClone(0.0f, false), 0.5f);
                this.altModel = new ModelClone(0.0f, true);
                this.func_177094_a((LayerRenderer)new BipedArmorLayer(this));
                this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
                this.func_177094_a((LayerRenderer)new LayerCustomHead(((ModelBiped)this.func_177087_b()).field_78116_c));
                this.func_177094_a((LayerRenderer)new LayerElytra((RenderLivingBase)this));
                this.func_177094_a(new LayerInventoryItem(this));
            }

            public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
                this.setPose(entity);
                super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
            }

            private void setPose(T entity) {
                ModelBiped model = (ModelBiped)this.func_177087_b();
                ItemStack itemstack = entity.func_184614_ca();
                ItemStack itemstack1 = entity.func_184592_cb();
                ModelBiped.ArmPose mainhandpose = ModelBiped.ArmPose.EMPTY;
                ModelBiped.ArmPose offhandpose = ModelBiped.ArmPose.EMPTY;
                if (!itemstack.func_190926_b()) {
                    mainhandpose = ModelBiped.ArmPose.ITEM;
                    if (entity.func_184605_cv() > 0) {
                        EnumAction enumaction = itemstack.func_77975_n();
                        if (enumaction == EnumAction.BLOCK) {
                            mainhandpose = ModelBiped.ArmPose.BLOCK;
                        } else if (enumaction == EnumAction.BOW) {
                            mainhandpose = ModelBiped.ArmPose.BOW_AND_ARROW;
                        }
                    }
                }
                if (!itemstack1.func_190926_b()) {
                    offhandpose = ModelBiped.ArmPose.ITEM;
                    if (entity.func_184605_cv() > 0) {
                        EnumAction enumaction1 = itemstack1.func_77975_n();
                        if (enumaction1 == EnumAction.BLOCK) {
                            offhandpose = ModelBiped.ArmPose.BLOCK;
                        } else if (enumaction1 == EnumAction.BOW) {
                            offhandpose = ModelBiped.ArmPose.BOW_AND_ARROW;
                        }
                    }
                }
                if (entity.func_184591_cq() == EnumHandSide.RIGHT) {
                    model.field_187076_m = mainhandpose;
                    model.field_187075_l = offhandpose;
                } else {
                    model.field_187076_m = offhandpose;
                    model.field_187075_l = mainhandpose;
                }
            }

            protected void renderLayers(T entity, float f0, float f1, float f2, float f3, float f4, float f5, float f6) {
                if (!entity.func_82150_aj() || !((_Base)((Object)entity)).func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    super.func_177093_a(entity, f0, f1, f2, f3, f4, f5, f6);
                }
            }

            public ResourceLocation getEntityTexture(T entity) {
                EntityLivingBase summoner = ((_Base)((Object)entity)).getSummoner();
                if (summoner instanceof AbstractClientPlayer) {
                    AbstractClientPlayer clientPlayer = (AbstractClientPlayer)summoner;
                    if (clientPlayer.func_175154_l().equals("slim")) {
                        this.field_77045_g = this.altModel;
                    }
                    return clientPlayer.func_110306_p();
                }
                return null;
            }

            public void func_82422_c() {
                GlStateManager.func_179109_b((float)0.0f, (float)0.1875f, (float)0.0f);
            }

            protected void preRenderCallback(T entity, float partialTickTime) {
                float f;
                if (((_Base)((Object)entity)).getSummoner() instanceof AbstractClientPlayer) {
                    f = 0.9375f;
                    GlStateManager.func_179152_a((float)f, (float)f, (float)f);
                }
                if ((f = ((_Base)((Object)entity)).getScale()) != 1.0f) {
                    GlStateManager.func_179152_a((float)f, (float)f, (float)f);
                }
            }
        }
    }

    public class AITaskHook {
        @SubscribeEvent
        public void onEntitySpawn(EntityJoinWorldEvent event) throws Exception {
            Entity entity = event.getEntity();
            if (entity instanceof EntityLiving) {
                this.addCloneToAITargetTasks(((EntityLiving)entity).field_70715_bh);
            }
        }

        public void addCloneToAITargetTasks(EntityAITasks tasks) throws Exception {
            EntityAITasks.EntityAITaskEntry entry = null;
            for (EntityAITasks.EntityAITaskEntry aitaskentry : tasks.field_75782_a) {
                Object targetClass;
                if (aitaskentry.field_75733_a instanceof EntityAINearestAttackableTarget) {
                    targetClass = ProcedureUtils.getFieldByIndex(aitaskentry.field_75733_a.getClass(), EntityAINearestAttackableTarget.class, 0).get(aitaskentry.field_75733_a);
                    if (targetClass.equals(Base.class)) {
                        return;
                    }
                    if (!EntityPlayer.class.isAssignableFrom((Class)targetClass)) continue;
                    entry = aitaskentry;
                    continue;
                }
                if (aitaskentry.field_75733_a instanceof EntityAIFindEntityNearest) {
                    targetClass = ProcedureUtils.getFieldByIndex(aitaskentry.field_75733_a.getClass(), EntityAIFindEntityNearest.class, 5).get(aitaskentry.field_75733_a);
                    if (targetClass.equals(Base.class)) {
                        return;
                    }
                    if (!EntityPlayer.class.isAssignableFrom((Class)targetClass)) continue;
                    entry = aitaskentry;
                    continue;
                }
                if (!(aitaskentry.field_75733_a instanceof EntityAIFindEntityNearestPlayer)) continue;
                entry = aitaskentry;
            }
            if (entry != null) {
                Field taskOwner;
                if (entry.field_75733_a instanceof EntityAINearestAttackableTarget) {
                    taskOwner = ProcedureUtils.getFieldByIndex(entry.field_75733_a.getClass(), EntityAITarget.class, 0);
                    Field checkSight = ProcedureUtils.getFieldByIndex(entry.field_75733_a.getClass(), EntityAITarget.class, 1);
                    Field nearbyOnly = ProcedureUtils.getFieldByIndex(entry.field_75733_a.getClass(), EntityAITarget.class, 2);
                    tasks.func_75776_a(entry.field_75731_b - 1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)taskOwner.get(entry.field_75733_a), Base.class, checkSight.getBoolean(entry.field_75733_a), nearbyOnly.getBoolean(entry.field_75733_a)));
                } else if (entry.field_75733_a instanceof EntityAIFindEntityNearestPlayer) {
                    taskOwner = ProcedureUtils.getFieldByIndex(entry.field_75733_a.getClass(), EntityAIFindEntityNearestPlayer.class, 1);
                    tasks.func_75776_a(entry.field_75731_b - 1, (EntityAIBase)new EntityAIFindEntityNearest((EntityLiving)taskOwner.get(entry.field_75733_a), Base.class));
                } else if (entry.field_75733_a instanceof EntityAIFindEntityNearest) {
                    taskOwner = ProcedureUtils.getFieldByIndex(entry.field_75733_a.getClass(), EntityAIFindEntityNearest.class, 1);
                    tasks.func_75776_a(entry.field_75731_b - 1, (EntityAIBase)new EntityAIFindEntityNearest((EntityLiving)taskOwner.get(entry.field_75733_a), Base.class));
                }
            }
        }
    }

    public static class AIFlyControl
    extends EntityMoveHelper {
        public AIFlyControl(EntityLiving entityIn) {
            super(entityIn);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                this.field_75648_a.func_189654_d(true);
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d1 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d2 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                if (d3 >= 0.001) {
                    float f = (float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e());
                    this.field_75648_a.field_70159_w += d0 / d3 * 0.05 * (double)f;
                    this.field_75648_a.field_70181_x += d1 / d3 * 0.05 * (double)f;
                    this.field_75648_a.field_70179_y += d2 / d3 * 0.05 * (double)f;
                    if (this.field_75648_a.func_70638_az() == null) {
                        this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z = -((float)MathHelper.func_181159_b((double)this.field_75648_a.field_70159_w, (double)this.field_75648_a.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = this.field_75648_a.func_70638_az().field_70165_t - this.field_75648_a.field_70165_t;
                        double d5 = this.field_75648_a.func_70638_az().field_70161_v - this.field_75648_a.field_70161_v;
                        this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                } else {
                    this.field_75648_a.field_70159_w *= 0.5;
                    this.field_75648_a.field_70181_x *= 0.5;
                    this.field_75648_a.field_70179_y *= 0.5;
                }
            } else {
                this.field_75648_a.func_189654_d(false);
                this.field_75648_a.func_70657_f(0.0f);
                this.field_75648_a.func_191989_p(0.0f);
            }
        }
    }

    public static class AIFollowSummoner
    extends EntityAIBase {
        private final EntityLiving entity;
        protected EntityLivingBase followingEntity;
        private final double speedModifier;
        private final PathNavigate navigation;
        private int timeToRecalcPath;
        protected final float stopDistance;
        private float oldWaterCost;

        public AIFollowSummoner(EntityLiving entityIn, double speed, float stopRange) {
            this.entity = entityIn;
            this.speedModifier = speed;
            this.navigation = entityIn.func_70661_as();
            this.stopDistance = stopRange;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.getFollowEntity();
            if (entitylivingbase == null) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
                return false;
            }
            if (this.entity.func_70068_e((Entity)entitylivingbase) < (double)(this.stopDistance * this.stopDistance)) {
                return false;
            }
            this.followingEntity = entitylivingbase;
            return true;
        }

        public boolean func_75253_b() {
            return this.followingEntity != null && !this.navigation.func_75500_f() && this.entity.func_70068_e((Entity)this.followingEntity) > (double)(this.stopDistance * this.stopDistance);
        }

        public void func_75249_e() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
            this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
        }

        public void func_75251_c() {
            this.followingEntity = null;
            this.navigation.func_75499_g();
            this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        }

        public void func_75246_d() {
            if (this.followingEntity != null) {
                if (--this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = 10;
                    double d = this.entity.func_70032_d((Entity)this.followingEntity);
                    if (d > (double)this.stopDistance) {
                        Vec3d vec;
                        if (!this.navigation.func_75497_a((Entity)this.followingEntity, this.getSpeed()) && (vec = this.findOpenSpaceTowardsSummoner(ProcedureUtils.getFollowRange((EntityLivingBase)this.entity) / 2.0)) != null) {
                            this.entity.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, this.entity.field_70177_z, this.entity.field_70125_A);
                        }
                    } else {
                        this.navigation.func_75499_g();
                        if (d <= (double)this.stopDistance * 0.5) {
                            double d4 = this.followingEntity.field_70165_t - this.entity.field_70165_t;
                            double d5 = this.followingEntity.field_70161_v - this.entity.field_70161_v;
                            this.navigation.func_75492_a(this.entity.field_70165_t - d4, this.entity.field_70163_u, this.entity.field_70161_v - d5, this.getSpeed());
                        }
                    }
                }
                this.entity.func_70671_ap().func_75651_a((Entity)this.followingEntity, 10.0f, (float)this.entity.func_70646_bf());
            }
        }

        @Nullable
        protected Vec3d findOpenSpaceTowardsSummoner(double maxDistanceToSummoner) {
            Vec3d vec = this.entity.func_174791_d().func_178788_d(this.followingEntity.func_174791_d()).func_72432_b().func_186678_a(maxDistanceToSummoner);
            List<BlockPos> list = ProcedureUtils.getAllAirBlocks(this.entity.field_70170_p, this.followingEntity.func_174813_aQ().func_72321_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
            list.sort(new ProcedureUtils.BlockposSorter(this.entity.func_180425_c()));
            for (BlockPos pos : list) {
                Material material = this.entity.field_70170_p.func_180495_p(pos.func_177977_b()).func_185904_a();
                if (!material.func_76220_a()) {
                    if (material != Material.field_151586_h) continue;
                }
                if (!ProcedureUtils.isSpaceOpenToStandOn((EntityLivingBase)this.entity, pos)) continue;
                return new Vec3d(0.5 + (double)pos.func_177958_n(), (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p());
            }
            return null;
        }

        protected double getSpeed() {
            return this.speedModifier;
        }

        protected EntityLivingBase getFollowEntity() {
            return ((_Base)this.entity).getSummoner();
        }
    }

    public static class ModifiedXPOrb
    extends EntityXPOrb {
        private _Base closestClone;
        private int xpTargetColor;

        public ModifiedXPOrb(World world) {
            super(world);
        }

        public ModifiedXPOrb(World world, double x, double y, double z, int expValue) {
            super(world, x, y, z, expValue);
        }

        public void func_70071_h_() {
            double d3;
            double d2;
            double d1;
            double d4;
            double d5;
            super.func_70071_h_();
            if (this.xpTargetColor < this.field_70533_a - 20 + this.func_145782_y() % 100) {
                if (this.closestClone == null || this.closestClone.func_70068_e((Entity)this) > 64.0) {
                    this.closestClone = (_Base)this.field_70170_p.func_72857_a(_Base.class, this.func_174813_aQ().func_186662_g(8.0), (Entity)this);
                }
                this.xpTargetColor = this.field_70533_a;
            }
            if (this.closestClone != null && (d5 = 1.0 - (d4 = Math.sqrt((d1 = (this.closestClone.field_70165_t - this.field_70165_t) / 8.0) * d1 + (d2 = (this.closestClone.field_70163_u + (double)this.closestClone.func_70047_e() / 2.0 - this.field_70163_u) / 8.0) * d2 + (d3 = (this.closestClone.field_70161_v - this.field_70161_v) / 8.0) * d3))) > 0.0) {
                d5 *= d5;
                this.field_70159_w += d1 / d4 * d5 * 0.1;
                this.field_70181_x += d2 / d4 * d5 * 0.1;
                this.field_70179_y += d3 / d4 * d5 * 0.1;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }

        public boolean func_70104_M() {
            return true;
        }

        public void func_70108_f(Entity entityIn) {
            if (!this.field_70170_p.field_72995_K && entityIn instanceof _Base) {
                this.func_70106_y();
                _Base _Base2 = (_Base)entityIn;
                _Base2.collectedXPPoints = _Base2.collectedXPPoints + this.field_70530_e;
            }
        }
    }

    public static abstract class _Base
    extends EntityCreature {
        private static final DataParameter<Integer> SUMMONER_ID = EntityDataManager.func_187226_a(_Base.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Float> MODEL_SCALE = EntityDataManager.func_187226_a(_Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private EntityLivingBase summoner;
        private int collectedXPPoints;
        protected boolean shouldDefendSummoner;

        public _Base(World world) {
            super(world);
            this.func_70105_a(0.6f, 1.8f);
            this.field_70728_aV = 0;
            this.field_70178_ae = false;
            this.func_94061_f(false);
            this.func_110163_bv();
            this.shouldDefendSummoner = true;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                this.func_184642_a(slot, 0.0f);
            }
        }

        public _Base(EntityLivingBase summonerIn) {
            this(summonerIn.field_70170_p);
            this.setSummoner(summonerIn);
            this.func_96094_a(summonerIn.func_70005_c_());
            this.func_184641_n(summonerIn.func_184591_cq() == EnumHandSide.LEFT);
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                this.func_184201_a(entityequipmentslot, this.summoner.func_184582_a(entityequipmentslot).func_77946_l());
            }
            this.field_70760_ar = this.field_70761_aq = summonerIn.field_70177_z;
            this.field_70126_B = this.field_70761_aq;
            this.field_70759_as = this.field_70758_at = summonerIn.field_70759_as;
            this.func_82149_j((Entity)summonerIn);
        }

        protected PathNavigate func_175447_b(World worldIn) {
            EntityNinjaMob.NavigateGround navi = new EntityNinjaMob.NavigateGround((EntityLiving)this, worldIn);
            navi.func_179693_d(true);
            return navi;
        }

        protected void func_70088_a() {
            super.func_70088_a();
            this.func_184212_Q().func_187214_a(SUMMONER_ID, (Object)-1);
            this.func_184212_Q().func_187214_a(MODEL_SCALE, (Object)Float.valueOf(1.0f));
        }

        @Nullable
        public EntityLivingBase getSummoner() {
            if (!this.field_70170_p.field_72995_K) {
                return this.summoner;
            }
            Entity e = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(SUMMONER_ID)).intValue());
            return e instanceof EntityLivingBase ? (EntityLivingBase)e : null;
        }

        protected void setSummoner(EntityLivingBase entity) {
            this.summoner = entity;
            this.func_184212_Q().func_187227_b(SUMMONER_ID, (Object)entity.func_145782_y());
        }

        protected float getScale() {
            return ((Float)this.func_184212_Q().func_187225_a(MODEL_SCALE)).floatValue();
        }

        protected void setScale(float scale) {
            this.func_184212_Q().func_187227_b(MODEL_SCALE, (Object)Float.valueOf(scale));
            this.func_70105_a(0.6f * scale, 1.8f * scale);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.25, true));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        }

        public float func_70603_bj() {
            return this.getScale();
        }

        public EnumCreatureAttribute func_70668_bt() {
            return EnumCreatureAttribute.UNDEFINED;
        }

        protected boolean func_70692_ba() {
            return false;
        }

        protected Item func_146068_u() {
            return null;
        }

        protected boolean sameSummoner(_Base entity) {
            return this.getSummoner() != null && this.getSummoner().equals((Object)entity.getSummoner());
        }

        public boolean func_184191_r(Entity entityIn) {
            return entityIn.equals((Object)this.getSummoner()) || entityIn instanceof _Base && this.sameSummoner((_Base)entityIn);
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_98034_c(EntityPlayer player) {
            return super.func_98034_c(player) && !this.func_184191_r((Entity)player);
        }

        public SoundEvent func_184639_G() {
            return null;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return null;
        }

        public SoundEvent func_184615_bR() {
            return null;
        }

        protected float func_70599_aP() {
            return 1.0f;
        }

        private void defendSummoner() {
            if (!this.func_175446_cd() && this.shouldDefendSummoner) {
                EntityLivingBase target = null;
                if (this.summoner.func_94060_bK() != null) {
                    target = this.summoner.func_94060_bK();
                }
                if (target == null && this.summoner.func_110144_aD() != null && !this.func_184191_r((Entity)this.summoner.func_110144_aD()) && this.summoner.field_70173_aa - this.summoner.func_142013_aG() < 200) {
                    target = this.summoner.func_110144_aD();
                }
                if (target != null && EntityAITarget.func_179445_a((EntityLiving)this, (EntityLivingBase)target, (boolean)false, (boolean)false)) {
                    this.func_70624_b(target);
                } else if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
                    this.func_70624_b(null);
                }
            }
        }

        protected void func_70619_bc() {
            if (this.summoner != null) {
                this.defendSummoner();
            }
            super.func_70619_bc();
        }

        public boolean func_70652_k(Entity entityIn) {
            return ProcedureUtils.attackEntityAsMob((EntityLivingBase)this, entityIn);
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && this.summoner instanceof EntityPlayer) {
                ((EntityPlayer)this.summoner).func_71023_q(this.collectedXPPoints);
            }
        }

        public void func_70074_a(EntityLivingBase entityIn) {
            if (!this.field_70170_p.field_72995_K && entityIn instanceof EntityLiving && this.summoner instanceof EntityPlayer) {
                int i = 0;
                try {
                    Field xpValue = ProcedureUtils.getFieldByIndex(entityIn.getClass(), EntityLiving.class, 2);
                    if (xpValue.getType() == Integer.TYPE) {
                        i = xpValue.getInt(entityIn);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("experienceValue");
                }
                for (ItemStack stack : ((EntityLiving)entityIn).func_184193_aE()) {
                    if (stack.func_190926_b()) continue;
                    i += 1 + this.field_70146_Z.nextInt(3);
                }
                for (ItemStack stack : ((EntityLiving)entityIn).func_184214_aD()) {
                    if (stack.func_190926_b()) continue;
                    i += 1 + this.field_70146_Z.nextInt(3);
                }
                while (i > 0) {
                    int j = EntityXPOrb.func_70527_a((int)i);
                    i -= j;
                    this.field_70170_p.func_72838_d((Entity)new ModifiedXPOrb(this.field_70170_p, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, j));
                }
            }
        }

        public void func_70636_d() {
            this.func_82168_bl();
            super.func_70636_d();
        }

        public void func_70071_h_() {
            BlockPos pos;
            if (!this.field_70170_p.field_72995_K && (this.summoner == null || !this.summoner.func_70089_S() || this.summoner.func_70608_bn() || ProcedureUtils.isPlayerDisconnected((Entity)this.summoner))) {
                this.func_70106_y();
            }
            if (this.field_70170_p.field_72995_K && this.field_70131_O != this.getScale() * 1.8f) {
                this.func_70105_a(0.6f * this.getScale(), 1.8f * this.getScale());
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 200 == 1) {
                this.func_70690_d(new PotionEffect(PotionFeatherFalling.potion, 202, 1, false, false));
            }
            if (this.field_70170_p.func_180495_p(pos = new BlockPos((Entity)this)).func_185904_a() == Material.field_151586_h && this.field_70170_p.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151586_h) {
                this.field_70181_x = 0.01;
                this.field_70122_E = true;
            }
            super.func_70071_h_();
        }

        public int func_82143_as() {
            return 12;
        }

        protected boolean func_146066_aG() {
            return false;
        }

        protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        }

        protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        }
    }

    public static abstract class Base
    extends _Base {
        public Base(World world) {
            super(world);
        }

        public Base(EntityLivingBase summonerIn) {
            super(summonerIn);
        }
    }
}

