/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.entity.EntitySummonAnimal;
import net.narutomod.item.ItemJutsu;

@ElementsNarutomodMod.ModElement.Tag
public class EntityEarthGolem
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 407;
    public static final int ENTITYID_RANGED = 408;

    public EntityEarthGolem(ElementsNarutomodMod instance) {
        super(instance, 799);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "earth_golem"), 407).name("earth_golem").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderCustom(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelRockGolem
    extends ModelBase {
        private final ModelRenderer ironGolemHead;
        private final ModelRenderer hornRight;
        private final ModelRenderer hornLeft;
        private final ModelRenderer ironGolemBody;
        private final ModelRenderer ironGolemRightArm;
        private final ModelRenderer right_arm;
        private final ModelRenderer bone;
        private final ModelRenderer ironGolemLeftArm;
        private final ModelRenderer left_arm;
        private final ModelRenderer bone2;
        private final ModelRenderer ironGolemRightLeg;
        private final ModelRenderer right_leg;
        private final ModelRenderer right_leg2;
        private final ModelRenderer ironGolemLeftLeg;
        private final ModelRenderer left_leg;
        private final ModelRenderer left_leg2;
        private final Vector3f headStart = new Vector3f(0.0f, 34.0f, 0.0f);
        private final Vector3f headEnd = new Vector3f(0.0f, -12.0f, 0.0f);
        private final Vector3f bodyStart = new Vector3f(0.0f, 24.0f, 0.0f);
        private final Vector3f bodyEnd = new Vector3f(0.0f, -12.0f, 0.0f);
        private final Vector3f rightArmStart = new Vector3f(0.0f, 26.0f, 2.0f);
        private final Vector3f rightArmEnd = new Vector3f(-8.0f, -10.0f, 0.0f);
        private final Vector3f leftArmStart = new Vector3f(0.0f, 26.0f, 2.0f);
        private final Vector3f leftArmEnd = new Vector3f(8.0f, -10.0f, 0.0f);
        private final Vector3f rightLegStart = new Vector3f(-0.5f, 26.5f, 0.0f);
        private final Vector3f rightLegEnd = new Vector3f(-3.5f, 5.5f, 0.0f);
        private final Vector3f leftLegStart = new Vector3f(0.5f, 26.5f, 0.0f);
        private final Vector3f leftLegEnd = new Vector3f(3.5f, 5.5f, 0.0f);

        public ModelRockGolem() {
            this.field_78090_t = 128;
            this.field_78089_u = 128;
            this.ironGolemHead = new ModelRenderer((ModelBase)this);
            this.ironGolemHead.func_78793_a(0.0f, -12.0f, 0.0f);
            this.ironGolemHead.field_78804_l.add(new ModelBox(this.ironGolemHead, 32, 24, -4.0f, -10.0f, -7.5f, 8, 10, 8, 0.0f, false));
            this.hornRight = new ModelRenderer((ModelBase)this);
            this.hornRight.func_78793_a(-1.35f, -10.5f, -5.4f);
            this.ironGolemHead.func_78792_a(this.hornRight);
            this.setRotationAngle(this.hornRight, 0.0f, 0.0f, 0.5236f);
            this.hornRight.field_78804_l.add(new ModelBox(this.hornRight, 24, 24, -2.05f, -0.2f, -2.1f, 4, 2, 2, -0.01f, false));
            this.hornLeft = new ModelRenderer((ModelBase)this);
            this.hornLeft.func_78793_a(1.35f, -10.5f, -5.4f);
            this.ironGolemHead.func_78792_a(this.hornLeft);
            this.setRotationAngle(this.hornLeft, 0.0f, 0.0f, -0.5236f);
            this.hornLeft.field_78804_l.add(new ModelBox(this.hornLeft, 24, 24, -1.95f, -0.2f, -2.1f, 4, 2, 2, -0.01f, true));
            this.ironGolemBody = new ModelRenderer((ModelBase)this);
            this.ironGolemBody.func_78793_a(0.0f, -12.0f, 0.0f);
            this.ironGolemBody.field_78804_l.add(new ModelBox(this.ironGolemBody, 0, 0, -9.0f, 0.0f, -6.0f, 18, 13, 11, 0.0f, false));
            this.ironGolemBody.field_78804_l.add(new ModelBox(this.ironGolemBody, 50, 52, -5.0f, 13.5f, -3.0f, 10, 8, 6, 0.5f, false));
            this.ironGolemRightArm = new ModelRenderer((ModelBase)this);
            this.ironGolemRightArm.func_78793_a(-8.0f, -10.0f, 0.0f);
            this.right_arm = new ModelRenderer((ModelBase)this);
            this.right_arm.func_78793_a(0.0f, 1.0f, 0.0f);
            this.ironGolemRightArm.func_78792_a(this.right_arm);
            this.setRotationAngle(this.right_arm, 0.0f, -0.5236f, 0.1745f);
            this.right_arm.field_78804_l.add(new ModelBox(this.right_arm, 24, 42, -8.0f, -2.5f, -3.5f, 8, 8, 8, 0.0f, false));
            this.right_arm.field_78804_l.add(new ModelBox(this.right_arm, 48, 42, -6.0f, 5.5f, -2.5f, 4, 2, 6, 0.0f, false));
            this.bone = new ModelRenderer((ModelBase)this);
            this.bone.func_78793_a(-4.0f, 7.5f, 3.5f);
            this.right_arm.func_78792_a(this.bone);
            this.setRotationAngle(this.bone, -0.2618f, 0.0f, 0.0f);
            this.bone.field_78804_l.add(new ModelBox(this.bone, 48, 42, -2.0f, 0.0f, -6.0f, 4, 2, 6, 0.0f, false));
            this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 24, -4.0f, 2.0f, -7.0f, 8, 12, 8, 0.0f, false));
            this.ironGolemLeftArm = new ModelRenderer((ModelBase)this);
            this.ironGolemLeftArm.func_78793_a(8.0f, -10.0f, 0.0f);
            this.left_arm = new ModelRenderer((ModelBase)this);
            this.left_arm.func_78793_a(0.0f, 1.0f, 0.0f);
            this.ironGolemLeftArm.func_78792_a(this.left_arm);
            this.setRotationAngle(this.left_arm, 0.0f, 0.5236f, -0.1745f);
            this.left_arm.field_78804_l.add(new ModelBox(this.left_arm, 24, 42, 0.0f, -2.5f, -3.5f, 8, 8, 8, 0.0f, true));
            this.left_arm.field_78804_l.add(new ModelBox(this.left_arm, 48, 42, 2.0f, 5.5f, -2.5f, 4, 2, 6, 0.0f, true));
            this.bone2 = new ModelRenderer((ModelBase)this);
            this.bone2.func_78793_a(4.0f, 7.5f, 3.5f);
            this.left_arm.func_78792_a(this.bone2);
            this.setRotationAngle(this.bone2, -0.2618f, 0.0f, 0.0f);
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 48, 42, -2.0f, 0.0f, -6.0f, 4, 2, 6, 0.0f, true));
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 24, -4.0f, 2.0f, -7.0f, 8, 12, 8, 0.0f, true));
            this.ironGolemRightLeg = new ModelRenderer((ModelBase)this);
            this.ironGolemRightLeg.func_78793_a(-3.5f, 5.5f, 0.0f);
            this.right_leg = new ModelRenderer((ModelBase)this);
            this.right_leg.func_78793_a(0.0f, 0.0f, 0.0f);
            this.ironGolemRightLeg.func_78792_a(this.right_leg);
            this.setRotationAngle(this.right_leg, -0.2618f, 0.2618f, 0.0f);
            this.right_leg.field_78804_l.add(new ModelBox(this.right_leg, 58, 0, -5.5f, 0.0f, -3.0f, 6, 10, 6, -0.2f, false));
            this.right_leg2 = new ModelRenderer((ModelBase)this);
            this.right_leg2.func_78793_a(-2.5f, 10.0f, -3.0f);
            this.right_leg.func_78792_a(this.right_leg2);
            this.setRotationAngle(this.right_leg2, 0.2618f, 0.0f, 0.0f);
            this.right_leg2.field_78804_l.add(new ModelBox(this.right_leg2, 0, 44, -3.0f, 0.0f, 0.0f, 6, 10, 6, 0.2f, false));
            this.ironGolemLeftLeg = new ModelRenderer((ModelBase)this);
            this.ironGolemLeftLeg.func_78793_a(3.5f, 5.5f, 0.0f);
            this.left_leg = new ModelRenderer((ModelBase)this);
            this.left_leg.func_78793_a(0.0f, 0.0f, 0.0f);
            this.ironGolemLeftLeg.func_78792_a(this.left_leg);
            this.setRotationAngle(this.left_leg, -0.2618f, -0.2618f, 0.0f);
            this.left_leg.field_78804_l.add(new ModelBox(this.left_leg, 58, 0, -0.5f, 0.0f, -3.0f, 6, 10, 6, -0.2f, true));
            this.left_leg2 = new ModelRenderer((ModelBase)this);
            this.left_leg2.func_78793_a(2.5f, 10.0f, -3.0f);
            this.left_leg.func_78792_a(this.left_leg2);
            this.setRotationAngle(this.left_leg2, 0.2618f, 0.0f, 0.0f);
            this.left_leg2.field_78804_l.add(new ModelBox(this.left_leg2, 0, 44, -3.0f, 0.0f, 0.0f, 6, 10, 6, 0.2f, true));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            float scale = ((EC)entity).getScale();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)(1.5f - 1.5f * scale), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.ironGolemHead.func_78785_a(f5);
            this.ironGolemBody.func_78785_a(f5);
            this.ironGolemRightArm.func_78785_a(f5);
            this.ironGolemLeftArm.func_78785_a(f5);
            this.ironGolemRightLeg.func_78785_a(f5);
            this.ironGolemLeftLeg.func_78785_a(f5);
            GlStateManager.func_179121_F();
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
            limbSwing = limbSwing * ((EC)entityIn).ogHeight / entityIn.field_70131_O;
            this.ironGolemHead.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            this.ironGolemHead.field_78795_f = headPitch * ((float)Math.PI / 180);
            this.ironGolemLeftLeg.field_78795_f = -1.5f * this.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
            this.ironGolemRightLeg.field_78795_f = 1.5f * this.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
            this.ironGolemLeftLeg.field_78796_g = 0.0f;
            this.ironGolemRightLeg.field_78796_g = 0.0f;
        }

        public void func_78086_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
            EC entity = (EC)entitylivingbaseIn;
            limbSwing = limbSwing * entity.ogHeight / entity.field_70131_O;
            float f = MathHelper.func_76131_a((float)(((float)entity.getAge() + partialTickTime) / 40.0f), (float)0.0f, (float)1.0f);
            this.ironGolemHead.func_78793_a(this.headStart.x + (this.headEnd.x - this.headStart.x) * f, this.headStart.y + (this.headEnd.y - this.headStart.y) * f, this.headStart.z + (this.headEnd.z - this.headStart.z) * f);
            this.ironGolemBody.func_78793_a(this.bodyStart.x + (this.bodyEnd.x - this.bodyStart.x) * f, this.bodyStart.y + (this.bodyEnd.y - this.bodyStart.y) * f, this.bodyStart.z + (this.bodyEnd.z - this.bodyStart.z) * f);
            this.ironGolemRightArm.func_78793_a(this.rightArmStart.x + (this.rightArmEnd.x - this.rightArmStart.x) * f, this.rightArmStart.y + (this.rightArmEnd.y - this.rightArmStart.y) * f, this.rightArmStart.z + (this.rightArmEnd.z - this.rightArmStart.z) * f);
            this.ironGolemLeftArm.func_78793_a(this.leftArmStart.x + (this.leftArmEnd.x - this.leftArmStart.x) * f, this.leftArmStart.y + (this.leftArmEnd.y - this.leftArmStart.y) * f, this.leftArmStart.z + (this.leftArmEnd.z - this.leftArmStart.z) * f);
            this.ironGolemRightLeg.func_78793_a(this.rightLegStart.x + (this.rightLegEnd.x - this.rightLegStart.x) * f, this.rightLegStart.y + (this.rightLegEnd.y - this.rightLegStart.y) * f, this.rightLegStart.z + (this.rightLegEnd.z - this.rightLegStart.z) * f);
            this.ironGolemLeftLeg.func_78793_a(this.leftLegStart.x + (this.leftLegEnd.x - this.leftLegStart.x) * f, this.leftLegStart.y + (this.leftLegEnd.y - this.leftLegStart.y) * f, this.leftLegStart.z + (this.leftLegEnd.z - this.leftLegStart.z) * f);
            int i = entity.getAttackTimer();
            if (i > 0) {
                this.ironGolemRightArm.field_78795_f = -2.0f + 1.5f * this.triangleWave((float)i - partialTickTime, 10.0f);
                this.ironGolemLeftArm.field_78795_f = -2.0f + 1.5f * this.triangleWave((float)i - partialTickTime, 10.0f);
            } else {
                this.ironGolemRightArm.field_78795_f = (-0.2f + 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
                this.ironGolemLeftArm.field_78795_f = (-0.2f - 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
            }
        }

        private float triangleWave(float p_78172_1_, float p_78172_2_) {
            return (Math.abs(p_78172_1_ % p_78172_2_ - p_78172_2_ * 0.5f) - p_78172_2_ * 0.25f) / (p_78172_2_ * 0.25f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends RenderLiving<EC> {
        private final ResourceLocation texture;

        public RenderCustom(RenderManager renderManagerIn) {
            super(renderManagerIn, (ModelBase)new ModelRockGolem(), 0.5f);
            this.texture = new ResourceLocation("narutomod:textures/golem_rock.png");
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
            this.field_76989_e = 0.6f * entity.getScale();
            super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return this.texture;
        }

        protected void applyRotations(EC entityLiving, float p_77043_2_, float rotationYaw, float partialTicks) {
            super.func_77043_a((EntityLivingBase)entityLiving, p_77043_2_, rotationYaw, partialTicks);
            if ((double)entityLiving.field_70721_aZ >= 0.01) {
                float f1 = entityLiving.field_184619_aG - entityLiving.field_70721_aZ * (1.0f - partialTicks) + 6.0f;
                float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
                GlStateManager.func_179114_b((float)(6.5f * f2), (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    public static class EC
    extends EntitySummonAnimal.Base {
        private final int growTime = 40;
        private int attackTimer;
        private int nextStepDistance;
        private int deathTicks;

        public EC(World w) {
            super(w);
            this.setOGSize(1.0f, 2.875f);
            this.field_70178_ae = true;
            this.postScaleFixup();
        }

        public EC(EntityLivingBase summonerIn, float size) {
            super(summonerIn);
            this.setOGSize(1.0f, 2.875f);
            this.field_70178_ae = true;
            this.setScale(size);
            this.func_70012_b(summonerIn.field_70165_t + summonerIn.func_70040_Z().field_72450_a, summonerIn.field_70163_u, summonerIn.field_70161_v + summonerIn.func_70040_Z().field_72449_c, summonerIn.field_70177_z, 0.0f);
        }

        @Override
        protected void postScaleFixup() {
            float f = this.getScale();
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0 * (double)f);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0 * (double)f);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(15.0 * (double)f);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(10.0 + 6.0 * (double)f);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4 + (double)(f - 1.0f) * 0.1);
            super.postScaleFixup();
            this.field_70728_aV = (int)(f * 10.0f);
        }

        @Override
        protected void dontWander(boolean set) {
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        }

        protected void func_180429_a(BlockPos pos, Block blockIn) {
        }

        public SoundEvent func_184639_G() {
            return null;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return null;
        }

        public SoundEvent func_184615_bR() {
            return null;
        }

        public double func_70042_X() {
            return (double)this.field_70131_O - 0.35;
        }

        @Override
        protected boolean func_184219_q(Entity passenger) {
            return this.getScale() >= 2.0f && this.func_184188_bt().size() < 1;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76346_g() instanceof EntityLivingBase && source.func_76346_g().equals((Object)this.getSummoner())) {
                this.func_70609_aI();
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        @Override
        public boolean func_70652_k(Entity entityIn) {
            boolean ret = super.func_70652_k(entityIn);
            if (ret) {
                entityIn.field_70181_x += 0.4 * (0.3 + 0.7 * (double)this.getScale());
                entityIn.field_70133_I = true;
            }
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
            this.attackTimer = 10;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            return ret;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70103_a(byte id) {
            if (id == 4) {
                this.attackTimer = 10;
                this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
            } else {
                super.func_70103_a(id);
            }
        }

        public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
            super.func_70624_b((EntityLivingBase)(this.getAge() > this.growTime ? entitylivingbaseIn : null));
        }

        @SideOnly(value=Side.CLIENT)
        public int getAttackTimer() {
            return this.attackTimer;
        }

        @Override
        protected void func_70609_aI() {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:rocks")), 1.0f, 0.8f);
                Particles.spawnParticle(this.field_70170_p, Particles.Types.BLOCK_DUST, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v, (int)(this.getScale() * 1000.0f), 0.5 * (double)this.field_70130_N, 0.3 * (double)this.field_70131_O, 0.5 * (double)this.field_70130_N, 0.0, 0.0, 0.0, Block.func_149682_b((Block)Blocks.field_150346_d), 40);
            }
            this.func_70106_y();
        }

        @Override
        public void func_70636_d() {
            this.func_70674_bp();
            super.func_70636_d();
            if (this.getSummoner() == null) {
                this.func_70609_aI();
            } else {
                float f;
                int age = this.getAge();
                if (age == 1) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:rocks")), 1.0f, 0.8f);
                }
                if (age <= this.growTime) {
                    for (int i = 0; i < (int)(this.getScale() * 20.0f); ++i) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u, this.field_70161_v, (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 0.25, 0.15, (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 0.25, new int[]{Block.func_149682_b((Block)Blocks.field_150346_d)});
                    }
                }
                if ((f = this.field_82151_R * this.ogHeight / this.field_70131_O) > (float)this.nextStepDistance && !this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u - 0.2, this.field_70161_v))) {
                    this.nextStepDistance = (int)f + 1;
                    if (!this.func_70090_H()) {
                        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
                    }
                }
            }
            if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (power >= 1.0f) {
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity, power));
                    return true;
                }
                return false;
            }
        }
    }
}

