/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntitySpike;
import net.narutomod.item.ItemJutsu;

@ElementsNarutomodMod.ModElement.Tag
public class EntityEarthSpears
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 243;
    public static final int ENTITYID_RANGED = 244;

    public EntityEarthSpears(ElementsNarutomodMod instance) {
        super(instance, 571);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "earth_spears"), 243).name("earth_spears").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new EntitySpike.Renderer<EC>(renderManager){

            @Override
            protected ResourceLocation getEntityTexture(EC entity) {
                return new ResourceLocation("narutomod:textures/spike_stone.png");
            }
        });
    }

    public static class EC
    extends EntitySpike.Base {
        private final int growTime = 8;
        private final float maxScale = 2.0f;
        private final float damage = 10.0f;

        public EC(World worldIn) {
            super(worldIn);
            this.setColor(-1);
        }

        public EC(EntityLivingBase userIn, float damageIn) {
            super(userIn, -1);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.ticksAlive <= this.growTime) {
                if (this.field_70170_p instanceof WorldServer) {
                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u, this.field_70161_v, 6, 0.0, 0.0, 0.0, 0.15, new int[]{Block.func_149682_b((Block)Blocks.field_150348_b)});
                }
                float f = this.maxScale * (float)this.ticksAlive;
                ((Object)((Object)this)).getClass();
                this.setEntityScale(MathHelper.func_76131_a((float)(f / 8.0f), (float)0.0f, (float)this.maxScale));
                for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) {
                    if (entity.equals((Object)this.shootingEntity)) continue;
                    entity.field_70172_ad = 10;
                    DamageSource damageSource = ItemJutsu.causeJutsuDamage(this, this.shootingEntity);
                    float f2 = this.ticksAlive - 1;
                    ((Object)((Object)this)).getClass();
                    entity.func_70097_a(damageSource, this.damage * (1.0f - f2 / 8.0f));
                }
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Vec3d vec3d2;
                World world = entity.field_70170_p;
                Vec3d vec3d = entity.func_174824_e(1.0f);
                RayTraceResult res = world.func_147447_a(vec3d, vec3d2 = vec3d.func_178787_e(entity.func_70040_Z().func_186678_a(30.0)), false, true, true);
                if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK && res.field_178784_b == EnumFacing.UP) {
                    world.func_184133_a(null, res.func_178782_a(), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:hand_press")), SoundCategory.BLOCKS, 5.0f, entity.func_70681_au().nextFloat() * 0.4f + 0.8f);
                    float f = MathHelper.func_76129_c((float)(power * 9.0f / 5.0f));
                    for (int i = 0; i < Math.round(power); ++i) {
                        EC entity1 = new EC(entity, power);
                        Vec3d vec = res.field_72307_f.func_72441_c((entity.func_70681_au().nextDouble() - 0.5) * (double)f, 0.0, (entity.func_70681_au().nextDouble() - 0.5) * (double)f);
                        while (!world.func_180495_p(new BlockPos(vec)).func_185896_q()) {
                            vec = vec.func_178786_a(0.0, 1.0, 0.0);
                        }
                        while (world.func_180495_p(new BlockPos(vec).func_177984_a()).func_185896_q()) {
                            vec = vec.func_72441_c(0.0, 1.0, 0.0);
                        }
                        entity1.func_70012_b(vec.field_72450_a, vec.field_72448_b + 0.5, vec.field_72449_c, entity.func_70681_au().nextFloat() * 360.0f, (entity.func_70681_au().nextFloat() - 0.5f) * 60.0f);
                        world.func_72838_d((Entity)entity1);
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

