/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityClone;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAoeCommand;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityExplosiveClone
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 239;
    public static final int ENTITYID_RANGED = 240;

    public EntityExplosiveClone(ElementsNarutomodMod instance) {
        super(instance, 560);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "explosive_clone"), 239).name("explosive_clone").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new CustomRender(renderManager));
    }

    public static class EC
    extends EntityClone.Base {
        private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187198_h);
        private final int fuse = 30;
        private int ignitionTime;

        public EC(World world) {
            super(world);
            this.field_70138_W = 16.0f;
            this.field_70765_h = new EntityNinjaMob.MoveHelper(this);
        }

        public EC(EntityLivingBase user) {
            super(user);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
            double d = ProcedureUtils.getModifiedSpeed(user) * 4.0;
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(d);
            this.field_70138_W = 16.0f;
            this.field_70765_h = new EntityNinjaMob.MoveHelper(this);
        }

        @Override
        protected void func_70088_a() {
            super.func_70088_a();
            this.field_70180_af.func_187214_a(IGNITED, (Object)false);
        }

        private void ignite() {
            this.field_70180_af.func_187227_b(IGNITED, (Object)true);
        }

        private boolean ignited() {
            return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
        }

        @Override
        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityClone.AIFollowSummoner((EntityLiving)this, 0.8, 4.0f));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            return this.ignited() ? false : super.func_70097_a(source, amount);
        }

        @Override
        public boolean func_70652_k(Entity entityIn) {
            this.ignite();
            return super.func_70652_k(entityIn);
        }

        private void explode() {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70729_aU = true;
                EntityLivingBase summoner = this.getSummoner();
                this.field_70170_p.func_72876_a((Entity)summoner, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0f, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)summoner));
                ProcedureAoeCommand.set((Entity)this, 0.0, 8.0).damageEntitiesCentered(ItemJutsu.causeJutsuDamage((Entity)this, summoner), 50.0f);
                this.func_70106_y();
            }
        }

        @Override
        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.poof();
            }
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.func_70089_S()) {
                if (this.ignited()) {
                    if (this.ignitionTime + 1 == this.field_70173_aa) {
                        this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
                        EntityLivingBase summoner = this.getSummoner();
                        if (summoner != null) {
                            this.field_70170_p.func_184148_a(null, summoner.field_70165_t, summoner.field_70163_u, summoner.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:katsu")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                        }
                    } else if (this.field_70173_aa - this.ignitionTime > this.fuse) {
                        this.explode();
                    }
                } else {
                    this.ignitionTime = this.field_70173_aa;
                }
            }
        }

        public float getIgnitionProgress(float partialTick) {
            return ((float)this.field_70173_aa + partialTick - (float)this.ignitionTime) / (float)(this.fuse - 2);
        }

        private void poof() {
            this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:poof")), 1.0f, 1.0f);
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 200, (double)this.field_70130_N * 0.5, (double)this.field_70131_O * 0.3, (double)this.field_70130_N * 0.5, 0.02, new int[0]);
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (!entity.func_70093_af()) {
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:kagebunshin")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity));
                    return true;
                }
                for (EC clone : entity.field_70170_p.func_175644_a(EC.class, EntitySelectors.field_94557_a)) {
                    clone.func_70106_y();
                }
                return false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class CustomRender
    extends EntityClone.ClientRLM.RenderClone<EC> {
        public CustomRender(RenderManager renderManagerIn) {
            EntityClone.ClientRLM clientRLM = EntityClone.ClientRLM.getInstance();
            clientRLM.getClass();
            super(renderManagerIn);
        }

        @Override
        protected void preRenderCallback(EC entity, float partialTick) {
            super.preRenderCallback(entity, partialTick);
            if (entity.ignited()) {
                float f = entity.getIgnitionProgress(partialTick);
                float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
                f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
                f *= f;
                f *= f;
                float f2 = (1.0f + f * 0.4f) * f1;
                float f3 = (1.0f + f * 0.1f) / f1;
                GlStateManager.func_179152_a((float)f2, (float)f3, (float)f2);
            }
        }

        protected int getColorMultiplier(EC entity, float lightBrightness, float partialTick) {
            if (entity.ignited()) {
                float f = entity.getIgnitionProgress(partialTick);
                int i = MathHelper.func_76125_a((int)((int)((1.0f - f) * 255.0f)), (int)1, (int)255);
                return i << 24 | 0xFFFFFF;
            }
            return 0;
        }
    }
}

