/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAirPunch;

@ElementsNarutomodMod.ModElement.Tag
public class EntityFutonVacuum
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 185;
    public static final int ENTITYID_RANGED = 186;

    public EntityFutonVacuum(ElementsNarutomodMod instance) {
        super(instance, 449);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "futon_vacuum"), 185).name("futon_vacuum").tracker(64, 3, true).build());
    }

    public static class EC
    extends Entity {
        private final AirStream airStream = new AirStream();
        private final float damageModifier = 0.5f;
        private EntityLivingBase user;
        private float power;

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
        }

        public EC(EntityLivingBase userIn, float powerIn) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.power = powerIn;
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
        }

        protected void func_70088_a() {
        }

        public void func_70071_h_() {
            if (this.user != null) {
                this.func_70107_b(this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
                if (this.field_70173_aa % 5 == 1) {
                    this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, this.field_70146_Z.nextFloat() * 0.5f + 0.8f);
                    this.airStream.execute2(this.user, this.power, 0.5);
                }
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > (int)this.power * 4) {
                this.func_70106_y();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_70112_a(double distance) {
            double d = 68.5 * this.func_184183_bd();
            return distance < d * d;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public void playImpactSound(double x, double y, double z) {
            this.field_70170_p.func_184148_a(null, x, y, z, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:bullet_impact")), SoundCategory.NEUTRAL, 1.0f, 0.4f + this.field_70146_Z.nextFloat() * 0.6f);
        }

        public class AirStream
        extends ProcedureAirPunch {
            public AirStream() {
                this.particlesDuring = null;
            }

            @Override
            protected void attackEntityFrom(EntityLivingBase player, Entity target) {
                if (!target.equals((Object)player)) {
                    EC.this.playImpactSound(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                    target.func_70097_a(ItemJutsu.causeJutsuDamage(EC.this, player), EC.this.power * 0.5f);
                }
            }

            @Override
            protected void preExecuteParticles(EntityLivingBase player) {
                Vec3d vec = player.func_70040_Z();
                Vec3d vec0 = vec.func_186678_a(2.0).func_72441_c(player.field_70165_t, player.field_70163_u + 1.6, player.field_70161_v);
                for (int i = 1; i < 400; ++i) {
                    Vec3d vec1 = vec.func_186678_a(player.func_70681_au().nextDouble() * (double)EC.this.power * 0.25);
                    Particles.spawnParticle(player.field_70170_p, Particles.Types.SMOKE, vec0.field_72450_a, vec0.field_72448_b, vec0.field_72449_c, 1, 0.0, 0.0, 0.0, vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, 0x20FFFFFF, 10);
                }
            }

            @Override
            protected float getBreakChance(BlockPos pos, EntityLivingBase player, double range) {
                EC.this.playImpactSound(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return 0.2f;
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (power >= 1.0f) {
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity, power));
                    return true;
                }
                return false;
            }
        }
    }
}

