/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntitySummonAnimal;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityGiantDog2h
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 181;
    public static final int ENTITYID_RANGED = 182;
    private static final float ENTITY_SCALE = 8.0f;

    public EntityGiantDog2h(ElementsNarutomodMod instance) {
        super(instance, 446);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "giant_dog_2h"), 181).name("giant_dog_2h").tracker(64, 3, true).egg(-11388356, -9088173).build());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderLiving(renderManager, new ModelDog2head(), 4.0f){

                protected ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("narutomod:textures/dog.png");
                }
            });
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelDog2head
        extends ModelBase {
            private final ModelRenderer headRight;
            private final ModelRenderer headLeft;
            private final ModelRenderer body;
            private final ModelRenderer upperBody;
            private final ModelRenderer leg0;
            private final ModelRenderer leg6;
            private final ModelRenderer leg1;
            private final ModelRenderer leg7;
            private final ModelRenderer leg2;
            private final ModelRenderer leg4;
            private final ModelRenderer leg3;
            private final ModelRenderer leg5;
            private final ModelRenderer tail;

            public ModelDog2head() {
                this.field_78090_t = 64;
                this.field_78089_u = 32;
                this.headRight = new ModelRenderer((ModelBase)this);
                this.headRight.func_78793_a(-3.5f, 13.5f, -7.0f);
                this.setRotationAngle(this.headRight, 0.0f, 0.2618f, 0.0f);
                this.headRight.field_78804_l.add(new ModelBox(this.headRight, 0, 0, -2.0f, -3.0f, -2.0f, 5, 6, 4, 0.0f, false));
                this.headRight.field_78804_l.add(new ModelBox(this.headRight, 0, 10, -1.0f, -0.0156f, -5.0f, 3, 3, 4, 0.0f, false));
                this.headRight.field_78804_l.add(new ModelBox(this.headRight, 16, 11, 0.0539f, -1.5f, -4.0f, 1, 2, 1, 0.0f, false));
                this.headLeft = new ModelRenderer((ModelBase)this);
                this.headLeft.func_78793_a(3.5f, 13.5f, -7.0f);
                this.setRotationAngle(this.headLeft, 0.0f, -0.2618f, 0.0f);
                this.headLeft.field_78804_l.add(new ModelBox(this.headLeft, 0, 0, -3.0f, -3.0f, -2.0f, 5, 6, 4, 0.0f, false));
                this.headLeft.field_78804_l.add(new ModelBox(this.headLeft, 0, 10, -2.0f, -0.0156f, -5.0f, 3, 3, 4, 0.0f, false));
                this.headLeft.field_78804_l.add(new ModelBox(this.headLeft, 16, 11, -1.0f, -1.5f, -4.0f, 1, 2, 1, 0.0f, false));
                this.body = new ModelRenderer((ModelBase)this);
                this.body.func_78793_a(0.0f, 10.5f, 0.0f);
                this.setRotationAngle(this.body, 1.3963f, 0.0f, 0.0f);
                this.body.field_78804_l.add(new ModelBox(this.body, 18, 14, -3.0f, 0.0f, -6.0f, 6, 9, 6, 0.0f, false));
                this.upperBody = new ModelRenderer((ModelBase)this);
                this.upperBody.func_78793_a(0.0f, 14.0f, 2.0f);
                this.setRotationAngle(this.upperBody, -1.5708f, 0.0f, 0.0f);
                this.upperBody.field_78804_l.add(new ModelBox(this.upperBody, 21, 0, -4.0f, 2.0f, -4.0f, 8, 6, 7, 0.0f, false));
                this.leg0 = new ModelRenderer((ModelBase)this);
                this.leg0.func_78793_a(-2.5f, 13.0f, 6.0f);
                this.setRotationAngle(this.leg0, 0.2618f, 0.0f, 0.0873f);
                this.leg0.field_78804_l.add(new ModelBox(this.leg0, 0, 18, -1.0f, 0.0f, -1.0f, 2, 6, 2, 0.5f, false));
                this.leg6 = new ModelRenderer((ModelBase)this);
                this.leg6.func_78793_a(-1.0f, 6.0f, 1.25f);
                this.leg0.func_78792_a(this.leg6);
                this.setRotationAngle(this.leg6, -0.2618f, 0.0f, -0.0873f);
                this.leg6.field_78804_l.add(new ModelBox(this.leg6, 0, 18, 0.0f, 0.0f, -2.0f, 2, 6, 2, 0.0f, false));
                this.leg1 = new ModelRenderer((ModelBase)this);
                this.leg1.func_78793_a(2.5f, 13.0f, 6.0f);
                this.setRotationAngle(this.leg1, 0.2618f, 0.0f, -0.0873f);
                this.leg1.field_78804_l.add(new ModelBox(this.leg1, 0, 18, -1.0f, 0.0f, -1.0f, 2, 6, 2, 0.5f, true));
                this.leg7 = new ModelRenderer((ModelBase)this);
                this.leg7.func_78793_a(1.0f, 6.0f, 1.25f);
                this.leg1.func_78792_a(this.leg7);
                this.setRotationAngle(this.leg7, -0.2618f, 0.0f, 0.0873f);
                this.leg7.field_78804_l.add(new ModelBox(this.leg7, 0, 18, -2.0f, 0.0f, -2.0f, 2, 6, 2, 0.0f, true));
                this.leg2 = new ModelRenderer((ModelBase)this);
                this.leg2.func_78793_a(-2.5f, 13.0f, -4.0f);
                this.setRotationAngle(this.leg2, 0.2618f, 0.0f, 0.2618f);
                this.leg2.field_78804_l.add(new ModelBox(this.leg2, 0, 18, -1.0f, 0.0f, -1.0f, 2, 6, 2, 0.0f, false));
                this.leg4 = new ModelRenderer((ModelBase)this);
                this.leg4.func_78793_a(-1.0f, 6.0f, 1.0f);
                this.leg2.func_78792_a(this.leg4);
                this.setRotationAngle(this.leg4, -0.2618f, 0.0f, -0.2618f);
                this.leg4.field_78804_l.add(new ModelBox(this.leg4, 0, 18, 0.0f, 0.0f, -2.0f, 2, 6, 2, 0.0f, false));
                this.leg3 = new ModelRenderer((ModelBase)this);
                this.leg3.func_78793_a(2.5f, 13.0f, -4.0f);
                this.setRotationAngle(this.leg3, 0.2618f, 0.0f, -0.2618f);
                this.leg3.field_78804_l.add(new ModelBox(this.leg3, 0, 18, -1.0f, 0.0f, -1.0f, 2, 6, 2, 0.0f, true));
                this.leg5 = new ModelRenderer((ModelBase)this);
                this.leg5.func_78793_a(1.0f, 6.0f, 1.0f);
                this.leg3.func_78792_a(this.leg5);
                this.setRotationAngle(this.leg5, -0.2618f, 0.0f, 0.2618f);
                this.leg5.field_78804_l.add(new ModelBox(this.leg5, 0, 18, -2.0f, 0.0f, -2.0f, 2, 6, 2, 0.0f, true));
                this.tail = new ModelRenderer((ModelBase)this);
                this.tail.func_78793_a(0.0f, 13.0f, 8.0f);
                this.setRotationAngle(this.tail, 0.9599f, 0.0f, 0.0f);
                this.tail.field_78804_l.add(new ModelBox(this.tail, 9, 18, -1.0f, 0.0f, -1.0f, 2, 8, 2, 0.0f, false));
            }

            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)-10.5f, (float)0.0f);
                GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
                this.headRight.func_78785_a(f5);
                this.headLeft.func_78785_a(f5);
                this.body.func_78785_a(f5);
                this.upperBody.func_78785_a(f5);
                this.leg0.func_78785_a(f5);
                this.leg1.func_78785_a(f5);
                this.leg2.func_78785_a(f5);
                this.leg3.func_78785_a(f5);
                this.tail.func_78785_a(f5);
                GlStateManager.func_179121_F();
            }

            public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
                modelRenderer.field_78795_f = x;
                modelRenderer.field_78796_g = y;
                modelRenderer.field_78808_h = z;
            }

            public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
                super.func_78087_a(f *= 2.0f / e.field_70131_O, f1, f2, f3, f4, f5, e);
                this.headRight.field_78796_g = f3 / 57.295776f;
                this.headRight.field_78795_f = f4 / 57.295776f;
                this.headLeft.field_78796_g = f3 / 57.295776f;
                this.headLeft.field_78795_f = f4 / 57.295776f;
                this.leg0.field_78795_f = 0.2618f + MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
                this.leg1.field_78795_f = 0.2618f + MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
                this.leg2.field_78795_f = 0.2618f + MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
                this.leg3.field_78795_f = 0.2618f + MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
                this.tail.field_78808_h = f2 * 0.2f;
            }
        }
    }

    public static class EntityCustom
    extends EntitySummonAnimal.Base
    implements IMob {
        private int splitTicks;
        private EntityCustom child;

        public EntityCustom(World world) {
            super(world);
            this.setOGSize(0.6f, 0.85f);
            this.field_70728_aV = 5000;
            this.field_70138_W = this.field_70131_O / 3.0f;
            this.postScaleFixup();
        }

        public EntityCustom(EntityLivingBase player, double maxHealth) {
            super(player);
            this.setOGSize(0.6f, 0.85f);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(maxHealth);
            this.field_70728_aV = 5000;
            this.field_70138_W = this.field_70131_O / 3.0f;
            RayTraceResult res = ProcedureUtils.raytraceBlocks((Entity)player, 4.0);
            double x = res.func_178782_a().func_177958_n();
            double z = res.func_178782_a().func_177952_p();
            this.func_70107_b(x + 0.5, player.field_70163_u, z + 0.5);
            this.field_70759_as = this.field_70177_z = player.field_70177_z - 180.0f;
            this.postScaleFixup();
        }

        public EntityCustom(EntityLivingBase player) {
            this(player, 400.0);
        }

        @Override
        public float getScale() {
            return 8.0f;
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 1.0f));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, (double)1.4f, true));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        }

        @Override
        protected void dontWander(boolean set) {
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.wolf.growl"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.wolf.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.wolf.death"));
        }

        protected float func_70599_aP() {
            return 2.0f;
        }

        @Override
        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(30.0);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        }

        @Override
        public boolean func_184645_a(EntityPlayer entity, EnumHand hand) {
            super.func_184645_a(entity, hand);
            if (this.isSummoner((Entity)entity)) {
                entity.func_184220_m((Entity)this);
                return true;
            }
            return false;
        }

        @Override
        public boolean func_70652_k(Entity entityIn) {
            return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }

        public double func_70042_X() {
            return (double)this.field_70131_O + 0.35;
        }

        public boolean shouldRiderSit() {
            return false;
        }

        public int func_82143_as() {
            return 12;
        }

        @Override
        public void func_70106_y() {
            super.func_70106_y();
            this.poof();
            if (!this.field_70170_p.field_72995_K && this.child != null) {
                this.child.func_70106_y();
            }
        }

        @Override
        protected void func_70609_aI() {
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_110138_aP() <= 100.0f) {
                    this.func_70106_y();
                } else {
                    ++this.splitTicks;
                    if (this.splitTicks < 20) {
                        this.func_94061_f(true);
                    } else {
                        float maxhp = this.func_110138_aP() * 0.5f;
                        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxhp);
                        this.func_70606_j(maxhp);
                        this.func_94061_f(false);
                        this.child = this.createChild(maxhp);
                        if (this.child != null) {
                            this.child.func_82149_j((Entity)this);
                            this.child.field_70759_as = this.field_70759_as;
                            this.field_70170_p.func_72838_d((Entity)this.child);
                        }
                    }
                }
            }
        }

        private void poof() {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:poof")), 1.0f, 1.0f);
                Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 300, (double)this.field_70130_N * 0.5, (double)this.field_70131_O * 0.3, (double)this.field_70130_N * 0.5, 0.0, 0.0, 0.0, -788529153, 60);
            }
        }

        public void func_70030_z() {
            EntityLivingBase owner = this.getSummoner();
            if (owner != null && owner.func_110143_aJ() <= 0.0f) {
                this.func_70106_y();
            }
            super.func_70030_z();
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                this.func_70106_y();
            }
            this.field_70143_R = 0.0f;
        }

        @Override
        protected void func_82167_n(Entity entity) {
            if (!this.field_70170_p.field_72995_K && entity instanceof EntityLivingBase && !this.isSummoner((Entity)((EntityLivingBase)entity))) {
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f);
            }
            super.func_82167_n(entity);
        }

        @Nullable
        private EntityCustom createChild(float health) {
            EntityLivingBase summoner;
            if (!this.field_70170_p.field_72995_K && (summoner = this.getSummoner()) != null) {
                return new EntityCustom(summoner, health);
            }
            return null;
        }
    }
}

