/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityClone;
import net.narutomod.entity.EntityIceDome;
import net.narutomod.entity.EntityIceSpear;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.item.ItemHyoton;
import net.narutomod.item.ItemIceSenbon;

@ElementsNarutomodMod.ModElement.Tag
public class EntityHaku
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 237;
    public static final int ENTITYID_RANGED = 238;

    public EntityHaku(ElementsNarutomodMod instance) {
        super(instance, 547);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "haku"), 237).name("haku").tracker(64, 3, true).egg(-16737895, -1).build());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderCustom(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelBiped64slim
        extends ModelBiped {
            public ModelBiped64slim() {
                this.field_78090_t = 64;
                this.field_78089_u = 64;
                this.field_187075_l = ModelBiped.ArmPose.EMPTY;
                this.field_187076_m = ModelBiped.ArmPose.EMPTY;
                this.field_78116_c = new ModelRenderer((ModelBase)this);
                this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_78116_c.field_78804_l.add(new ModelBox(this.field_78116_c, 0, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f, false));
                this.field_178720_f = new ModelRenderer((ModelBase)this);
                this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_178720_f.field_78804_l.add(new ModelBox(this.field_178720_f, 32, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.3f, false));
                this.field_78115_e = new ModelRenderer((ModelBase)this);
                this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 16, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.0f, false));
                this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 32, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.25f, false));
                this.field_178723_h = new ModelRenderer((ModelBase)this);
                this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
                this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 16, -2.0f, -2.0f, -2.0f, 3, 12, 4, 0.0f, false));
                this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 32, -2.0f, -2.0f, -2.0f, 3, 12, 4, 0.25f, false));
                this.field_178724_i = new ModelRenderer((ModelBase)this);
                this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
                this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 32, 48, -1.0f, -2.0f, -2.0f, 3, 12, 4, 0.0f, false));
                this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 48, 48, -1.0f, -2.0f, -2.0f, 3, 12, 4, 0.25f, false));
                this.field_178721_j = new ModelRenderer((ModelBase)this);
                this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
                this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 16, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
                this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 32, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f, false));
                this.field_178722_k = new ModelRenderer((ModelBase)this);
                this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
                this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 16, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
                this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 0, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f, false));
            }

            public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
                super.func_78087_a(f, f1, f2, f3, f4, f5, e);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends EntityNinjaMob.RenderBase<EntityCustom> {
            private final ResourceLocation TEXTURE;

            public RenderCustom(RenderManager renderManagerIn) {
                super(renderManagerIn, new ModelBiped64slim());
                this.TEXTURE = new ResourceLocation("narutomod:textures/haku.png");
            }

            protected void preRenderCallback(EntityCustom entity, float partialTickTime) {
                float f = 0.875f;
                GlStateManager.func_179152_a((float)f, (float)f, (float)f);
            }

            protected ResourceLocation getEntityTexture(EntityCustom entity) {
                return this.TEXTURE;
            }
        }
    }

    public static class EntityCustom
    extends EntityNinjaMob.Base
    implements IRangedAttackMob,
    IMob {
        private EntityLivingBase leader;
        private boolean shouldDefendLeader = true;
        private final int ICE_SPEARS_CD = 80;
        private final int DOME_SPEARS_CD = 160;
        private final int DOME_CD = 500;
        private final int MAX_DOME_USAGE = 340;
        private final double ICE_SPEARS_CHAKRA;
        private final double ICE_DOME_CHAKRA;
        private EntityIceDome.EC domeEntity;
        private int domeSpearsLastUsed;
        private int domeLastUsed;
        private final ItemStack senbon;

        public EntityCustom(World worldIn) {
            super(worldIn, 80, 4000.0);
            this.ICE_SPEARS_CHAKRA = ItemHyoton.ICESPEARS.chakraUsage;
            this.ICE_DOME_CHAKRA = ItemHyoton.ICEDOME.chakraUsage;
            this.senbon = new ItemStack(ItemIceSenbon.block, 1);
            this.func_70105_a(0.525f, 1.75f);
            this.field_70178_ae = true;
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee(this, 1.5, true){

                public boolean func_75250_a() {
                    return super.func_75250_a() && this.field_75441_b.func_70643_av() == null;
                }

                public boolean func_75253_b() {
                    return super.func_75253_b() && (double)this.field_75441_b.func_70638_az().func_70032_d((Entity)this) <= 3.0;
                }
            });
            this.field_70714_bg.func_75776_a(2, new EntityNinjaMob.AIAttackRangedTactical<EntityCustom>(this, 1.25, 80, 10.0f));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIFollowLeader(this, 0.5, 4.0f));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        }

        protected float func_70647_i() {
            return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 2.4f;
        }

        @Override
        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(40.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        }

        public void setLeader(EntityLivingBase entity) {
            this.leader = entity;
        }

        public boolean func_184191_r(Entity entityIn) {
            return super.func_184191_r(entityIn) || EntityNinjaMob.TeamZabuza.contains(entityIn.getClass());
        }

        public void func_70624_b(@Nullable EntityLivingBase entityIn) {
            super.func_70624_b(entityIn);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, entityIn == null ? ItemStack.field_190927_a : this.senbon);
        }

        @Override
        protected void func_70619_bc() {
            if (this.func_70638_az() != null) {
                EntityLivingBase target = this.func_70638_az();
                if ((this.leader != null && this.leader.func_110143_aJ() < this.leader.func_110138_aP() * 0.25f || this.func_110143_aJ() < this.func_110138_aP() * 0.5f) && !this.domeActive() && this.field_70173_aa > this.domeLastUsed + 500 && this.getChakra() > this.ICE_DOME_CHAKRA * 5.0) {
                    this.domeEntity = new EntityIceDome.EC.Jutsu().createJutsu((EntityLivingBase)this, target.field_70165_t, target.field_70163_u - 0.1, target.field_70161_v);
                    this.domeEntity.excludeEntity(this.leader);
                    this.domeSpearsLastUsed = this.field_70173_aa - 160 + 60;
                    this.domeLastUsed = this.field_70173_aa;
                }
            }
            if (this.domeActive()) {
                if (this.domeEntity.field_70173_aa > 340) {
                    this.domeEntity.func_70106_y();
                } else if (this.field_70173_aa > this.domeSpearsLastUsed + 160) {
                    this.domeEntity.shootSpears();
                    this.domeSpearsLastUsed = this.field_70173_aa;
                }
            }
            super.func_70619_bc();
        }

        private boolean domeActive() {
            return this.domeEntity != null && this.domeEntity.func_70089_S();
        }

        public void func_184724_a(boolean swingingArms) {
        }

        public void func_82196_d(EntityLivingBase target, float flval) {
            if (!this.field_70170_p.field_72995_K && this.consumeChakra(this.ICE_SPEARS_CHAKRA)) {
                new EntityIceSpear.EC.Jutsu().createJutsu((EntityLivingBase)this, target, 2.0f);
            }
        }

        public static class AIFollowLeader
        extends EntityClone.AIFollowSummoner {
            private final EntityCustom entity;

            public AIFollowLeader(EntityCustom entityIn, double speed, float stopRange) {
                super((EntityLiving)entityIn, speed, stopRange);
                this.entity = entityIn;
            }

            @Override
            public boolean func_75250_a() {
                if (this.entity.leader == null) {
                    return false;
                }
                if (this.entity.leader instanceof EntityPlayer && ((EntityPlayer)this.entity.leader).func_175149_v()) {
                    return false;
                }
                if (this.entity.func_70068_e((Entity)this.entity.leader) < (double)(this.stopDistance * this.stopDistance)) {
                    return false;
                }
                this.followingEntity = this.entity.leader;
                return true;
            }

            @Override
            protected double getSpeed() {
                if (this.followingEntity instanceof EntityLiving && ((EntityLiving)this.followingEntity).func_70638_az() != null) {
                    return super.getSpeed() * 2.0;
                }
                return super.getSpeed();
            }
        }
    }
}

