/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.PlayerTracker;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemKunai3prong;
import net.narutomod.item.ItemKunaiHiraishin;
import net.narutomod.item.ItemNinjutsu;
import net.narutomod.procedure.ProcedureOnLivingUpdate;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityHiraishin
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 419;
    public static final int ENTITYID_RANGED = 420;
    private static final Map<UUID, Map<UUID, Vector4d>> serverMarkerMap = Maps.newHashMap();
    private static final Map<UUID, Vector4d> clientMarkerList = Maps.newHashMap();

    public EntityHiraishin(ElementsNarutomodMod instance) {
        super(instance, 841);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "hiraishin"), 419).name("hiraishin").tracker(64, 3, true).build());
    }

    public static void updateServerMarkerMap(UUID ownerUuid, UUID kunaiUuid, @Nullable Vector4d vec4d) {
        EntityPlayerMP owner;
        Map<Object, Object> map;
        if (vec4d == null) {
            if (serverMarkerMap.containsKey(ownerUuid)) {
                map = serverMarkerMap.get(ownerUuid);
                map.remove(kunaiUuid);
                if (map.isEmpty()) {
                    serverMarkerMap.remove(ownerUuid);
                }
            }
        } else if (!serverMarkerMap.containsKey(ownerUuid)) {
            map = Maps.newHashMap();
            map.put(kunaiUuid, vec4d);
            serverMarkerMap.put(ownerUuid, map);
        } else {
            serverMarkerMap.get(ownerUuid).put(kunaiUuid, vec4d);
        }
        if ((owner = ProcedureUtils.getPlayerMatchingUuid(ownerUuid)) != null) {
            UpdateMarkerMessage.sendToPlayer(owner, kunaiUuid, vec4d);
        }
    }

    private static void removeAllMarkersFrom(EntityPlayerMP owner) {
        if (serverMarkerMap.containsKey(owner.func_110124_au())) {
            serverMarkerMap.remove(owner.func_110124_au());
            UpdateMarkerMessage.clearClientMarkers(owner);
        }
    }

    public static boolean canUseJutsu(EntityPlayer player) {
        ItemStack stack = ProcedureUtils.getMatchingItemStack(player, ItemNinjutsu.block);
        return stack != null && ((ItemNinjutsu.RangedItem)stack.func_77973_b()).canActivateJutsu(stack, ItemNinjutsu.HIRAISHIN, player) == EnumActionResult.SUCCESS;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
        this.elements.addNetworkMessage(UpdateMarkerMessage.Handler.class, UpdateMarkerMessage.class, Side.CLIENT);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)Renderer.instance);
    }

    public static class Renderer
    extends EntityRendererRegister {
        private static Renderer instance;
        @SideOnly(value=Side.CLIENT)
        private RenderCustom renderCustom;

        public Renderer() {
            instance = this;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> {
                this.renderCustom = new RenderCustom(renderManager);
                return this.renderCustom;
            });
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onRenderWorldLast(RenderWorldLastEvent event) {
            RenderManager renderManager;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && PlayerTracker.isNinja((EntityPlayer)mc.field_71439_g) && !clientMarkerList.isEmpty() && (renderManager = mc.func_175598_ae()) != null && renderManager.field_78733_k != null && renderManager.field_78733_k.field_74320_O == 0) {
                for (Vector4d vec : clientMarkerList.values()) {
                    Vec3d vec1 = new Vec3d(vec.x, vec.y, vec.z).func_178786_a(renderManager.field_78730_l, renderManager.field_78731_m, renderManager.field_78728_n);
                    AxisAlignedBB aabb = new AxisAlignedBB(vec.x - 0.5, vec.y, vec.z - 0.5, vec.x + 0.5, vec.y + 1.0, vec.z + 0.5);
                    if ((int)vec.w != mc.field_71441_e.field_73011_w.getDimension()) continue;
                    this.renderCustom.renderMarker(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, (float)mc.field_71441_e.func_82737_E() + event.getPartialTicks());
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
            EntityPlayer player = event.getEntityPlayer();
            if (PlayerTracker.isNinja(player) && !clientMarkerList.isEmpty() && EntityHiraishin.canUseJutsu(player)) {
                Vec3d vec1 = player.func_174824_e(1.0f);
                for (Vector4d vec4d : clientMarkerList.values()) {
                    if ((int)vec4d.w != Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension()) continue;
                    Vec3d vec = new Vec3d(vec4d.x, vec4d.y, vec4d.z);
                    double d = vec.func_178788_d(vec1).func_72433_c();
                    Vec3d vec2 = vec1.func_178787_e(player.func_70040_Z().func_186678_a(d + 10.0));
                    AxisAlignedBB aabb = new AxisAlignedBB(vec.field_72450_a - 0.5, vec.field_72448_b, vec.field_72449_c - 0.5, vec.field_72450_a + 0.5, vec.field_72448_b + 1.0, vec.field_72449_c + 0.5);
                    if (aabb.func_186662_g(d / 20.0).func_72327_a(vec1, vec2) == null) continue;
                    Chakra.PathwayPlayer chakra = Chakra.pathway(player);
                    double chakraUsage = (double)MathHelper.func_76133_a((double)d) * 10.0;
                    if (chakra.getAmount() > chakraUsage) {
                        ProcedureOnLivingUpdate.setUntargetable((Entity)player, 5);
                        ProcedureSync.SoundEffectMessage.sendToServer(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:swoosh")), SoundCategory.NEUTRAL, 0.8f, player.func_70681_au().nextFloat() * 0.4f + 0.8f);
                        player.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                        ProcedureSync.EntityPositionAndRotation.sendToServer((Entity)player);
                        Chakra.PathwayPlayer.ConsumeMessage.sendToServer(chakraUsage);
                        continue;
                    }
                    ((Chakra.Pathway)chakra).warningDisplay();
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelFormula
        extends ModelBase {
            private final ModelRenderer bb_main;

            public ModelFormula() {
                this.field_78090_t = 16;
                this.field_78089_u = 16;
                this.bb_main = new ModelRenderer((ModelBase)this);
                this.bb_main.func_78793_a(0.0f, 0.0f, 0.0f);
                this.bb_main.field_78804_l.add(new ModelBox(this.bb_main, -9, 0, -1.5f, 0.0f, -4.5f, 3, 0, 9, 0.1f, false));
            }

            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                this.bb_main.func_78785_a(f5);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends Render<EC> {
            private final ResourceLocation texture;
            protected final ModelBase mainModel;
            private final Item item;
            private final RenderItem itemRenderer;

            public RenderCustom(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.texture = new ResourceLocation("narutomod:textures/hiraishin_formula.png");
                this.mainModel = new ModelFormula();
                this.item = ItemKunaiHiraishin.block;
                this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
            }

            public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
                Entity target = entity.getTarget();
                if (!this.field_76990_c.field_78734_h.equals((Object)target) || this.field_76990_c.field_78733_k.field_74320_O != 0) {
                    float f = partialTicks + (float)entity.field_70173_aa;
                    float entityPitch = entity.field_70125_A;
                    if (target instanceof EntityLivingBase) {
                        EntityLivingBase living = (EntityLivingBase)target;
                        Vector2f vec2 = entity.getOffsetRotations();
                        float targetYaw = ProcedureUtils.interpolateRotation(living.field_70760_ar, living.field_70761_aq, partialTicks);
                        Vec3d vec = entity.getOffsetVec().func_178785_b(-targetYaw * 0.0174533f);
                        x = target.field_70142_S + (target.field_70165_t - target.field_70142_S) * (double)partialTicks + vec.field_72450_a - this.field_76990_c.field_78730_l;
                        y = target.field_70137_T + (target.field_70163_u - target.field_70137_T) * (double)partialTicks + vec.field_72448_b - this.field_76990_c.field_78731_m;
                        z = target.field_70136_U + (target.field_70161_v - target.field_70136_U) * (double)partialTicks + vec.field_72449_c - this.field_76990_c.field_78728_n;
                        entityYaw = targetYaw + vec2.x;
                        entityPitch = vec2.y;
                    }
                    this.func_180548_c(entity);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179129_p();
                    GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)entityYaw, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(-entityPitch), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(f / 40.0f, 1.0f));
                    this.mainModel.func_78088_a((Entity)entity, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0625f);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179121_F();
                }
            }

            protected ResourceLocation getEntityTexture(EC entity) {
                return this.texture;
            }

            protected void renderMarker(double x, double y, double z, float ageInTicks) {
                double d = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
                if (d > 2.0) {
                    y = y / d + 1.425;
                    this.func_110776_a(TextureMap.field_110575_b);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(x /= d), (double)y, (double)(z /= d));
                    GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.8f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * -this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179140_f();
                    this.itemRenderer.func_181564_a(new ItemStack(this.item), ItemCameraTransforms.TransformType.GROUND);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179121_F();
                    this.renderText("" + (int)d, x, y, z);
                }
            }

            private void renderText(String str, double x, double y, double z) {
                FontRenderer fontRenderer = this.func_76983_a();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)x, (double)(y + 0.1), (double)z);
                GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)-0.0025f, (float)-0.0025f, (float)0.0025f);
                GlStateManager.func_179140_f();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179097_i();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int i = fontRenderer.func_78256_a(str) / 2;
                GlStateManager.func_179090_x();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_181662_b((double)(-i - 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.3f).func_181675_d();
                bufferbuilder.func_181662_b((double)(-i - 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.3f).func_181675_d();
                bufferbuilder.func_181662_b((double)(i + 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.3f).func_181675_d();
                bufferbuilder.func_181662_b((double)(i + 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.3f).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
                fontRenderer.func_78276_b(str, -fontRenderer.func_78256_a(str) / 2, 0, 0x20FFFFFF);
                GlStateManager.func_179126_j();
                GlStateManager.func_179132_a((boolean)true);
                fontRenderer.func_78276_b(str, -fontRenderer.func_78256_a(str) / 2, 0, -16711936);
                GlStateManager.func_179145_e();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            }
        }
    }

    public static class UpdateMarkerMessage
    implements IMessage {
        String uuid;
        Vector4d vec;

        public UpdateMarkerMessage() {
        }

        public UpdateMarkerMessage(UUID id, @Nullable Vector4d v4d) {
            this.uuid = id.toString();
            this.vec = v4d;
        }

        public static void sendToPlayer(EntityPlayerMP entity, UUID id, @Nullable Vector4d v4d) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new UpdateMarkerMessage(id, v4d), entity);
        }

        public static void clearClientMarkers(EntityPlayerMP entity) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new UpdateMarkerMessage(), entity);
        }

        public void toBytes(ByteBuf buf) {
            if (this.uuid != null) {
                buf.writeBoolean(true);
                ProcedureSync.writeString(buf, this.uuid);
            } else {
                buf.writeBoolean(false);
            }
            if (this.vec != null) {
                buf.writeBoolean(true);
                buf.writeDouble(this.vec.x);
                buf.writeDouble(this.vec.y);
                buf.writeDouble(this.vec.z);
                buf.writeDouble(this.vec.w);
            } else {
                buf.writeBoolean(false);
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.uuid = buf.readBoolean() ? ProcedureSync.readString(buf) : null;
            this.vec = buf.readBoolean() ? new Vector4d(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble()) : null;
        }

        public static class Handler
        implements IMessageHandler<UpdateMarkerMessage, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(UpdateMarkerMessage message, MessageContext context) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    if (message.uuid == null) {
                        clientMarkerList.clear();
                    } else {
                        UUID uuid = UUID.fromString(message.uuid);
                        if (message.vec != null) {
                            clientMarkerList.put(uuid, message.vec);
                        } else {
                            clientMarkerList.remove(uuid);
                        }
                    }
                });
                return null;
            }
        }
    }

    public static class EC
    extends Entity {
        private static final DataParameter<Optional<UUID>> TARGET_UUID = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187203_m);
        private static final DataParameter<Float> OFFSET_X = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> OFFSET_Y = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> OFFSET_Z = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> OFFSET_YAW = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> OFFSET_PITCH = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private UUID userUuid;

        public EC(World world) {
            super(world);
            this.func_70105_a(0.6f, 0.05f);
            this.field_70178_ae = true;
        }

        public EC(EntityLivingBase userIn, RayTraceResult res) {
            this(userIn.field_70170_p);
            this.userUuid = userIn.func_110124_au();
            if (res.field_178784_b.func_176736_b() == -1) {
                this.field_70177_z = 90.0f * (float)EnumFacing.func_176733_a((double)userIn.field_70177_z).func_176736_b();
                this.field_70125_A = -90.0f * (float)(res.field_178784_b.func_176730_m().func_177956_o() - 1);
            } else {
                this.field_70177_z = 90.0f * (float)res.field_178784_b.func_176734_d().func_176736_b();
                this.field_70125_A = -90.0f;
            }
            this.func_70012_b(res.field_72307_f.field_72450_a, res.field_72307_f.field_72448_b, res.field_72307_f.field_72449_c, this.field_70177_z, this.field_70125_A);
            if (res.field_72308_g != null) {
                this.setTargetUuid(res.field_72308_g.func_110124_au());
                float yaw = res.field_72308_g instanceof EntityLivingBase ? ((EntityLivingBase)res.field_72308_g).field_70761_aq : res.field_72308_g.field_70177_z;
                this.setOffsets(res.field_72307_f.field_72450_a - res.field_72308_g.field_70165_t, res.field_72307_f.field_72448_b - res.field_72308_g.field_70163_u, res.field_72307_f.field_72449_c - res.field_72308_g.field_70161_v, MathHelper.func_76142_g((float)(this.field_70177_z - yaw)), this.field_70125_A);
            }
        }

        protected void func_70088_a() {
            this.field_70180_af.func_187214_a(TARGET_UUID, (Object)Optional.absent());
            this.field_70180_af.func_187214_a(OFFSET_X, (Object)Float.valueOf(0.0f));
            this.field_70180_af.func_187214_a(OFFSET_Y, (Object)Float.valueOf(0.0f));
            this.field_70180_af.func_187214_a(OFFSET_Z, (Object)Float.valueOf(0.0f));
            this.field_70180_af.func_187214_a(OFFSET_YAW, (Object)Float.valueOf(0.0f));
            this.field_70180_af.func_187214_a(OFFSET_PITCH, (Object)Float.valueOf(0.0f));
        }

        private void setTargetUuid(@Nullable UUID uuid) {
            this.field_70180_af.func_187227_b(TARGET_UUID, (Object)Optional.fromNullable((Object)uuid));
        }

        @Nullable
        public UUID getTargetUuid() {
            return (UUID)((Optional)this.field_70180_af.func_187225_a(TARGET_UUID)).orNull();
        }

        @Nullable
        public Entity getTarget() {
            UUID uuid = this.getTargetUuid();
            return uuid != null ? ProcedureUtils.getEntityFromUUID(this.field_70170_p, uuid) : null;
        }

        private void setOffsets(double x, double y, double z, float yaw, float pitch) {
            this.field_70180_af.func_187227_b(OFFSET_X, (Object)Float.valueOf((float)x));
            this.field_70180_af.func_187227_b(OFFSET_Y, (Object)Float.valueOf((float)y));
            this.field_70180_af.func_187227_b(OFFSET_Z, (Object)Float.valueOf((float)z));
            this.field_70180_af.func_187227_b(OFFSET_YAW, (Object)Float.valueOf(yaw));
            this.field_70180_af.func_187227_b(OFFSET_PITCH, (Object)Float.valueOf(pitch));
        }

        private Vec3d getOffsetVec() {
            return new Vec3d((double)((Float)this.func_184212_Q().func_187225_a(OFFSET_X)).floatValue(), (double)((Float)this.func_184212_Q().func_187225_a(OFFSET_Y)).floatValue(), (double)((Float)this.func_184212_Q().func_187225_a(OFFSET_Z)).floatValue());
        }

        private Vector2f getOffsetRotations() {
            return new Vector2f(((Float)this.func_184212_Q().func_187225_a(OFFSET_YAW)).floatValue(), ((Float)this.func_184212_Q().func_187225_a(OFFSET_PITCH)).floatValue());
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && this.userUuid != null) {
                EntityHiraishin.updateServerMarkerMap(this.userUuid, this.func_110124_au(), null);
            }
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K && this.userUuid != null && ((WorldServer)this.field_70170_p).func_175733_a(this.userUuid) != null) {
                boolean update = false;
                UUID targetUuid = this.getTargetUuid();
                if (targetUuid == null) {
                    if (this.field_70173_aa == 1) {
                        update = true;
                    }
                } else {
                    Entity target = ((WorldServer)this.field_70170_p).func_175733_a(targetUuid);
                    if (target != null) {
                        if (target.func_70089_S()) {
                            this.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                            update = true;
                        } else {
                            this.func_70106_y();
                        }
                    }
                }
                if (update) {
                    EntityHiraishin.updateServerMarkerMap(this.userUuid, this.func_110124_au(), new Vector4d(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.field_71093_bK));
                }
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
            if (compound.func_186855_b("userUuid")) {
                this.userUuid = compound.func_186857_a("userUuid");
            }
            if (compound.func_186855_b("targetUuid")) {
                this.setTargetUuid(compound.func_186857_a("targetUuid"));
                this.setOffsets(compound.func_74760_g("offsetX"), compound.func_74760_g("offsetY"), compound.func_74760_g("offsetZ"), compound.func_74760_g("offsetYaw"), compound.func_74760_g("offsetPitch"));
            }
        }

        protected void func_70014_b(NBTTagCompound compound) {
            UUID uuid;
            if (this.userUuid != null) {
                compound.func_186854_a("userUuid", this.userUuid);
            }
            if ((uuid = this.getTargetUuid()) != null) {
                compound.func_186854_a("targetUuid", uuid);
                Vec3d vec = this.getOffsetVec();
                Vector2f vec2 = this.getOffsetRotations();
                compound.func_74776_a("offsetX", (float)vec.field_72450_a);
                compound.func_74776_a("offsetY", (float)vec.field_72448_b);
                compound.func_74776_a("offsetZ", (float)vec.field_72449_c);
                compound.func_74776_a("offsetYaw", vec2.x);
                compound.func_74776_a("offsetPitch", vec2.y);
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)entity, 4.0, true);
                if (res != null && res.field_72313_a != RayTraceResult.Type.MISS) {
                    if (res.field_72308_g instanceof EC) {
                        res.field_72308_g.func_70106_y();
                    } else if (res.field_72308_g instanceof EntityItem && ((EntityItem)res.field_72308_g).func_92059_d().func_77973_b() == ItemKunai3prong.block) {
                        ItemStack stack1 = new ItemStack(ItemKunaiHiraishin.block, 1);
                        ItemKunaiHiraishin.RangedItem.setOwner(stack1, entity);
                        ((EntityItem)res.field_72308_g).func_92058_a(stack1);
                    } else {
                        if (res.field_72313_a == RayTraceResult.Type.BLOCK) {
                            return entity.field_70170_p.func_72838_d((Entity)new EC(entity, res));
                        }
                        if (res.field_72308_g instanceof EntityLivingBase) {
                            EC entity1 = (EC)entity.field_70170_p.func_72857_a(EC.class, res.field_72308_g.func_174813_aQ(), res.field_72308_g);
                            if (entity1 != null && entity1.func_70068_e(res.field_72308_g) < 0.01) {
                                entity1.func_70106_y();
                            } else {
                                return entity.field_70170_p.func_72838_d((Entity)new EC(entity, res));
                            }
                        }
                    }
                }
                return false;
            }
        }
    }
}

