/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityIcePrison
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 226;
    public static final int ENTITYID_RANGED = 227;

    public EntityIcePrison(ElementsNarutomodMod instance) {
        super(instance, 538);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "ice_prison"), 226).name("ice_prison").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new CustomRender(renderManager));
    }

    public static class EC
    extends Entity {
        private EntityLivingBase user;
        private EntityLivingBase target;
        private BlockPos blockpos;
        private BlockPos[] tpos = new BlockPos[4];
        private int tx;
        private int ty;
        private int tz;
        private int tr;
        private int radius;
        private int tHeight;
        private final BlockPos[][] plist = new BlockPos[][]{{new BlockPos(1, 0, 1), new BlockPos(-1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, -1)}, {new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0)}, {new BlockPos(0, 0, -1), new BlockPos(0, 0, -1), new BlockPos(0, 0, 1), new BlockPos(0, 0, 1)}};

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
            this.field_70178_ae = true;
        }

        public EC(EntityLivingBase userIn, EntityLivingBase targetIn) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.target = targetIn;
            this.func_70107_b(targetIn.field_70165_t, targetIn.field_70163_u, targetIn.field_70161_v);
            this.tpos[0] = this.blockpos = new BlockPos((Entity)this);
            this.radius = (int)((double)targetIn.field_70130_N * 0.5 + 1.0);
            this.tHeight = (int)(targetIn.field_70131_O + 1.0f);
        }

        protected void func_70088_a() {
        }

        public void func_70071_h_() {
            if (this.user != null && ItemJutsu.canTarget((Entity)this.target)) {
                int i;
                this.target.func_70634_a(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                HashMap map = Maps.newHashMap();
                for (BlockPos pos : this.tpos) {
                    if (pos == null || !this.field_70170_p.func_175623_d(pos)) continue;
                    map.put(pos, Blocks.field_150432_aD.func_176223_P());
                }
                if (!map.isEmpty()) {
                    new EventSetBlocks(this.field_70170_p, map, 0L, 1200, false, false);
                }
                if ((i = this.field_70173_aa % 4) == 0) {
                    this.target.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 600, 1));
                    ++this.tz;
                    if (this.tz > (int)Math.round((double)this.tr / 1.41421356)) {
                        this.tz = 0;
                        ++this.tr;
                    }
                    if (this.tr > this.radius) {
                        this.tr = 0;
                        ++this.ty;
                    }
                    if (this.ty > this.tHeight) {
                        this.func_70106_y();
                        return;
                    }
                    this.tx = (int)Math.round(Math.sqrt(this.tr * this.tr - this.tz * this.tz));
                }
                this.tpos[0] = this.blockpos.func_177982_a(this.plist[0][i].func_177958_n() * this.tx, this.ty, this.plist[0][i].func_177952_p() * this.tz);
                this.tpos[1] = this.blockpos.func_177982_a(this.plist[0][i].func_177958_n() * this.tz, this.ty, this.plist[0][i].func_177952_p() * this.tx);
                this.tpos[2] = this.tpos[0].func_177971_a((Vec3i)this.plist[1][i]);
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                RayTraceResult result = ProcedureUtils.objectEntityLookingAt((Entity)entity, 10.0, true);
                if (result != null && result.field_72308_g instanceof EntityLivingBase) {
                    entity.field_70170_p.func_184148_a(null, result.field_72308_g.field_70165_t, result.field_72308_g.field_70163_u, result.field_72308_g.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:ice_shoot")), SoundCategory.NEUTRAL, 1.0f, entity.func_70681_au().nextFloat() * 0.4f + 0.8f);
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity, (EntityLivingBase)result.field_72308_g));
                    return true;
                }
                return false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class CustomRender
    extends Render<EC> {
        public CustomRender(RenderManager renderManagerIn) {
            super(renderManagerIn);
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return null;
        }
    }
}

