/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.base.Predicate;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.ModConfig;
import net.narutomod.entity.EntityBijuManager;
import net.narutomod.entity.EntityCrow;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntitySusanooClothed;
import net.narutomod.item.ItemAkatsukiRobe;
import net.narutomod.item.ItemDojutsu;
import net.narutomod.item.ItemKaton;
import net.narutomod.item.ItemKunai;
import net.narutomod.item.ItemMangekyoSharingan;
import net.narutomod.item.ItemSharingan;
import net.narutomod.potion.PotionAmaterasuFlame;
import net.narutomod.potion.PotionParalysis;
import net.narutomod.procedure.ProcedureBasicNinjaSkills;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityItachi
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 117;
    public static final int ENTITYID_RANGED = 118;

    public EntityItachi(ElementsNarutomodMod instance) {
        super(instance, 336);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "itachi"), 117).name("itachi").tracker(64, 3, true).egg(-16777216, -65485).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(Entity4MobAppearance.class).id(new ResourceLocation("narutomod", "itachi_mob_appearance"), 118).name("itachi_mob_appearance").tracker(64, 1, true).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        int i = MathHelper.func_76125_a((int)ModConfig.SPAWN_WEIGHT_ITACHI, (int)0, (int)20);
        if (i > 0) {
            EntityRegistry.addSpawn(EntityCustom.class, (int)i, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76767_f, Biomes.field_76768_g, Biomes.field_76780_h, Biomes.field_76781_i, Biomes.field_76785_t, Biomes.field_76784_u, Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150585_R, Biomes.field_150588_X, Biomes.field_76770_e, Biomes.field_185444_T, Biomes.field_150590_f, Biomes.field_150599_m, Biomes.field_185446_X, Biomes.field_185447_Y, Biomes.field_185448_Z, Biomes.field_185429_aa, Biomes.field_185430_ab, Biomes.field_185435_ag, Biomes.field_185443_S, Biomes.field_185434_af, Biomes.field_150580_W});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderCustom(renderManager, new ModelBiped()));
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends EntityNinjaMob.RenderBase<EntityCustom> {
            private final ResourceLocation texture;

            public RenderCustom(RenderManager renderManagerIn, ModelBiped modelIn) {
                super(renderManagerIn, modelIn);
                this.texture = new ResourceLocation("narutomod:textures/itachi.png");
            }

            protected void renderLayers(EntityCustom entity, float f0, float f1, float f2, float f3, float f4, float f5, float f6) {
                if (!entity.func_82150_aj()) {
                    super.func_177093_a((EntityLivingBase)entity, f0, f1, f2, f3, f4, f5, f6);
                }
            }

            protected void preRenderCallback(EntityCustom entity, float partialTickTime) {
                GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
            }

            public void func_82422_c() {
                GlStateManager.func_179109_b((float)0.0f, (float)0.1875f, (float)0.0f);
            }

            protected ResourceLocation getEntityTexture(EntityCustom entity) {
                return this.texture;
            }
        }
    }

    public static class Entity4MobAppearance
    extends EntityCustom {
        public Entity4MobAppearance(World worldIn) {
            super(worldIn);
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ItemMangekyoSharingan.helmet));
        }
    }

    public static class EntityCustom
    extends EntityNinjaMob.Base
    implements IMob,
    IRangedAttackMob {
        private final double GENJUTSU_CHAKRA = 100.0;
        private final double FIREBALL_CHAKRA = 50.0;
        private final double AMATERASU_CHAKRA = 50.0;
        private final double SUSANOO_CHAKRA = 300.0;
        private final double INVIS_CHAKRA = 20.0;
        private static final int GENJUTSU_COOLDOWN = 100;
        private boolean isReal;
        private int lookedAtTime;
        private final int genjutsuDuration = 200;
        private int lastGenjutsuTime;
        private int lastInvisTime;
        private int lastSusanooTime = -600;
        private EntitySusanooClothed.EntityCustom susanooEntity;
        private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);

        public EntityCustom(World world) {
            super(world, 120, 7000.0);
            this.field_70178_ae = true;
        }

        public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
            ItemStack stack = new ItemStack(ItemMangekyoSharingan.helmet, 1);
            ((ItemDojutsu.Base)stack.func_77973_b()).setOwner(stack, (EntityLivingBase)this);
            this.func_184201_a(EntityEquipmentSlot.HEAD, stack);
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ItemAkatsukiRobe.body, 1));
            this.setItemToInventory(new ItemStack(ItemKunai.block), 0);
            this.setItemToInventory(new ItemStack(ItemAkatsukiRobe.helmet), 1);
            this.setIsReal(this.field_70146_Z.nextInt(ModConfig.ITACHI_REAL_CHANCE) == 0);
            return super.func_180482_a(difficulty, livingdata);
        }

        public void setIsReal(boolean real) {
            this.isReal = real;
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityNinjaMob.AIAttackRangedTactical(this, 1.0, 50, 16.0f){

                @Override
                public boolean func_75250_a() {
                    return super.func_75250_a() && !this.isSusanooActive() && (double)this.func_70638_az().func_70032_d((Entity)this) > 4.0;
                }
            });
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityNinjaMob.AILeapAtTarget((EntityLiving)this, 1.0f){

                @Override
                public boolean func_75250_a() {
                    return super.func_75250_a() && !this.func_184218_aH() && this.func_70638_az().field_70163_u - field_70163_u > 3.0;
                }
            });
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(this, 1.0, true){

                public boolean func_75250_a() {
                    return super.func_75250_a() && !this.func_184218_aH() && (double)this.func_70638_az().func_70032_d((Entity)this) <= 4.0;
                }
            });
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 15.0f, 1.0f));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.3));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, (Predicate)new Predicate<EntityPlayer>(){

                public boolean apply(@Nullable EntityPlayer p_apply_1_) {
                    return p_apply_1_ != null && (ItemSharingan.wearingAny((EntityLivingBase)p_apply_1_) || EntityBijuManager.isJinchuriki(p_apply_1_));
                }
            }));
        }

        @Override
        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(100.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        }

        protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
            this.func_70099_a(new ItemStack(ItemKunai.block, 1), 0.0f);
            if (this.isReal) {
                ItemStack stack = this.func_184582_a(EntityEquipmentSlot.HEAD);
                if (stack.func_77973_b() != ItemMangekyoSharingan.helmet) {
                    stack = this.getItemFromInventory(1);
                }
                if (stack.func_77973_b() == ItemMangekyoSharingan.helmet) {
                    ((ItemSharingan.Base)stack.func_77973_b()).forceDamage(stack, this.field_70146_Z.nextInt(stack.func_77958_k()));
                    this.func_70099_a(stack, 0.0f);
                }
            }
        }

        @Override
        public SoundEvent func_184615_bR() {
            return SoundEvents.field_193786_de;
        }

        public boolean func_184191_r(Entity entityIn) {
            return super.func_184191_r(entityIn) || EntityNinjaMob.TeamItachi.contains(entityIn.getClass());
        }

        private boolean isSusanooActive() {
            return this.susanooEntity != null && this.susanooEntity.func_70089_S();
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                boolean ret = true;
                Entity entity1 = source.func_76346_g();
                if (this.field_70146_Z.nextInt(3) <= 1) {
                    this.func_70634_a(this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 2.0, this.field_70163_u, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                    ret = false;
                } else if (this.isReal && this.func_110143_aJ() > 0.0f && this.func_110143_aJ() - amount <= this.func_110138_aP() / 3.0f && !this.func_184218_aH() && this.field_70173_aa > this.lastSusanooTime + 600 && this.getChakra() >= 300.0) {
                    this.susanooEntity = new EntitySusanooClothed.EntityCustom((EntityLivingBase)this, false);
                    this.susanooEntity.setLifeSpan(600);
                    this.field_70170_p.func_72838_d((Entity)this.susanooEntity);
                    this.func_184220_m((Entity)this.susanooEntity);
                    this.consumeChakra(300.0);
                    this.lastSusanooTime = this.field_70173_aa;
                    this.susanooEntity.func_70097_a(source, amount);
                    ret = false;
                } else if (this.field_70173_aa > this.lastInvisTime + 200 && this.getChakra() >= 20.0) {
                    this.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 200, 1, false, false));
                    for (int i = 0; i < 100; ++i) {
                        EntityCrow.EntityCustom entityToSpawn = new EntityCrow.EntityCustom(this.field_70170_p);
                        entityToSpawn.func_70012_b(this.field_70165_t, this.field_70163_u + 1.4, this.field_70161_v, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)entityToSpawn);
                    }
                    this.func_70634_a(this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 6.0, this.field_70163_u + 1.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 6.0);
                    this.consumeChakra(20.0);
                    this.lastInvisTime = this.field_70173_aa;
                    ret = false;
                }
                if (!ret) {
                    if (entity1 instanceof EntityLivingBase) {
                        this.func_70604_c((EntityLivingBase)entity1);
                    }
                    return false;
                }
            }
            return super.func_70097_a(source, amount);
        }

        @Override
        protected void func_70619_bc() {
            super.func_70619_bc();
            EntityLivingBase target = this.func_70638_az();
            if (target != null && target.func_70089_S()) {
                if (this.isSusanooActive()) {
                    this.susanooEntity.func_70624_b(target);
                }
                if (this.lookedAtTime >= 5 && this.field_70173_aa > this.lastGenjutsuTime + this.genjutsuDuration + 100 && this.consumeChakra(100.0)) {
                    if (target instanceof EntityPlayerMP) {
                        ProcedureSync.MobAppearanceParticle.send((EntityPlayerMP)target, 118);
                    }
                    this.field_70170_p.func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:genjutsu")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    if (!this.field_70170_p.field_72995_K) {
                        target.func_70690_d(new PotionEffect(PotionParalysis.potion, this.genjutsuDuration, 1, false, false));
                        target.func_70690_d(new PotionEffect(MobEffects.field_76431_k, this.genjutsuDuration + 40, 0, false, true));
                        target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60, 0, false, true));
                    }
                    this.lastGenjutsuTime = this.field_70173_aa;
                    this.lookedAtTime = 0;
                }
                this.lookedAtTime = this.equals(ProcedureUtils.objectEntityLookingAt((Entity)target, (double)24.0).field_72308_g) ? ++this.lookedAtTime : 0;
            } else if (this.peacefulTicks > 200) {
                target = null;
                this.func_70624_b(null);
            }
            if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == ItemAkatsukiRobe.helmet != (target == null)) {
                this.swapWithInventory(EntityEquipmentSlot.HEAD, 1);
            }
        }

        public void func_70030_z() {
            super.func_70030_z();
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)this);
            $_dependencies.put("world", this.field_70170_p);
            ProcedureBasicNinjaSkills.executeProcedure($_dependencies);
        }

        @Override
        public boolean func_70601_bi() {
            return super.func_70601_bi() && this.field_70170_p.func_72872_a(EntityCustom.class, this.func_174813_aQ().func_186662_g(128.0)).isEmpty();
        }

        public void func_184724_a(boolean swingingArms) {
        }

        public void func_82196_d(EntityLivingBase target, float distanceFactor) {
            int chance = this.field_70146_Z.nextInt(12);
            if (this.func_184187_bx() instanceof EntitySusanooClothed.EntityCustom) {
                ((EntitySusanooClothed.EntityCustom)this.func_184187_bx()).func_82196_d(target, distanceFactor);
            } else if (chance == 0 && distanceFactor > 0.3333f && this.consumeChakra(50.0)) {
                this.field_70170_p.func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:sharingansfx")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                target.func_70690_d(new PotionEffect(PotionAmaterasuFlame.potion, 1200, 3, false, false));
            } else if (chance <= 2 && distanceFactor >= 0.5333f && this.consumeChakra(50.0)) {
                double d0 = target.field_70165_t - this.field_70165_t;
                double d1 = target.field_70163_u - (this.field_70163_u + (double)this.func_70047_e());
                double d2 = target.field_70161_v - this.field_70161_v;
                new ItemKaton.EntityBigFireball.Jutsu().createJutsu((EntityLivingBase)this, d0, d1, d2, 5.0f);
            } else if (!this.func_184218_aH()) {
                ItemKunai.EntityArrowCustom kunai = new ItemKunai.EntityArrowCustom(this.field_70170_p, (EntityLivingBase)this);
                Vec3d vec = target.func_174824_e(1.0f).func_178788_d(kunai.func_174791_d());
                kunai.func_70186_c(vec.field_72450_a, vec.field_72448_b + (double)MathHelper.func_76133_a((double)(vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c)) * 0.2, vec.field_72449_c, 1.0f, 0.0f);
                kunai.func_70239_b(5.0);
                kunai.func_70240_a(1);
                this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.5f + 1.0f) + 0.25f);
                this.field_70170_p.func_72838_d((Entity)kunai);
            }
        }

        public void func_184178_b(EntityPlayerMP player) {
            super.func_184178_b(player);
            if (ModConfig.AGGRESSIVE_BOSSES) {
                this.func_70624_b((EntityLivingBase)player);
            }
        }

        public void func_184203_c(EntityPlayerMP player) {
            super.func_184203_c(player);
            if (this.bossInfo.func_186757_c().contains(player)) {
                this.bossInfo.func_186761_b(player);
            }
        }

        private void trackAttackedPlayers() {
            EntityLivingBase entity = this.func_94060_bK();
            if (entity instanceof EntityPlayerMP || (entity = ModConfig.AGGRESSIVE_BOSSES ? this.func_110144_aD() : this.func_70638_az()) instanceof EntityPlayerMP) {
                this.bossInfo.func_186760_a((EntityPlayerMP)entity);
            }
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            this.trackAttackedPlayers();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }

        @Override
        protected boolean canSeeInvisible(Entity entityIn) {
            return !entityIn.func_82150_aj() || this.func_70068_e(entityIn) <= 400.0;
        }

        @Override
        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            compound.func_74757_a("isReal", this.isReal);
        }

        @Override
        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            this.setIsReal(compound.func_74767_n("isReal"));
        }
    }
}

