/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityBijuManager;
import net.narutomod.entity.EntityClone;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.entity.EntityTailedBeast;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityJinchurikiClone
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 263;
    public static final int ENTITYID_RANGED = 264;

    public EntityJinchurikiClone(ElementsNarutomodMod instance) {
        super(instance, 586);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "jinchuriki_clone"), 263).name("jinchuriki_clone").tracker(64, 3, true).build());
    }

    public static class EntityCustom
    extends EntityClone.Base
    implements IRangedAttackMob {
        private int level;
        private Chakra.Pathway chakra;
        private int idleTime;

        public EntityCustom(World world) {
            super(world);
            this.shouldDefendSummoner = false;
        }

        public EntityCustom(EntityLivingBase user) {
            super(user);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(ProcedureUtils.getModifiedSpeed(user));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ProcedureUtils.getModifiedAttackDamage(user));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)user.func_110138_aP());
            this.shouldDefendSummoner = false;
            this.func_70624_b(user.func_110144_aD());
            this.level = user instanceof EntityPlayer ? EntityBijuManager.cloakLevel((EntityPlayer)user) : 1;
            this.chakra = Chakra.pathway((EntityLivingBase)this);
            Chakra.Pathway userChakra = Chakra.pathway(user);
            this.chakra.setMax(userChakra.getMax());
            this.chakra.consume(-userChakra.getAmount(), true);
            if (user instanceof EntityPlayerMP) {
                this.getEntityData().func_74768_a("OriginalGameMode", ((EntityPlayerMP)user).field_71134_c.func_73081_b().func_77148_a());
                ((EntityPlayerMP)user).func_71033_a(GameType.SPECTATOR);
            }
        }

        public int getLevel() {
            return this.level;
        }

        @Override
        protected void func_184651_r() {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(this, EntityLivingBase.class, false, false){

                protected AxisAlignedBB func_188511_a(double targetDistance) {
                    return this.func_174813_aQ().func_72314_b(targetDistance, 14.0, targetDistance);
                }
            });
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityNinjaMob.AILeapAtTarget((EntityLiving)this, 1.5f));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged(this, 1.0, 40, 80.0f){

                public boolean func_75250_a() {
                    return level == 2 && super.func_75250_a() && (double)this.func_70032_d((Entity)this.func_70638_az()) > 24.0;
                }
            });
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(this, 1.0, true){

                public boolean func_75250_a() {
                    return super.func_75250_a() && (double)this.func_70032_d((Entity)this.func_70638_az()) <= 24.0;
                }

                protected double func_179512_a(EntityLivingBase attackTarget) {
                    return (3.0 + (double)level) * (3.0 + (double)level);
                }
            });
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        }

        public void func_184724_a(boolean swingingArms) {
        }

        public void func_82196_d(EntityLivingBase target, float distanceFactor) {
            EntityTailedBeast.EntityTailBeastBall.spawn((EntityLivingBase)this, 2.0f, 150.0f);
        }

        @Override
        public void func_70106_y() {
            if (!this.field_70170_p.field_72995_K && this.getSummoner() instanceof EntityPlayerMP && !this.field_70128_L) {
                EntityPlayerMP user = (EntityPlayerMP)this.getSummoner();
                user.func_71033_a(GameType.func_77146_a((int)this.getEntityData().func_74762_e("OriginalGameMode")));
                user.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 2, 0, false, false));
                if (user.func_70089_S()) {
                    float f = this.func_110143_aJ();
                    user.func_70606_j(f);
                    if (f <= 0.0f) {
                        EntityBijuManager.toggleBijuCloak((EntityPlayer)user);
                    }
                }
            }
            super.func_70106_y();
        }

        @Override
        protected void func_70619_bc() {
            super.func_70619_bc();
            this.idleTime = this.func_70638_az() == null || !this.func_70638_az().func_70089_S() ? ++this.idleTime : 0;
            if (this.idleTime > 200) {
                this.func_70106_y();
                if (this.getSummoner() instanceof EntityPlayer) {
                    EntityBijuManager.toggleBijuCloak((EntityPlayer)this.getSummoner());
                }
            }
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K && this.getSummoner() instanceof EntityPlayerMP) {
                EntityPlayerMP user = (EntityPlayerMP)this.getSummoner();
                if (!user.func_70089_S()) {
                    user.func_175399_e((Entity)user);
                } else if (user.func_175398_C() != this) {
                    user.func_175399_e((Entity)this);
                }
                Chakra.PathwayPlayer userChakra = Chakra.pathway((EntityPlayer)user);
                userChakra.consume(userChakra.getAmount() - this.chakra.getAmount());
            }
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                ItemStack itemstack = this.func_184582_a(slot);
                if (itemstack.func_190926_b()) continue;
                itemstack.func_77945_a(this.field_70170_p, (Entity)this, slot.func_188452_c(), false);
            }
        }
    }
}

