/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityClone;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityKageBunshin
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 139;
    public static final int ENTITYID_RANGED = 140;
    public static final String OGCLONE_KEY = "I_am_clone_ogCloneIDKey";
    public static final PlayerEventHook playerEventHook = new PlayerEventHook();
    private static final Map<Integer, EC> UNLOADED_EC = Maps.newHashMap();

    public EntityKageBunshin(ElementsNarutomodMod instance) {
        super(instance, 388);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "kage_bunshin"), 139).name("kage_bunshin").tracker(64, 3, true).build());
    }

    public static boolean isPlayerClone(EntityPlayer player) {
        return EntityKageBunshin.getOriginalClone((EntityLivingBase)player) != null;
    }

    @Nullable
    private static EC getCloneByID(World world, int id) {
        Entity entity = world.func_73045_a(id);
        if (entity == null) {
            entity = (Entity)UNLOADED_EC.get(id);
        }
        if (!(entity instanceof EC)) {
            UNLOADED_EC.remove(id);
            return null;
        }
        return (EC)entity;
    }

    @Nullable
    public static EC getOriginalClone(EntityLivingBase player) {
        if (player.getEntityData().func_74764_b(OGCLONE_KEY)) {
            EC entity = EntityKageBunshin.getCloneByID(player.field_70170_p, player.getEntityData().func_74762_e(OGCLONE_KEY));
            if (entity != null && entity.func_70089_S()) {
                return entity;
            }
            player.getEntityData().func_82580_o(OGCLONE_KEY);
        }
        return null;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)playerEventHook);
    }

    public static class PlayerEventHook {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onDeath(LivingDeathEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            if (entity instanceof EntityPlayer) {
                if (EntityKageBunshin.isPlayerClone((EntityPlayer)entity)) {
                    event.setCanceled(true);
                    this.revertClone(entity);
                } else if (EC.Jutsu.hasClones(entity)) {
                    EC.Jutsu.removeAllClones(entity);
                }
            }
        }

        @SubscribeEvent
        public void onPlayerChangeDimension(EntityTravelToDimensionEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof EntityPlayer) {
                if (EntityKageBunshin.isPlayerClone((EntityPlayer)entity)) {
                    event.setCanceled(true);
                    ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString("You are a clone, you can't travel to another dimension."), false);
                } else if (EC.Jutsu.hasClones((EntityLivingBase)((EntityPlayer)entity))) {
                    EC.Jutsu.removeAllClones((EntityLivingBase)((EntityPlayer)entity));
                }
            }
        }

        @SubscribeEvent
        public void onPlayerSleep(PlayerSleepInBedEvent event) {
            EntityPlayer entity = event.getEntityPlayer();
            if (!entity.field_70170_p.field_72995_K && EntityKageBunshin.isPlayerClone(entity)) {
                event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                entity.func_146105_b((ITextComponent)new TextComponentString("You are a clone, you can't sleep."), false);
            }
        }

        private void revertClone(EntityLivingBase entity) {
            EC clone = EntityKageBunshin.getOriginalClone(entity);
            if (clone != null) {
                clone.func_70106_y();
                entity.field_70128_L = false;
                if (entity.getEntityData().func_74764_b("HealthB4Kill")) {
                    entity.func_70606_j(entity.func_110143_aJ() + entity.getEntityData().func_74760_g("HealthB4Kill"));
                    entity.getEntityData().func_82580_o("HealthB4Kill");
                }
                entity.func_70674_bp();
                entity.getEntityData().func_74768_a("ForceExtinguish", 3);
            }
        }

        @SubscribeEvent
        public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
            if (EntityKageBunshin.isPlayerClone(event.player)) {
                event.player.field_70128_L = true;
                this.revertClone((EntityLivingBase)event.player);
            }
            if (EC.Jutsu.hasClones((EntityLivingBase)event.player)) {
                EC.Jutsu.removeAllClones((EntityLivingBase)event.player);
            }
        }

        @SubscribeEvent
        public void onServerDisconnect(FMLNetworkEvent.ServerDisconnectionFromClientEvent event) {
            EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
            if (EntityKageBunshin.isPlayerClone((EntityPlayer)player)) {
                player.field_70128_L = true;
                this.revertClone((EntityLivingBase)player);
            }
            if (EC.Jutsu.hasClones((EntityLivingBase)player)) {
                EC.Jutsu.removeAllClones((EntityLivingBase)player);
            }
        }
    }

    public static class EC
    extends EntityClone.Base {
        private boolean isOriginal;
        private DamageSource deathCause;

        public EC(World world) {
            super(world);
            this.field_70138_W = 16.0f;
            this.field_70765_h = new EntityNinjaMob.MoveHelper(this);
        }

        public EC(EntityLivingBase user) {
            super(user);
            this.field_70138_W = 16.0f;
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("bunshin.followRange", 32.0, 0));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(ProcedureUtils.getModifiedSpeed(user) * 4.0);
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(user.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e());
            this.field_70765_h = new EntityNinjaMob.MoveHelper(this);
        }

        @Nullable
        private EC getOriginal() {
            EntityLivingBase summoner = this.getSummoner();
            if (summoner != null) {
                return EntityKageBunshin.getOriginalClone(summoner);
            }
            return null;
        }

        @Override
        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityClone.AIFollowSummoner((EntityLiving)this, 0.8, 4.0f){

                @Override
                public boolean func_75250_a() {
                    return super.func_75250_a() && !isOriginal;
                }
            });
        }

        public boolean func_184645_a(EntityPlayer entity, EnumHand hand) {
            if (entity.equals((Object)this.getSummoner())) {
                if (this.isOriginal) {
                    this.cancelCloneControl();
                    if (!this.field_70170_p.field_72995_K) {
                        entity.func_146105_b((ITextComponent)new TextComponentString("You are now the original"), false);
                    }
                    return true;
                }
                if (this.getOriginal() != null) {
                    return false;
                }
                this.controlClone();
                if (!this.field_70170_p.field_72995_K) {
                    entity.func_146105_b((ITextComponent)new TextComponentString("You are now clone(" + this.func_145782_y() + ")"), false);
                }
                return true;
            }
            return super.func_184645_a(entity, hand);
        }

        private void poof(Entity entity) {
            ProcedureUtils.poofWithSmoke(entity);
        }

        @Override
        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                EntityLivingBase summoner = this.getSummoner();
                boolean flag = false;
                boolean flag2 = false;
                if (this.isOriginal) {
                    this.poof((Entity)summoner);
                    summoner.field_70177_z = this.field_70177_z;
                    summoner.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    if (summoner.func_70089_S()) {
                        this.cancelCloneControl();
                        summoner.func_70097_a(this.deathCause != null ? this.deathCause : DamageSource.field_76377_j, Float.MAX_VALUE);
                    } else {
                        flag = true;
                        flag2 = true;
                    }
                } else {
                    this.poof((Entity)this);
                    flag = true;
                }
                if (flag && summoner != null) {
                    Jutsu.updateClones(summoner, false);
                    Chakra.pathway(summoner).consume(-Chakra.pathway((EntityLivingBase)this).getAmount() * 0.9, false);
                    if (summoner.func_110143_aJ() > 0.0f || flag2) {
                        summoner.func_70606_j(summoner.func_110143_aJ() + this.func_110143_aJ() * 0.9f);
                    }
                }
            }
        }

        private void controlClone() {
            this.isOriginal = true;
            this.shouldDefendSummoner = false;
            this.getSummoner().getEntityData().func_74768_a(EntityKageBunshin.OGCLONE_KEY, this.func_145782_y());
        }

        private void cancelCloneControl() {
            this.getSummoner().getEntityData().func_82580_o(EntityKageBunshin.OGCLONE_KEY);
            this.isOriginal = false;
            this.shouldDefendSummoner = true;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76364_f() instanceof EntityLivingBase && source.func_76364_f().equals((Object)this.getSummoner())) {
                if (this.isOriginal) {
                    this.cancelCloneControl();
                }
                this.func_70106_y();
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        protected void func_70609_aI() {
            if (++this.field_70725_aQ == 20) {
                this.func_70106_y();
            }
        }

        public void func_70645_a(DamageSource cause) {
            super.func_70645_a(cause);
            this.deathCause = cause;
        }

        public void onAddedToWorld() {
            super.onAddedToWorld();
            if (!this.field_70170_p.field_72995_K) {
                UNLOADED_EC.remove(this.func_145782_y());
            }
        }

        public void onRemovedFromWorld() {
            super.onRemovedFromWorld();
            if (!this.field_70170_p.field_72995_K) {
                int i = this.func_145782_y();
                if (!this.field_70128_L) {
                    if (!UNLOADED_EC.containsKey(i)) {
                        UNLOADED_EC.put(i, this);
                    }
                } else {
                    UNLOADED_EC.remove(i);
                }
            }
        }

        protected float func_189749_co() {
            return 1.0f;
        }

        protected void func_82168_bl() {
            super.func_82168_bl();
            for (ItemStack stack : this.func_184214_aD()) {
                if (stack.func_190926_b()) continue;
                stack.func_77945_a(this.field_70170_p, (Entity)this, 0, false);
            }
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 15) {
                ItemStack stack = this.func_184614_ca();
                if (stack.func_77973_b() instanceof ItemJutsu.Base) {
                    for (ItemJutsu.JutsuEnum je : ((ItemJutsu.Base)stack.func_77973_b()).getActivatedJutsus(stack)) {
                        je.jutsu.createJutsu(stack, (EntityLivingBase)this, je.jutsu.getPower(stack));
                    }
                }
                if ((stack = this.func_184592_cb()).func_77973_b() instanceof ItemJutsu.Base) {
                    for (ItemJutsu.JutsuEnum je : ((ItemJutsu.Base)stack.func_77973_b()).getActivatedJutsus(stack)) {
                        je.jutsu.createJutsu(stack, (EntityLivingBase)this, je.jutsu.getPower(stack));
                    }
                }
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ID_KEY = "KageBunshinEntityId";
            private static final UUID MAXHEALTH = UUID.fromString("308fe1ce-1850-4b1a-803c-ed265df4e3ce");

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (entity instanceof EntityPlayer && entity.func_70093_af()) {
                    if (EntityKageBunshin.isPlayerClone((EntityPlayer)entity)) {
                        entity.getEntityData().func_74776_a("HealthB4Kill", entity.func_110143_aJ());
                        entity.func_174812_G();
                    } else {
                        Jutsu.removeAllClones(entity);
                    }
                    return false;
                }
                if (!(entity instanceof EntityPlayer) || Chakra.pathway((EntityPlayer)entity).getAmount() >= 200.0) {
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:kagebunshin")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    Jutsu.updateClones(entity, true);
                    return true;
                }
                return false;
            }

            private static int updateClones(EntityLivingBase entity, boolean add1) {
                ArrayList clones = Lists.newArrayList();
                int[] ids = entity.getEntityData().func_74759_k(ID_KEY);
                for (int i = 0; i < ids.length; ++i) {
                    EC ec = EntityKageBunshin.getCloneByID(entity.field_70170_p, ids[i]);
                    if (ec == null || !ec.func_70089_S()) continue;
                    clones.add(ids[i]);
                }
                if (add1) {
                    EC newClone = new EC(entity);
                    newClone.func_70107_b(newClone.field_70165_t + (entity.func_70681_au().nextBoolean() ? -0.1 : 0.1), newClone.field_70163_u, newClone.field_70161_v + (entity.func_70681_au().nextBoolean() ? -0.1 : 0.1));
                    entity.field_70170_p.func_72838_d((Entity)newClone);
                    clones.add(newClone.func_145782_y());
                    Chakra.Pathway chakra = Chakra.pathway(entity);
                    double d = chakra.getAmount() / (double)(clones.size() + 1);
                    chakra.consume(d);
                    Chakra.pathway((EntityLivingBase)newClone).setMax(d).consume(-d);
                }
                entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_188479_b(MAXHEALTH);
                if (clones.size() > 0) {
                    entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(MAXHEALTH, "maxhealth.modifier", (double)(entity.func_110143_aJ() * (float)(clones.size() + (add1 ? 0 : 2)) / (float)(clones.size() + 1) - entity.func_110138_aP()), 0));
                }
                if (entity.func_110143_aJ() > entity.func_110138_aP()) {
                    entity.func_70606_j(entity.func_110138_aP());
                }
                if (add1) {
                    for (Integer i : clones) {
                        EC e = EntityKageBunshin.getCloneByID(entity.field_70170_p, i);
                        e.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)entity.func_110143_aJ());
                        if (e.field_70173_aa >= 2 && !(e.func_110143_aJ() > e.func_110138_aP())) continue;
                        e.func_70606_j(e.func_110138_aP());
                    }
                }
                if (clones.isEmpty()) {
                    entity.getEntityData().func_82580_o(ID_KEY);
                } else {
                    entity.getEntityData().func_74783_a(ID_KEY, Ints.toArray((Collection)clones));
                }
                return clones.size();
            }

            private static boolean hasClones(EntityLivingBase entity) {
                return entity.getEntityData().func_74764_b(ID_KEY);
            }

            private static void removeAllClones(EntityLivingBase entity) {
                ArrayList clones = Lists.newArrayList();
                int[] ids = entity.getEntityData().func_74759_k(ID_KEY);
                for (int i = 0; i < ids.length; ++i) {
                    EC e = EntityKageBunshin.getCloneByID(entity.field_70170_p, ids[i]);
                    if (e == null || !e.func_70089_S()) continue;
                    clones.add(e);
                }
                for (EC e : clones) {
                    e.func_70106_y();
                }
                entity.getEntityData().func_82580_o(ID_KEY);
            }
        }
    }
}

