/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import java.util.HashMap;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.item.ItemRinnegan;
import net.narutomod.procedure.ProcedureKingOfHellEntityOnEntityTickUpdate;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityKingOfHell
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 38;
    public static final int ENTITYID_RANGED = 39;

    public EntityKingOfHell(ElementsNarutomodMod instance) {
        super(instance, 221);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "kingofhellentity"), 38).name("kingofhellentity").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderLiving(renderManager, new ModelKingofhell(), 4.8f){

            protected ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("narutomod:textures/kingofhell.png");
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelKingofhell
    extends ModelBase {
        private final ModelRenderer head;
        private final ModelRenderer bone3;
        private final ModelRenderer mask_right;
        private final ModelRenderer bone4;
        private final ModelRenderer mask_left;
        private final ModelRenderer crown;
        private final ModelRenderer bone5;
        private final ModelRenderer bone6;
        private final ModelRenderer bone7;
        private final ModelRenderer bone8;
        private final ModelRenderer bone10;
        private final ModelRenderer bone11;
        private final ModelRenderer bone12;
        private final ModelRenderer bone13;
        private final ModelRenderer collarOuter;
        private final ModelRenderer bone15;
        private final ModelRenderer bone16;
        private final ModelRenderer bone9;
        private final ModelRenderer bone17;
        private final ModelRenderer collarInner;
        private final ModelRenderer bone19;
        private final ModelRenderer bone20;
        private final ModelRenderer bone21;
        private final ModelRenderer bone22;

        public ModelKingofhell() {
            this.field_78090_t = 144;
            this.field_78089_u = 144;
            this.head = new ModelRenderer((ModelBase)this);
            this.head.func_78793_a(0.0f, 24.0f, 0.0f);
            this.head.field_78804_l.add(new ModelBox(this.head, 0, 0, -8.0f, -24.0f, -8.0f, 16, 24, 16, 0.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 39, 117, -2.5f, -28.5f, -2.5f, 5, 5, 5, 0.0f, false));
            this.bone3 = new ModelRenderer((ModelBase)this);
            this.bone3.func_78793_a(-8.0f, 4.0f, -8.0f);
            this.head.func_78792_a(this.bone3);
            this.bone3.field_78804_l.add(new ModelBox(this.bone3, 81, 101, -0.1f, -15.0f, -0.1f, 0, 19, 16, 0.0f, false));
            this.mask_right = new ModelRenderer((ModelBase)this);
            this.mask_right.func_78793_a(-0.1f, 0.0f, 0.0f);
            this.bone3.func_78792_a(this.mask_right);
            this.setRotationAngle(this.mask_right, 0.0f, 0.0873f, 0.0f);
            this.mask_right.field_78804_l.add(new ModelBox(this.mask_right, 64, 16, 0.0f, -15.0f, 0.0f, 8, 19, 0, 0.0f, false));
            this.bone4 = new ModelRenderer((ModelBase)this);
            this.bone4.func_78793_a(8.0f, 4.0f, -8.0f);
            this.head.func_78792_a(this.bone4);
            this.bone4.field_78804_l.add(new ModelBox(this.bone4, 64, 0, 0.1f, -15.0f, -0.1f, 0, 19, 16, 0.0f, true));
            this.mask_left = new ModelRenderer((ModelBase)this);
            this.mask_left.func_78793_a(0.1f, 0.0f, 0.0f);
            this.bone4.func_78792_a(this.mask_left);
            this.setRotationAngle(this.mask_left, 0.0f, -0.0873f, 0.0f);
            this.mask_left.field_78804_l.add(new ModelBox(this.mask_left, 64, 16, -8.0f, -15.0f, 0.0f, 8, 19, 0, 0.0f, true));
            this.crown = new ModelRenderer((ModelBase)this);
            this.crown.func_78793_a(0.0f, 5.0f, 0.0f);
            this.crown.field_78804_l.add(new ModelBox(this.crown, 72, 38, -9.0f, -9.0f, -9.0f, 18, 12, 18, 0.0f, false));
            this.bone5 = new ModelRenderer((ModelBase)this);
            this.bone5.func_78793_a(-5.0f, 2.0f, -8.5f);
            this.crown.func_78792_a(this.bone5);
            this.setRotationAngle(this.bone5, 0.0f, -0.4363f, 0.0f);
            this.bone5.field_78804_l.add(new ModelBox(this.bone5, 127, 28, -0.5f, -8.0f, -0.5f, 1, 8, 0, 0.0f, false));
            this.bone6 = new ModelRenderer((ModelBase)this);
            this.bone6.func_78793_a(0.0f, -7.0f, 0.0f);
            this.bone5.func_78792_a(this.bone6);
            this.setRotationAngle(this.bone6, -0.7854f, 0.0f, 0.0f);
            this.bone6.field_78804_l.add(new ModelBox(this.bone6, 127, 25, -0.5845f, -8.2961f, -1.0524f, 1, 8, 0, 0.0f, false));
            this.bone7 = new ModelRenderer((ModelBase)this);
            this.bone7.func_78793_a(0.0f, -7.0f, 0.0f);
            this.bone6.func_78792_a(this.bone7);
            this.setRotationAngle(this.bone7, -0.7854f, 0.0f, 0.0f);
            this.bone7.field_78804_l.add(new ModelBox(this.bone7, 127, 25, -0.5f, -8.0f, -1.6f, 1, 8, 0, 0.0f, false));
            this.bone8 = new ModelRenderer((ModelBase)this);
            this.bone8.func_78793_a(0.0f, -8.0f, -0.2f);
            this.bone7.func_78792_a(this.bone8);
            this.setRotationAngle(this.bone8, -0.5236f, 0.0f, 0.0f);
            this.bone8.field_78804_l.add(new ModelBox(this.bone8, 127, 25, -0.5f, -7.2929f, -1.2071f, 1, 8, 0, 0.0f, false));
            this.bone8.field_78804_l.add(new ModelBox(this.bone8, 127, 25, -0.5f, -14.364f, -1.2071f, 1, 8, 0, 0.0f, false));
            this.bone10 = new ModelRenderer((ModelBase)this);
            this.bone10.func_78793_a(4.75f, 2.0f, -8.5f);
            this.crown.func_78792_a(this.bone10);
            this.setRotationAngle(this.bone10, 0.0f, 0.4363f, 0.0f);
            this.bone10.field_78804_l.add(new ModelBox(this.bone10, 127, 28, -0.5f, -8.0f, -0.5f, 1, 8, 0, 0.0f, true));
            this.bone11 = new ModelRenderer((ModelBase)this);
            this.bone11.func_78793_a(0.0f, -7.0f, 0.0f);
            this.bone10.func_78792_a(this.bone11);
            this.setRotationAngle(this.bone11, -0.7854f, 0.0f, 0.0f);
            this.bone11.field_78804_l.add(new ModelBox(this.bone11, 127, 25, -0.4155f, -8.2961f, -1.0524f, 1, 8, 0, 0.0f, true));
            this.bone12 = new ModelRenderer((ModelBase)this);
            this.bone12.func_78793_a(0.0f, -7.0f, 0.0f);
            this.bone11.func_78792_a(this.bone12);
            this.setRotationAngle(this.bone12, -0.7854f, 0.0f, 0.0f);
            this.bone12.field_78804_l.add(new ModelBox(this.bone12, 127, 25, -0.5f, -8.0f, -1.6f, 1, 8, 0, 0.0f, true));
            this.bone13 = new ModelRenderer((ModelBase)this);
            this.bone13.func_78793_a(0.0f, -8.0f, -0.2f);
            this.bone12.func_78792_a(this.bone13);
            this.setRotationAngle(this.bone13, -0.5236f, 0.0f, 0.0f);
            this.bone13.field_78804_l.add(new ModelBox(this.bone13, 127, 25, -0.5f, -7.2929f, -1.2071f, 1, 8, 0, 0.0f, true));
            this.bone13.field_78804_l.add(new ModelBox(this.bone13, 127, 25, -0.5f, -14.364f, -1.2071f, 1, 8, 0, 0.0f, true));
            this.collarOuter = new ModelRenderer((ModelBase)this);
            this.collarOuter.func_78793_a(0.0f, 25.0f, 11.1f);
            this.setRotationAngle(this.collarOuter, -0.4363f, 0.0f, 0.0f);
            this.collarOuter.field_78804_l.add(new ModelBox(this.collarOuter, 0, 40, -4.0f, -21.0f, 0.0f, 8, 28, 0, 0.0f, false));
            this.bone15 = new ModelRenderer((ModelBase)this);
            this.bone15.func_78793_a(-4.0f, 0.0f, 0.0f);
            this.collarOuter.func_78792_a(this.bone15);
            this.setRotationAngle(this.bone15, 0.0f, -0.6981f, 0.0f);
            this.bone15.field_78804_l.add(new ModelBox(this.bone15, 16, 40, -8.0f, -21.0f, 0.0f, 8, 30, 0, 0.0f, false));
            this.bone16 = new ModelRenderer((ModelBase)this);
            this.bone16.func_78793_a(-8.0f, 0.0f, 0.0f);
            this.bone15.func_78792_a(this.bone16);
            this.setRotationAngle(this.bone16, 0.0f, -0.5236f, 0.0f);
            this.bone16.field_78804_l.add(new ModelBox(this.bone16, 32, 40, -12.0f, -21.0f, 0.0f, 12, 32, 0, 0.0f, false));
            this.bone9 = new ModelRenderer((ModelBase)this);
            this.bone9.func_78793_a(4.0f, 0.0f, 0.0f);
            this.collarOuter.func_78792_a(this.bone9);
            this.setRotationAngle(this.bone9, 0.0f, 0.6981f, 0.0f);
            this.bone9.field_78804_l.add(new ModelBox(this.bone9, 16, 40, 0.0f, -21.0f, 0.0f, 8, 30, 0, 0.0f, true));
            this.bone17 = new ModelRenderer((ModelBase)this);
            this.bone17.func_78793_a(8.0f, 0.0f, 0.0f);
            this.bone9.func_78792_a(this.bone17);
            this.setRotationAngle(this.bone17, 0.0f, 0.5236f, 0.0f);
            this.bone17.field_78804_l.add(new ModelBox(this.bone17, 32, 40, 0.0f, -21.0f, 0.0f, 12, 32, 0, 0.0f, true));
            this.collarInner = new ModelRenderer((ModelBase)this);
            this.collarInner.func_78793_a(0.0f, 25.0f, 11.0f);
            this.setRotationAngle(this.collarInner, -0.4363f, 0.0f, 0.0f);
            this.collarInner.field_78804_l.add(new ModelBox(this.collarInner, 0, 72, -4.0f, -21.0f, 0.0f, 8, 28, 0, 0.0f, false));
            this.bone19 = new ModelRenderer((ModelBase)this);
            this.bone19.func_78793_a(-4.0f, 0.0f, 0.0f);
            this.collarInner.func_78792_a(this.bone19);
            this.setRotationAngle(this.bone19, 0.0f, -0.6981f, 0.0f);
            this.bone19.field_78804_l.add(new ModelBox(this.bone19, 16, 72, -8.0f, -21.0f, 0.0f, 8, 30, 0, 0.0f, false));
            this.bone20 = new ModelRenderer((ModelBase)this);
            this.bone20.func_78793_a(-8.0f, 0.0f, 0.0f);
            this.bone19.func_78792_a(this.bone20);
            this.setRotationAngle(this.bone20, 0.0f, -0.5236f, 0.0f);
            this.bone20.field_78804_l.add(new ModelBox(this.bone20, 32, 72, -12.0f, -21.0f, 0.0f, 12, 32, 0, 0.0f, false));
            this.bone21 = new ModelRenderer((ModelBase)this);
            this.bone21.func_78793_a(4.0f, 0.0f, 0.0f);
            this.collarInner.func_78792_a(this.bone21);
            this.setRotationAngle(this.bone21, 0.0f, 0.6981f, 0.0f);
            this.bone21.field_78804_l.add(new ModelBox(this.bone21, 16, 72, 0.0f, -21.0f, 0.0f, 8, 30, 0, 0.0f, true));
            this.bone22 = new ModelRenderer((ModelBase)this);
            this.bone22.func_78793_a(8.0f, 0.0f, 0.0f);
            this.bone21.func_78792_a(this.bone22);
            this.setRotationAngle(this.bone22, 0.0f, 0.5236f, 0.0f);
            this.bone22.field_78804_l.add(new ModelBox(this.bone22, 32, 72, 0.0f, -21.0f, 0.0f, 12, 32, 0, 0.0f, true));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            float scale;
            this.func_78087_a(f, f1, f2, f3, f4, f5, entity);
            int popoutend = 60;
            float translate = scale = 3.0f;
            GlStateManager.func_179094_E();
            if (((EntityCustom)entity).getAge() <= popoutend) {
                translate = (float)((EntityCustom)entity).getAge() / (float)popoutend * scale;
            } else if (((EntityCustom)entity).deathTicks > 0) {
                translate = (1.0f - (float)((EntityCustom)entity).deathTicks / (float)popoutend) * scale;
            }
            GlStateManager.func_179109_b((float)0.0f, (float)(1.5f - 1.5f * translate), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.head.func_78785_a(f5);
            this.crown.func_78785_a(f5);
            this.collarOuter.func_78785_a(f5);
            this.collarInner.func_78785_a(f5);
            GlStateManager.func_179121_F();
        }

        public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
            this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            this.crown.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            this.collarOuter.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            this.collarInner.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            if (this.field_78095_p > 0.0f) {
                this.mask_right.field_78796_g = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI)) * 2.0f;
                this.mask_left.field_78796_g = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI)) * -2.0f;
            }
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }
    }

    public static class EntityCustom
    extends EntityCreature {
        private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187192_b);
        protected EntityPlayer summoningPlayer;
        private EntityPlayer healingPlayer;
        private int deathTicks;
        private double chakraUsage = Double.MAX_VALUE;

        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(5.0f, 4.8f);
            this.field_70728_aV = 0;
            this.field_70178_ae = true;
            this.field_70733_aJ = 0.0f;
            this.field_110158_av = 0;
            this.func_94061_f(true);
            this.func_110163_bv();
        }

        public EntityCustom(EntityPlayer player) {
            this(player.field_70170_p);
            this.summoningPlayer = player;
            RayTraceResult res = ProcedureUtils.raytraceBlocks((Entity)player, 4.0);
            double x = res.func_178782_a().func_177958_n();
            double z = res.func_178782_a().func_177952_p();
            this.func_70107_b(x + 0.5, player.field_70163_u, z + 0.5);
            this.field_70177_z = this.field_70759_as = player.field_70177_z - 180.0f;
            this.chakraUsage = ItemRinnegan.getNarakaPathChakraUsage((EntityLivingBase)player);
        }

        protected void func_70088_a() {
            super.func_70088_a();
            this.func_184212_Q().func_187214_a(AGE, (Object)0);
        }

        public int getAge() {
            return (Integer)this.func_184212_Q().func_187225_a(AGE);
        }

        protected void setAge(int age) {
            this.func_184212_Q().func_187227_b(AGE, (Object)age);
        }

        public EnumCreatureAttribute func_70668_bt() {
            return EnumCreatureAttribute.UNDEFINED;
        }

        protected boolean func_70692_ba() {
            return false;
        }

        protected Item func_146068_u() {
            return null;
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(""));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(""));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(""));
        }

        protected float func_70599_aP() {
            return 1.0f;
        }

        public void func_174812_G() {
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            return false;
        }

        public boolean func_184645_a(EntityPlayer entity, EnumHand hand) {
            if (this.healingPlayer == null && this.summoningPlayer != null && (entity.equals((Object)this.summoningPlayer) || this.summoningPlayer.func_184191_r((Entity)entity))) {
                this.healingPlayer = entity;
                this.toggleArmSwing();
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:KoH_spawn")), 1.0f, 1.0f);
                return true;
            }
            return super.func_184645_a(entity, hand);
        }

        private int getArmSwingAnimationEnd() {
            return 20;
        }

        public void func_184609_a(EnumHand hand) {
            if (!this.field_82175_bq) {
                this.field_82175_bq = true;
                if (this.field_70170_p instanceof WorldServer) {
                    ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, (Packet)new SPacketAnimation((Entity)this, 0));
                }
            }
        }

        private void toggleArmSwing() {
            this.func_184609_a(EnumHand.MAIN_HAND);
        }

        protected void func_82168_bl() {
            int i = this.getArmSwingAnimationEnd();
            if (this.field_82175_bq) {
                ++this.field_110158_av;
                if (this.field_110158_av == i / 2) {
                    this.field_82175_bq = false;
                }
                if (this.field_110158_av >= i) {
                    this.field_110158_av = 0;
                    this.field_82175_bq = false;
                }
            }
            this.field_70732_aI = this.field_70733_aJ;
            this.field_70733_aJ = (float)this.field_110158_av / (float)i;
        }

        private boolean isArmsOpen() {
            return !this.field_82175_bq && this.field_110158_av == this.getArmSwingAnimationEnd() / 2;
        }

        private void rejuvenatePlayer() {
            if (this.healingPlayer != null) {
                if (this.healingPlayer.func_184220_m((Entity)this)) {
                    this.field_70170_p.func_72960_a((Entity)this.healingPlayer, (byte)35);
                    this.healingPlayer.func_70674_bp();
                    this.healingPlayer.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 160, 4));
                }
                this.healingPlayer.func_70691_i(0.2f);
                this.healingPlayer.func_70095_a(false);
                if (this.healingPlayer.func_110143_aJ() >= this.healingPlayer.func_110138_aP()) {
                    this.healingPlayer.func_184210_p();
                    this.healingPlayer = null;
                }
            }
        }

        private void rejuvenateSummoningPlayer() {
            if (!this.field_82175_bq && this.field_110158_av == 0) {
                this.healingPlayer = this.summoningPlayer;
                this.toggleArmSwing();
            }
        }

        public void func_70030_z() {
            this.setAge(this.getAge() + 1);
            this.func_82168_bl();
            if (!this.field_70170_p.field_72995_K) {
                if (this.isArmsOpen()) {
                    if (this.healingPlayer != null) {
                        this.rejuvenatePlayer();
                    } else {
                        this.toggleArmSwing();
                    }
                }
                if (this.summoningPlayer != null) {
                    if (this.summoningPlayer.func_110143_aJ() <= 0.0f) {
                        this.func_70606_j(0.0f);
                    } else if (this.summoningPlayer.func_110143_aJ() < 4.0f) {
                        this.rejuvenateSummoningPlayer();
                    }
                }
            }
            super.func_70030_z();
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)this);
            $_dependencies.put("world", this.field_70170_p);
            ProcedureKingOfHellEntityOnEntityTickUpdate.executeProcedure($_dependencies);
            if (!this.field_70170_p.field_72995_K && (this.summoningPlayer == null || this.field_70173_aa % 20 == 0 && !Chakra.pathway(this.summoningPlayer).consume(this.chakraUsage))) {
                this.func_70606_j(0.0f);
            }
        }

        protected void func_70609_aI() {
            ++this.deathTicks;
            if (this.deathTicks == 1) {
                this.healingPlayer = null;
            }
            if (this.deathTicks > 60 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(100.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1024.0);
        }

        public double func_70042_X() {
            return 0.2;
        }

        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            compound.func_74768_a("age", this.getAge());
        }

        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            this.setAge(compound.func_74762_e("age"));
        }
    }
}

