/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityLightningArc;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemRanton;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityLaserCircus
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 279;
    public static final int ENTITYID_RANGED = 280;
    private static final String LCTAG = "LaserCircusRingEntityId";

    public EntityLaserCircus(ElementsNarutomodMod instance) {
        super(instance, 598);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "laser_circus"), 279).name("laser_circus").tracker(64, 3, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityRing.class).id(new ResourceLocation("narutomod", "laser_ring"), 280).name("laser_ring").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityRing.class, renderManager -> new RenderRing(renderManager));
    }

    public static boolean ringSpawned(World world, ItemStack stack) {
        return stack.func_77942_o() && world.func_73045_a(stack.func_77978_p().func_74762_e(LCTAG)) instanceof EntityRing;
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderRing
    extends Render<EntityRing> {
        private final ResourceLocation TEXTURE;

        public RenderRing(RenderManager renderManager) {
            super(renderManager);
            this.TEXTURE = new ResourceLocation("narutomod:textures/ring_lightning.png");
            this.field_76989_e = 0.1f;
        }

        public void doRender(EntityRing entity, double x, double y, double z, float entityYaw, float partialTicks) {
            this.func_180548_c(entity);
            GlStateManager.func_179094_E();
            float ageInTicks = (float)entity.field_70173_aa + partialTicks;
            float scale = (1.0f - ageInTicks % 5.0f / 5.0f) * 3.0f;
            GlStateManager.func_179137_b((double)x, (double)(y + 0.5), (double)z);
            GlStateManager.func_179091_B();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179114_b((float)(-entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(9.0f * ageInTicks), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            int alpha = (int)(255.0f * Math.min(ageInTicks / 30.0f, 1.0f));
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            bufferbuilder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
            GlStateManager.func_179089_o();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(EntityRing entity) {
            return this.TEXTURE;
        }
    }

    public static class EntityRing
    extends Entity {
        private static final DataParameter<Integer> USERID = EntityDataManager.func_187226_a(EntityRing.class, (DataSerializer)DataSerializers.field_187192_b);

        public EntityRing(World worldIn) {
            super(worldIn);
            this.func_70105_a(1.0f, 1.0f);
        }

        public EntityRing(EntityLivingBase userIn, ItemStack stack) {
            this(userIn.field_70170_p);
            this.func_70105_a(1.0f, 1.0f);
            this.setUser(userIn);
            this.setIdlePosition();
            stack.func_77978_p().func_74768_a(EntityLaserCircus.LCTAG, this.func_145782_y());
            this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:lasercircus")), 1.0f, 1.0f);
        }

        protected void func_70088_a() {
            this.func_184212_Q().func_187214_a(USERID, (Object)-1);
        }

        private void setUser(EntityLivingBase user) {
            this.func_184212_Q().func_187227_b(USERID, (Object)user.func_145782_y());
        }

        protected EntityLivingBase getUser() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(USERID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        private void setIdlePosition() {
            EntityLivingBase user = this.getUser();
            if (user != null) {
                Vec3d vec = user.func_70040_Z();
                vec = user.func_174791_d().func_72441_c(vec.field_72450_a, 0.6, vec.field_72449_c);
                this.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, user.field_70177_z, 0.0f);
            }
        }

        public void func_70071_h_() {
            if (this.getUser() != null) {
                this.setIdlePosition();
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }
    }

    public static class EC
    extends Entity {
        private EntityLivingBase summoner;
        private int duration;
        private ItemStack rantonstack;

        public EC(World a) {
            super(a);
            this.func_70105_a(0.01f, 0.01f);
        }

        protected EC(EntityLivingBase summonerIn, float powerIn, ItemStack stack) {
            this(summonerIn.field_70170_p);
            this.func_70105_a(0.01f, 0.01f);
            this.summoner = summonerIn;
            this.duration = (int)(powerIn * 20.0f);
            this.rantonstack = stack;
            this.setIdlePosition();
        }

        protected void func_70088_a() {
        }

        private void setIdlePosition() {
            if (this.summoner != null) {
                Vec3d vec = this.summoner.func_70040_Z();
                vec = this.summoner.func_174791_d().func_72441_c(vec.field_72450_a, 1.2, vec.field_72449_c);
                this.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
        }

        public void func_70071_h_() {
            if (this.summoner != null && this.summoner.func_70089_S() && this.field_70173_aa <= this.duration) {
                RayTraceResult res;
                this.setIdlePosition();
                if (this.field_70173_aa % 10 == 0) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:electricity")), 1.0f, this.field_70146_Z.nextFloat() * 0.6f + 0.6f);
                }
                if ((res = ProcedureUtils.objectEntityLookingAt((Entity)this.summoner, 25.0)) != null) {
                    this.setLightningAt(res.field_72307_f);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                Entity entity;
                this.func_70106_y();
                if (this.rantonstack != null && (entity = this.field_70170_p.func_73045_a(this.rantonstack.func_77978_p().func_74762_e(EntityLaserCircus.LCTAG))) instanceof EntityRing) {
                    entity.func_70106_y();
                }
            }
        }

        private void setLightningAt(Vec3d targetVec) {
            EntityLightningArc.Base entity2 = new EntityLightningArc.Base(this.field_70170_p, this.func_174791_d(), targetVec, -1073741569, 10, 0.1f);
            entity2.setDamage(ItemJutsu.causeJutsuDamage(this, this.summoner), this.getDamage(), this.summoner);
            this.field_70170_p.func_72838_d((Entity)entity2);
        }

        private float getDamage() {
            float f = Math.max(((ItemJutsu.Base)this.rantonstack.func_77973_b()).getXpRatio(this.rantonstack, ItemRanton.LASERCIRCUS), 1.0f);
            return this.field_70146_Z.nextFloat() * f * 20.0f;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                entity.field_70170_p.func_72838_d((Entity)new EC(entity, power, stack));
                return true;
            }
        }
    }
}

