/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemYooton;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityLavaChakraMode
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 274;
    public static final int ENTITYID_RANGED = 275;

    public EntityLavaChakraMode(ElementsNarutomodMod instance) {
        super(instance, 594);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "lava_chakra_mode"), 274).name("lava_chakra_mode").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderCustom(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends Render<EC> {
        private final ResourceLocation texture;

        public RenderCustom(RenderManager renderManagerIn) {
            super(renderManagerIn);
            this.texture = new ResourceLocation("narutomod:textures/lavacloak1.png");
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float pt) {
            EntityLivingBase user = entity.getUser();
            if (user != null) {
                RenderLivingBase userRenderer = (RenderLivingBase)this.field_76990_c.func_78713_a((Entity)user);
                ModelBase model = userRenderer.func_177087_b();
                float f = (float)user.field_70173_aa + pt;
                float f1 = ProcedureUtils.interpolateRotation(user.field_70760_ar, user.field_70761_aq, pt);
                float f2 = ProcedureUtils.interpolateRotation(user.field_70758_at, user.field_70759_as, pt);
                float f3 = f2 - f1;
                float f5 = user.field_184618_aE + (user.field_70721_aZ - user.field_184618_aE) * pt;
                float f6 = user.field_184619_aG - user.field_70721_aZ * (1.0f - pt);
                float f7 = user.field_70127_C + (user.field_70125_A - user.field_70127_C) * pt;
                x = user.field_70142_S + (user.field_70165_t - user.field_70142_S) * (double)pt - this.field_76990_c.field_78730_l;
                y = user.field_70137_T + (user.field_70163_u - user.field_70137_T) * (double)pt - this.field_76990_c.field_78731_m;
                z = user.field_70136_U + (user.field_70161_v - user.field_70136_U) * (double)pt - this.field_76990_c.field_78728_n;
                this.func_180548_c(entity);
                if (!user.equals((Object)this.field_76990_c.field_78734_h) || this.field_76990_c.field_78733_k.field_74320_O != 0) {
                    if (user.func_70093_af()) {
                        y -= 0.125;
                    }
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                    float f4 = userRenderer.func_188322_c(user, pt);
                    GlStateManager.func_179114_b((float)(f1 - 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179096_D();
                    GlStateManager.func_179109_b((float)(f * 0.01f), (float)(f * 0.01f), (float)0.0f);
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                    this.renderModel(model, f6, f5, f, f3, f7, f4, (Entity)user);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179096_D();
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179121_F();
                }
            }
        }

        private void renderModel(ModelBase modelIn, float f0, float f1, float f2, float f3, float f4, float f5, Entity entityIn) {
            if (modelIn instanceof ModelBiped) {
                ModelBiped model = (ModelBiped)modelIn;
                GlStateManager.func_179094_E();
                if (model.field_78091_s) {
                    float f = 2.0f;
                    GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                    GlStateManager.func_179109_b((float)0.0f, (float)(16.0f * f5), (float)0.0f);
                    model.field_78116_c.func_78785_a(f5);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                    GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * f5), (float)0.0f);
                    model.field_78115_e.func_78785_a(f5);
                    model.field_178723_h.func_78785_a(f5);
                    model.field_178724_i.func_78785_a(f5);
                    model.field_178721_j.func_78785_a(f5);
                    model.field_178722_k.func_78785_a(f5);
                    model.field_178720_f.func_78785_a(f5);
                } else {
                    if (entityIn.func_70093_af()) {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                    }
                    model.field_78116_c.func_78785_a(f5);
                    model.field_78115_e.func_78785_a(f5);
                    model.field_178723_h.func_78785_a(f5);
                    model.field_178724_i.func_78785_a(f5);
                    model.field_178721_j.func_78785_a(f5);
                    model.field_178722_k.func_78785_a(f5);
                    model.field_178720_f.func_78785_a(f5);
                }
                GlStateManager.func_179121_F();
            } else {
                modelIn.func_78087_a(f0, f1, f2, f3, f4, f5, entityIn);
                modelIn.func_78088_a(entityIn, f0, f1, f2, f3, f4, f5);
            }
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return this.texture;
        }
    }

    public static class EC
    extends Entity {
        private static final DataParameter<Integer> USERID = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187192_b);
        protected static final String LCMEntityIdKey = "LavaChakraModeEntityId";
        private int strengthAmplifier = 9;

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
        }

        public EC(EntityLivingBase userIn) {
            this(userIn.field_70170_p);
            this.setUser(userIn);
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
            userIn.getEntityData().func_74768_a(LCMEntityIdKey, this.func_145782_y());
            if (userIn.func_70644_a(MobEffects.field_76420_g)) {
                this.strengthAmplifier += userIn.func_70660_b(MobEffects.field_76420_g).func_76458_c() + 1;
            }
        }

        protected void func_70088_a() {
            this.field_70180_af.func_187214_a(USERID, (Object)-1);
        }

        private void setUser(EntityLivingBase user) {
            this.func_184212_Q().func_187227_b(USERID, (Object)user.func_145782_y());
        }

        @Nullable
        private EntityLivingBase getUser() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(USERID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        public void func_70106_y() {
            EntityLivingBase user;
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && (user = this.getUser()) != null) {
                user.getEntityData().func_82580_o(LCMEntityIdKey);
            }
        }

        public void func_70071_h_() {
            EntityLivingBase user = this.getUser();
            if (user != null) {
                this.func_70107_b(user.field_70165_t, user.field_70163_u, user.field_70161_v);
                if (this.field_70173_aa % 20 == 19) {
                    if (!Chakra.pathway(user).consume(ItemYooton.CHAKRAMODE.chakraUsage)) {
                        this.func_70106_y();
                    } else {
                        user.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 21, this.strengthAmplifier, false, false));
                        user.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 21, 16, false, false));
                    }
                }
                if (this.field_70146_Z.nextInt(20) == 0) {
                    this.func_184185_a(SoundEvents.field_187656_cX, 0.5f, this.field_70146_Z.nextFloat() * 0.6f + 0.6f);
                }
                if (this.field_70170_p instanceof WorldServer && this.field_70146_Z.nextInt(10) == 0) {
                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.LAVA, user.field_70165_t, user.field_70163_u + (double)(user.field_70131_O / 2.0f), user.field_70161_v, 1, (double)user.field_70130_N * 0.5, (double)user.field_70131_O * 0.5, (double)user.field_70130_N * 0.5, 0.0, new int[0]);
                }
                for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, user.func_174813_aQ().func_186662_g(6.0))) {
                    if (entity.equals((Object)user)) continue;
                    entity.func_70097_a(DamageSource.field_76371_c, 4.0f);
                    entity.func_70015_d(15);
                }
            }
            if (!(this.field_70170_p.field_72995_K || user != null && user.func_70089_S())) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Entity entity1 = entity.field_70170_p.func_73045_a(entity.getEntityData().func_74762_e(EC.LCMEntityIdKey));
                if (!(entity1 instanceof EC)) {
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity));
                    return true;
                }
                entity1.func_70106_y();
                return false;
            }
        }
    }
}

