/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityLightningArc;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityLightningBeast
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 189;
    public static final int ENTITYID_RANGED = 190;
    private static final float MODELSCALE = 2.0f;

    public EntityLightningBeast(ElementsNarutomodMod instance) {
        super(instance, 451);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "lightning_beast"), 189).name("lightning_beast").tracker(64, 3, true).build());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderCustom(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelLightningWolf
        extends ModelBase {
            private final ModelRenderer head;
            private final ModelRenderer body;
            private final ModelRenderer upperBody;
            private final ModelRenderer leg0;
            private final ModelRenderer leg1;
            private final ModelRenderer leg2;
            private final ModelRenderer leg3;
            private final ModelRenderer tail;

            public ModelLightningWolf() {
                this.field_78090_t = 64;
                this.field_78089_u = 32;
                this.head = new ModelRenderer((ModelBase)this);
                this.head.func_78793_a(-1.0f, 13.5f, -7.0f);
                this.head.field_78804_l.add(new ModelBox(this.head, 0, 0, -2.0f, -3.0f, -2.0f, 6, 6, 4, 0.0f, false));
                this.head.field_78804_l.add(new ModelBox(this.head, 0, 10, -0.5f, -0.0f, -5.0f, 3, 3, 4, 0.0f, false));
                this.head.field_78804_l.add(new ModelBox(this.head, 16, 14, -2.0f, -5.0f, 0.0f, 2, 2, 1, 0.0f, false));
                this.head.field_78804_l.add(new ModelBox(this.head, 16, 14, 2.0f, -5.0f, 0.0f, 2, 2, 1, 0.0f, false));
                this.body = new ModelRenderer((ModelBase)this);
                this.body.func_78793_a(0.0f, 14.0f, 2.0f);
                this.setRotationAngle(this.body, 1.5708f, 0.0f, 0.0f);
                this.body.field_78804_l.add(new ModelBox(this.body, 18, 14, -4.0f, -2.0f, -3.0f, 6, 9, 6, 0.0f, false));
                this.upperBody = new ModelRenderer((ModelBase)this);
                this.upperBody.func_78793_a(-1.0f, 14.0f, 2.0f);
                this.setRotationAngle(this.upperBody, -1.5708f, 0.0f, 0.0f);
                this.upperBody.field_78804_l.add(new ModelBox(this.upperBody, 21, 0, -4.0f, 2.0f, -4.0f, 8, 6, 7, 0.0f, false));
                this.leg0 = new ModelRenderer((ModelBase)this);
                this.leg0.func_78793_a(-2.5f, 16.0f, 7.0f);
                this.leg0.field_78804_l.add(new ModelBox(this.leg0, 0, 18, -1.0f, 0.0f, -1.0f, 2, 8, 2, 0.0f, false));
                this.leg1 = new ModelRenderer((ModelBase)this);
                this.leg1.func_78793_a(0.5f, 16.0f, 7.0f);
                this.leg1.field_78804_l.add(new ModelBox(this.leg1, 0, 18, -1.0f, 0.0f, -1.0f, 2, 8, 2, 0.0f, false));
                this.leg2 = new ModelRenderer((ModelBase)this);
                this.leg2.func_78793_a(-2.5f, 16.0f, -4.0f);
                this.leg2.field_78804_l.add(new ModelBox(this.leg2, 0, 18, -1.0f, 0.0f, -1.0f, 2, 8, 2, 0.0f, false));
                this.leg3 = new ModelRenderer((ModelBase)this);
                this.leg3.func_78793_a(0.5f, 16.0f, -4.0f);
                this.leg3.field_78804_l.add(new ModelBox(this.leg3, 0, 18, -1.0f, 0.0f, -1.0f, 2, 8, 2, 0.0f, false));
                this.tail = new ModelRenderer((ModelBase)this);
                this.tail.func_78793_a(-1.0f, 12.0f, 8.0f);
                this.setRotationAngle(this.tail, 0.9599f, 0.0f, 0.0f);
                this.tail.field_78804_l.add(new ModelBox(this.tail, 9, 18, -1.0f, 0.0f, -1.0f, 2, 8, 2, 0.0f, false));
            }

            public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
                modelRenderer.field_78795_f = x;
                modelRenderer.field_78796_g = y;
                modelRenderer.field_78808_h = z;
            }

            public void func_78088_a(Entity entity, float f, float f1, float age, float f3, float f4, float f5) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)-1.5f, (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.head.func_78785_a(f5);
                this.body.func_78785_a(f5);
                this.upperBody.func_78785_a(f5);
                this.leg0.func_78785_a(f5);
                this.leg1.func_78785_a(f5);
                this.leg2.func_78785_a(f5);
                this.leg3.func_78785_a(f5);
                this.tail.func_78785_a(f5);
                GlStateManager.func_179121_F();
            }

            public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
                super.func_78087_a(f *= 2.0f / e.field_70131_O, f1, f2, f3, f4, f5, e);
                this.head.field_78796_g = f3 / 57.295776f;
                this.head.field_78795_f = f4 / 57.295776f;
                this.leg0.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
                this.leg1.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
                this.leg2.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
                this.tail.field_78808_h = f2 * 0.2f;
                this.leg3.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class LayerLightningCharge
        implements LayerRenderer<EC> {
            private final ResourceLocation LIGHTNING_TEXTURE = new ResourceLocation("narutomod:textures/electric_armor.png");
            private final RenderCustom renderer;
            private final ModelLightningWolf renderModel = new ModelLightningWolf();

            public LayerLightningCharge(RenderCustom rendererIn) {
                this.renderer = rendererIn;
            }

            public void doRenderLayer(EC entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                if (entitylivingbaseIn.field_70173_aa % 20 <= 10 + entitylivingbaseIn.func_70681_au().nextInt(10)) {
                    GlStateManager.func_179132_a((boolean)true);
                    this.renderer.func_110776_a(this.LIGHTNING_TEXTURE);
                    GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179096_D();
                    float f = (float)entitylivingbaseIn.field_70173_aa + partialTicks;
                    GlStateManager.func_179109_b((float)(f * 0.01f), (float)(f * 0.01f), (float)0.0f);
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    this.renderModel.func_178686_a(this.renderer.func_177087_b());
                    Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
                    this.renderModel.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, (Entity)entitylivingbaseIn);
                    this.renderModel.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                    Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
                    GlStateManager.func_179128_n((int)5890);
                    GlStateManager.func_179096_D();
                    GlStateManager.func_179128_n((int)5888);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179132_a((boolean)false);
                }
            }

            public boolean func_177142_b() {
                return false;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends RenderLiving<EC> {
            private final ResourceLocation texture;

            public RenderCustom(RenderManager p_i47187_1_) {
                super(p_i47187_1_, (ModelBase)new ModelLightningWolf(), 1.0f);
                this.texture = new ResourceLocation("narutomod:textures/wolf_lightning.png");
                this.func_177094_a(new LayerLightningCharge(this));
            }

            public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min((float)entity.field_70173_aa / 60.0f, 1.0f));
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.func_179140_f();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
                GlStateManager.func_179145_e();
                GlStateManager.func_179084_k();
            }

            protected ResourceLocation getEntityTexture(EC entity) {
                return this.texture;
            }
        }
    }

    public static class EC
    extends EntityTameable {
        private float power;
        private BlockPos destPos;
        private Vec3d startVec;
        private int jumpTicks;
        private final double ogSpeed = 1.6;

        public EC(World world) {
            super(world);
            this.func_70105_a(1.2f, 1.7f);
            this.field_70178_ae = true;
            this.field_70138_W = 8.0f;
            this.func_110163_bv();
            this.func_189654_d(true);
        }

        public EC(EntityPlayer player, float powerIn) {
            this(player.field_70170_p);
            RayTraceResult res = ProcedureUtils.raytraceBlocks((Entity)player, 4.0);
            double x = res.func_178782_a().func_177958_n();
            double z = res.func_178782_a().func_177952_p();
            this.func_70107_b(x + 0.5, player.field_70163_u, z + 0.5);
            this.field_70759_as = this.field_70177_z = player.field_70177_z - 180.0f;
            this.func_193101_c(player);
            this.power = powerIn;
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        }

        public SoundEvent func_184639_G() {
            return SoundEvents.field_187861_gG;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return null;
        }

        public SoundEvent func_184615_bR() {
            return null;
        }

        protected float func_70599_aP() {
            return 2.0f;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.ogSpeed);
            this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(this.ogSpeed);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0);
        }

        public void func_70690_d(PotionEffect potioneffectIn) {
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            return false;
        }

        public boolean func_70652_k(Entity entityIn) {
            return EntityLightningArc.onStruck(entityIn, ItemJutsu.causeJutsuDamage((Entity)this, null), this.power);
        }

        private BlockPos findDestination() {
            RayTraceResult rtr;
            EntityLivingBase owner = this.func_70902_q();
            if (owner != null && (rtr = ProcedureUtils.objectEntityLookingAt((Entity)owner, 30.0, (Entity)this)) != null) {
                IBlockState state;
                if (rtr.field_72308_g != null) {
                    this.startVec = this.func_174791_d();
                    return new BlockPos(rtr.field_72307_f);
                }
                if (rtr.field_72313_a == RayTraceResult.Type.BLOCK && ((state = this.field_70170_p.func_180495_p(rtr.func_178782_a())).func_185896_q() || state.func_185904_a().func_76224_d())) {
                    this.startVec = this.func_174791_d();
                    return rtr.func_178782_a().func_177984_a();
                }
            }
            this.startVec = null;
            return null;
        }

        protected void func_70619_bc() {
            super.func_70619_bc();
            if (this.field_70173_aa % 10 == 0) {
                if (this.destPos != null) {
                    Vec3d vec = new Vec3d((Vec3i)this.destPos).func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(this.ogSpeed);
                    this.field_70159_w = vec.field_72450_a;
                    this.field_70181_x = vec.field_72448_b + (this.field_70122_E ? 0.08 : 0.0);
                    this.field_70179_y = vec.field_72449_c;
                    this.field_70761_aq = this.field_70177_z = -((float)MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y)) * 57.295776f;
                }
                if (this.destPos == null || this.isDestOnPath()) {
                    this.destPos = this.findDestination();
                }
            }
        }

        private boolean isDestOnPath() {
            return this.startVec != null && this.destPos != null && this.func_70092_e(this.startVec.field_72450_a, this.startVec.field_72448_b, this.startVec.field_72449_c) > this.func_174831_c(this.destPos);
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            EntityLivingBase owner = this.func_70902_q();
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 4 == 0 && owner != null) {
                this.field_70170_p.func_72838_d((Entity)new EntityLightningArc.Base(this.field_70170_p, owner.func_174824_e(1.0f), this.func_174824_e(1.0f), -1073741569, 1, 0.0f));
            }
            if (this.field_70146_Z.nextInt(8) == 0) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:electricity")), 1.0f, this.field_70146_Z.nextFloat() * 0.6f + 0.9f);
            }
            if (this.field_70146_Z.nextFloat() <= 0.4f) {
                EntityLightningArc.spawnAsParticle(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5, new int[0]);
            }
            if (!(this.field_70170_p.field_72995_K || this.field_70173_aa <= 20 + (int)(this.power * 2.0f) && owner != null && owner.func_70089_S())) {
                this.func_70106_y();
            }
        }

        protected void func_85033_bc() {
            Vec3d vec1 = this.func_174791_d().func_72441_c(0.0, 0.5 * (double)this.field_70131_O, 0.0);
            Vec3d vec2 = vec1.func_178787_e(ProcedureUtils.getMotion((Entity)this));
            for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y), EntitySelectors.func_188442_a((Entity)this))) {
                if (entity.func_174813_aQ().func_72314_b((double)this.field_70130_N * 0.5, (double)this.field_70131_O * 0.5, (double)this.field_70130_N * 0.5).func_72327_a(vec1, vec2) == null) continue;
                this.func_82167_n(entity);
            }
        }

        protected void func_82167_n(Entity entityIn) {
            if (!entityIn.equals((Object)this.func_70902_q())) {
                this.func_70652_k(entityIn);
            }
            super.func_82167_n(entityIn);
        }

        protected float func_189749_co() {
            return 1.0f;
        }

        public EC createChild(EntityAgeable ageable) {
            return this.func_70909_n() ? new EC((EntityPlayer)this.func_70902_q(), this.power) : null;
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (entity instanceof EntityPlayer && power >= 5.0f) {
                    entity.field_70170_p.func_72838_d((Entity)new EC((EntityPlayer)entity, power));
                    return true;
                }
                return false;
            }
        }
    }
}

