/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityMeltingJutsu
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 272;
    public static final int ENTITYID_RANGED = 273;

    public EntityMeltingJutsu(ElementsNarutomodMod instance) {
        super(instance, 593);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "melting_jutsu"), 272).name("melting_jutsu").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderCustom(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelBlock
    extends ModelBase {
        private final ModelRenderer bb_main;

        public ModelBlock() {
            this.field_78090_t = 16;
            this.field_78089_u = 16;
            this.bb_main = new ModelRenderer((ModelBase)this);
            this.bb_main.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bb_main.field_78804_l.add(new ModelBox(this.bb_main, 0, 0, -2.0f, -4.0f, -2.0f, 4, 4, 4, 0.0f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.bb_main.func_78785_a(f5);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends Render<EC> {
        private final ResourceLocation TEXTURE;
        private final ModelBlock renderModel;

        public RenderCustom(RenderManager renderManagerIn) {
            super(renderManagerIn);
            this.TEXTURE = new ResourceLocation("narutomod:textures/lava.png");
            this.renderModel = new ModelBlock();
            this.field_76989_e = 0.3f;
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
            this.func_180548_c(entity);
            GlStateManager.func_179094_E();
            float scale = entity.getEntityScale();
            GlStateManager.func_179137_b((double)x, (double)(y + (double)(scale * 0.25f)), (double)z);
            GlStateManager.func_179114_b((float)entityYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float f = (float)entity.field_70173_aa + partialTicks;
            GlStateManager.func_179109_b((float)0.0f, (float)(f * 0.01f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            this.renderModel.func_78088_a(entity, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return this.TEXTURE;
        }
    }

    public static class EC
    extends EntityScalableProjectile.Base {
        private final int growTime = 20;
        private int duration;
        private BlockPos drip;
        private int deathTicks;
        private int deathTime;

        public EC(World world) {
            super(world);
            this.setOGSize(0.25f, 0.25f);
            this.func_189654_d(false);
        }

        public EC(EntityLivingBase shooter, float powerIn) {
            super(shooter);
            this.setOGSize(0.25f, 0.25f);
            this.func_189654_d(powerIn > 0.0f);
            this.setEntityScale(0.5f);
            this.func_70101_b(this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            this.setIdlePosition();
            this.duration = (int)(powerIn * 20.0f);
        }

        private void setIdlePosition() {
            if (this.shootingEntity != null) {
                Vec3d vec = this.shootingEntity.func_174824_e(1.0f).func_178787_e(this.shootingEntity.func_70040_Z().func_186678_a(0.4));
                this.func_70107_b(vec.field_72450_a, vec.field_72448_b - 0.1, vec.field_72449_c);
            }
        }

        private void solidifyLava(BlockPos pos) {
            if (this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151587_i) {
                this.field_70170_p.func_175698_g(pos);
                new EventSetBlocks(this.field_70170_p, (Map<BlockPos, IBlockState>)ImmutableMap.of((Object)pos, (Object)Blocks.field_150343_Z.func_176223_P()), 0L, 600, false, false);
                this.solidifyLava(pos.func_177977_b());
            }
        }

        private void onDeathUpdate() {
            if (!this.field_70170_p.field_72995_K) {
                if (this.deathTicks >= this.deathTime) {
                    this.func_70106_y();
                    if (this.drip != null) {
                        this.solidifyLava(this.drip);
                    }
                } else {
                    for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72321_a(0.0, -1.0, 0.0))) {
                        ProcedureUtils.multiplyVelocity((Entity)entity, 0.4);
                        entity.field_70181_x -= 0.04;
                    }
                }
            }
            ++this.deathTicks;
        }

        private void setDie() {
            this.deathTicks = 1;
            this.deathTime = 120 + this.field_70146_Z.nextInt(80);
            this.field_70170_p.func_72960_a((Entity)this, (byte)100);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70103_a(byte id) {
            if (id == 100) {
                this.setDie();
            } else {
                super.func_70103_a(id);
            }
        }

        @Override
        public void func_70071_h_() {
            if (this.deathTicks > 0) {
                this.onDeathUpdate();
                return;
            }
            super.func_70071_h_();
            if (this.duration > 0) {
                this.setIdlePosition();
                if (this.duration > 1) {
                    Vec3d vec = this.shootingEntity.func_70040_Z();
                    for (int i = 0; i < 10; ++i) {
                        EC entity = new EC(this.shootingEntity, 0.0f);
                        entity.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.85f, 0.1f);
                        this.field_70170_p.func_72838_d((Entity)entity);
                    }
                    --this.duration;
                }
            } else {
                if (!this.field_70170_p.field_72995_K && this.ticksInAir <= this.growTime) {
                    float f = 4.5f * (float)this.ticksInAir;
                    ((Object)((Object)this)).getClass();
                    this.setEntityScale(0.5f + f / 20.0f);
                }
                if (this.ticksInAir == this.field_70146_Z.nextInt(99) + 1) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:movement")), 0.8f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
                }
            }
            if (!this.field_70170_p.field_72995_K && this.ticksAlive > 100) {
                this.func_70106_y();
            }
        }

        @Override
        protected void onImpact(RayTraceResult result) {
            if (!this.field_70170_p.field_72995_K) {
                if (result.field_72308_g instanceof EC) {
                    return;
                }
                if (result.field_72308_g != null) {
                    result.field_72308_g.getEntityData().func_74757_a("TempData_disableKnockback", true);
                    result.field_72308_g.field_70172_ad = 10;
                    result.field_72308_g.func_70097_a(ItemJutsu.causeJutsuDamage(this, this.shootingEntity).func_76361_j(), 4.0f);
                    result.field_72308_g.func_70015_d(15);
                }
                Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c, 100, (double)this.field_70130_N, 0.0, (double)this.field_70130_N, 0.0, 0.0, 0.0, -1340071904, 20 + this.field_70146_Z.nextInt(30));
                this.func_184185_a(SoundEvents.field_187656_cX, 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
                if (this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    BlockPos pos;
                    BlockPos blockPos = pos = result.field_72313_a == RayTraceResult.Type.BLOCK ? result.func_178782_a().func_177972_a(result.field_178784_b) : new BlockPos(result.field_72307_f);
                    if (this.field_70170_p.func_175623_d(pos)) {
                        this.field_70170_p.func_180501_a(pos, Blocks.field_150353_l.func_176223_P(), 3);
                        this.drip = pos;
                    }
                }
                this.setDie();
            }
        }

        @Override
        protected void checkOnGround() {
            super.checkOnGround();
            if (this.func_70090_H()) {
                this.func_70106_y();
            }
        }

        @Override
        public void renderParticles() {
        }

        @Override
        public void updateInFlightRotations() {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (power >= 1.0f) {
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity, power));
                    return true;
                }
                return false;
            }
        }
    }
}

