/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityNinjaMerchant;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.event.EventVillageSiege;
import net.narutomod.item.ItemEightGates;
import net.narutomod.item.ItemNinjaArmorJumpsuit;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityMightGuy
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 111;
    public static final int ENTITYID_RANGED = 112;

    public EntityMightGuy(ElementsNarutomodMod instance) {
        super(instance, 323);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "mightguy"), 111).name("mightguy").tracker(64, 3, true).egg(-16751104, -3355648).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        EntityRegistry.addSpawn(EntityCustom.class, (int)20, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])new Biome[]{Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_76767_f, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_76785_t, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_150585_R, Biomes.field_150578_U, Biomes.field_150581_V, Biomes.field_76768_g, Biomes.field_76784_u, Biomes.field_185435_ag, Biomes.field_185444_T, Biomes.field_185448_Z, Biomes.field_185429_aa, Biomes.field_185446_X, Biomes.field_185447_Y, Biomes.field_185430_ab, Biomes.field_150590_f, Biomes.field_185431_ac, Biomes.field_185432_ad, Biomes.field_185433_ae});
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> {
                EntityNinjaMob.RenderBase<EntityCustom> customRender = new EntityNinjaMob.RenderBase<EntityCustom>(renderManager, (ModelBiped)new ModelMightguy()){
                    private final ResourceLocation texture;
                    {
                        super(renderManager, model);
                        this.texture = new ResourceLocation("narutomod:textures/might_guy.png");
                    }

                    protected ResourceLocation getEntityTexture(EntityCustom entity) {
                        return this.texture;
                    }

                    protected int getColorMultiplier(EntityCustom entity, float lightBrightness, float partialTick) {
                        if (entity.getGateOpened() >= 3.0f) {
                            return -1329594368;
                        }
                        return super.func_77030_a((EntityLivingBase)entity, lightBrightness, partialTick);
                    }
                };
                return customRender;
            });
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelMightguy
        extends ModelBiped {
            public ModelMightguy() {
                super(0.0f, 0.0f, 64, 64);
                this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 32, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.25f, false));
                this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 32, -3.0f, -2.0f, -2.0f, 4, 12, 4, 0.25f, false));
                this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 48, 48, -1.0f, -2.0f, -2.0f, 4, 12, 4, 0.25f, false));
                this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 32, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f, false));
                this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 0, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f, false));
            }

            public void func_78086_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTickTime) {
                super.func_78086_a(entity, limbSwing, limbSwingAmount, partialTickTime);
                if (((EntityCustom)entity).isSwingingArms()) {
                    this.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
        }
    }

    public static class EntityCustom
    extends EntityNinjaMerchant.Base
    implements IRangedAttackMob {
        private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187198_h);
        private int closeGatesCountdown;
        private int gateCooldown;
        private int attackCooldown;
        private EntityPlayer customer;
        private int siegeStartingVillagers;
        private ScoreObjective customerKillCount;
        private int killCount;
        private float gateOpened;
        private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);

        public EntityCustom(World world) {
            super(world, 120, 5000.0);
            this.func_70105_a(0.6f, 2.0f);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.leapAI);
            this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
            this.gateCooldown = 100;
        }

        @Override
        public Map<EntityNinjaMerchant.TradeLevel, MerchantRecipeList> getTrades() {
            HashMap trades = Maps.newHashMap();
            MerchantRecipeList commonTrades = new MerchantRecipeList();
            commonTrades.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 2), ItemStack.field_190927_a, new ItemStack(ItemNinjaArmorJumpsuit.legs, 1), 0, 1));
            trades.put(EntityNinjaMerchant.TradeLevel.COMMON, commonTrades);
            return trades;
        }

        @Override
        protected void func_70088_a() {
            super.func_70088_a();
            this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        }

        public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
            livingdata = super.func_180482_a(difficulty, livingdata);
            this.setItemToInventory(new ItemStack(ItemEightGates.block), 0);
            return livingdata;
        }

        @Override
        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRanged(this, 1.2, 200, 30.0f){

                public boolean func_75250_a() {
                    return !this.func_110175_bO() && gateOpened >= 7.0f && super.func_75250_a();
                }
            });
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityNinjaMob.AILeapAtTarget((EntityLiving)this, 1.0f){

                @Override
                public boolean func_75250_a() {
                    this.target = this.leaper.func_70638_az();
                    if (this.target != null) {
                        double d1 = this.target.field_70165_t - this.leaper.field_70165_t;
                        double d2 = this.target.field_70163_u - this.leaper.field_70163_u;
                        double d3 = this.target.field_70161_v - this.leaper.field_70161_v;
                        double d0 = d1 * d1 + d2 * d2 + d3 * d3;
                        double d4 = d1 * d1 + d3 * d3;
                        if (d0 >= 9.0 && (d0 <= 144.0 || d4 < 256.0) && this.leaper.field_70122_E) {
                            return this.leaper.func_70681_au().nextInt(5) == 0;
                        }
                    }
                    return false;
                }

                @Override
                public void func_75249_e() {
                    Vec3d vec = this.leaper.func_174791_d().func_178788_d(this.target.func_174791_d()).func_72432_b().func_178787_e(this.target.func_174791_d());
                    if (this.leaper.field_70170_p.func_147447_a(this.leaper.func_174824_e(1.0f), vec, false, true, false) == null) {
                        this.leaper.func_70080_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, this.leaper.field_70759_as, this.leaper.field_70125_A);
                        this.leaper.field_70159_w = 0.0;
                        this.leaper.field_70181_x = 0.0;
                        this.leaper.field_70179_y = 0.0;
                        this.leaper.field_70160_al = true;
                    } else {
                        super.func_75249_e();
                    }
                }
            });
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget(this, EntityMob.class, false, false){

                public boolean func_75250_a() {
                    return this.func_110175_bO() && super.func_75250_a();
                }
            });
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget(this, EntityNinjaMob.Base.class, 10, false, false, IMob.field_82192_a){

                public boolean func_75250_a() {
                    return this.func_110175_bO() && super.func_75250_a();
                }
            });
        }

        @Override
        protected boolean func_70692_ba() {
            return !this.func_110175_bO();
        }

        protected Item func_146068_u() {
            return null;
        }

        @Override
        public SoundEvent func_184639_G() {
            return SoundEvents.field_193783_dc;
        }

        @Override
        public SoundEvent func_184601_bQ(DamageSource ds) {
            return SoundEvents.field_193787_df;
        }

        @Override
        public SoundEvent func_184615_bR() {
            return SoundEvents.field_193786_de;
        }

        private boolean isEntityInFOV(Entity entityIn) {
            return ProcedureUtils.isEntityInFOV((EntityLivingBase)this, entityIn);
        }

        public boolean func_184191_r(Entity entityIn) {
            return super.func_184191_r(entityIn) || EntityNinjaMob.TeamKonoha.contains(entityIn.getClass()) || this.isTrackingCustomer() && entityIn.equals((Object)this.customer);
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source.func_76346_g() instanceof EntityPlayer && this.getVillage() != null) {
                this.getVillage().modifyPlayerReputation(source.func_76346_g().func_110124_au(), -3);
            }
            if (source.func_76346_g() instanceof EntityLivingBase && !source.func_76363_c() && this.isEntityInFOV(source.func_76346_g())) {
                amount *= this.field_70146_Z.nextFloat() * 0.2f;
                this.func_184609_a(EnumHand.OFF_HAND);
            }
            return super.func_70097_a(source, amount);
        }

        @Override
        public boolean func_70652_k(Entity entityIn) {
            boolean flag = true;
            this.func_184609_a(EnumHand.MAIN_HAND);
            if ((int)this.gateOpened == 6 && !this.func_110175_bO()) {
                ItemStack stack = this.func_184614_ca();
                if (stack.func_77973_b() == ItemEightGates.block) {
                    Vec3d vec = entityIn.func_174824_e(1.0f).func_178788_d(this.func_174824_e(1.0f));
                    ((ItemEightGates.RangedItem)stack.func_77973_b()).attackAsakujaku((EntityLivingBase)this, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
            } else {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f * (1.0f + this.field_70146_Z.nextFloat() * 0.4f));
                if (flag) {
                    entityIn.field_70181_x += (double)f * 0.02 / (double)entityIn.field_70131_O;
                    this.func_174815_a((EntityLivingBase)this, entityIn);
                }
            }
            return flag;
        }

        @Override
        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(100.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        }

        @Override
        protected void func_70619_bc() {
            EntityLivingBase target = this.func_70638_az();
            if (target != null && target.func_70089_S()) {
                if (this.gateCooldown == 0) {
                    float targetStrength;
                    float gate = 0.0f;
                    if (this.func_110143_aJ() < this.func_110138_aP() / 2.0f) {
                        gate = 3.5f;
                    }
                    if ((targetStrength = (float)ProcedureUtils.getModifiedAttackDamage(target)) > 10.0f || target.func_110138_aP() >= 50.0f) {
                        double d = Chakra.getLevel(target);
                        gate = MathHelper.func_76133_a((double)(((double)targetStrength + d) * ((double)target.func_110138_aP() + d))) / 25.0f;
                    }
                    if (gate >= 1.0f) {
                        this.tryOpenGate(gate);
                    }
                }
                if (--this.attackCooldown <= 0 && (double)this.func_70032_d((Entity)target) <= 2.0 + (double)target.field_70130_N) {
                    this.attackCooldown = 10;
                    this.func_70652_k((Entity)target);
                }
            } else {
                this.func_70624_b(null);
                if (--this.closeGatesCountdown <= 0) {
                    this.closeGates();
                }
            }
            if (this.gateCooldown > 0) {
                --this.gateCooldown;
            }
            super.func_70619_bc();
        }

        @Override
        public boolean func_70601_bi() {
            Village village = this.field_70170_p.func_175714_ae().func_176056_a(new BlockPos((Entity)this), 32);
            if (village == null || village.func_75567_c() < 20 || village.func_75562_e() < 10 || !this.field_70170_p.func_175644_a(EntityCustom.class, EntitySelectors.field_94557_a).isEmpty()) {
                return false;
            }
            return super.func_70601_bi();
        }

        public void func_70074_a(EntityLivingBase entity) {
            if (this.isTrackingCustomer()) {
                ++this.killCount;
                this.field_70170_p.func_96441_U().func_96529_a(this.func_70005_c_(), this.customerKillCount).func_96647_c(this.killCount);
            }
        }

        public boolean isTrackingCustomer() {
            return this.customerKillCount != null;
        }

        public void startTrackingCustomer() {
            if (!this.field_70170_p.field_72995_K && this.customer != null && this.getVillage() != null) {
                ProcedureUtils.sendChat(this.customer, TextFormatting.GREEN + I18n.func_74838_a((String)"entity.mightguy.name") + ": " + TextFormatting.WHITE + I18n.func_74838_a((String)"chattext.mightguy.interact2"));
                this.siegeStartingVillagers = this.getVillage().func_75562_e();
                Scoreboard _sc = this.field_70170_p.func_96441_U();
                this.customerKillCount = _sc.func_96518_b("siege_kills");
                if (this.customerKillCount == null) {
                    this.customerKillCount = _sc.func_96535_a("siege_kills", ScoreCriteria.field_96640_e);
                    this.customerKillCount.func_96681_a(I18n.func_74838_a((String)"scoreboard.objective.siege_kills"));
                }
                _sc.func_96529_a(this.func_70005_c_(), this.customerKillCount).func_96647_c(0);
                _sc.func_96529_a(this.customer.func_70005_c_(), this.customerKillCount).func_96647_c(0);
                _sc.func_96530_a(1, this.customerKillCount);
            }
        }

        public void stopTrackingCustomer() {
            if (!this.field_70170_p.field_72995_K && this.customer != null && this.getVillage() != null && this.customerKillCount != null) {
                int kills = this.field_70170_p.func_96441_U().func_96529_a(this.customer.func_70005_c_(), this.customerKillCount).func_96652_c();
                int villagersKilled = this.siegeStartingVillagers - this.getVillage().func_75562_e();
                if (villagersKilled > 0 || kills <= this.killCount / 2 || !this.customer.func_70089_S()) {
                    ProcedureUtils.sendChat(this.customer, TextFormatting.GREEN + I18n.func_74838_a((String)"entity.mightguy.name") + ": " + TextFormatting.WHITE + I18n.func_74838_a((String)"chattext.mightguy.interact4"));
                    this.getVillage().modifyPlayerReputation(this.customer.func_110124_au(), -3);
                } else {
                    ProcedureUtils.sendChat(this.customer, TextFormatting.GREEN + I18n.func_74838_a((String)"entity.mightguy.name") + ": " + TextFormatting.WHITE + I18n.func_74838_a((String)"chattext.mightguy.interact3"));
                    this.getVillage().modifyPlayerReputation(this.customer.func_110124_au(), 3);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)this.customer, (ItemStack)new ItemStack(ItemEightGates.block));
                    ProcedureUtils.grantAdvancement((EntityPlayerMP)this.customer, "narutomod:openedgates", true);
                }
                this.customer.func_146105_b((ITextComponent)new TextComponentString("Villagers killed: " + villagersKilled + ", your kills: " + kills + ", Might Guy's kills: " + this.killCount), false);
                this.customer.func_96123_co().func_96519_k(this.customerKillCount);
                this.customer = null;
                this.customerKillCount = null;
                this.killCount = 0;
            }
        }

        @Override
        public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
            if (!this.field_70170_p.field_72995_K && this.getVillage() != null) {
                Village village = this.getVillage();
                if (this.customer == null && village.getPlayerReputation(player.func_110124_au()) >= 0 && !this.isTrading()) {
                    this.customer = player;
                    ProcedureUtils.sendChat(player, TextFormatting.GREEN + I18n.func_74838_a((String)"entity.mightguy.name") + ": " + TextFormatting.WHITE + I18n.func_74838_a((String)"chattext.mightguy.interact1"));
                    long startTime = this.field_70170_p.func_82737_E() + 18000L - this.field_70170_p.func_72820_D() % 24000L;
                    new EventVillageSiege(this.field_70170_p, null, village.func_180608_a().func_177958_n(), village.func_180608_a().func_177956_o(), village.func_180608_a().func_177952_p(), startTime, village.func_75568_b() + 5, 60){

                        @Override
                        protected void doOnTick(int currentTick) {
                            if (currentTick == 0) {
                                this.startTrackingCustomer();
                            } else {
                                this.stopTrackingCustomer();
                            }
                        }
                    };
                    return true;
                }
            }
            return super.func_184645_a(player, hand);
        }

        private void tryOpenGate(float gate) {
            if (this.func_184614_ca().func_77973_b() == ItemEightGates.block) {
                this.gateOpened = this.getGateOpened();
                if (this.func_110143_aJ() < this.func_110138_aP() * 0.9f) {
                    if (gate > 4.0f && this.gateOpened < 4.0f) {
                        gate = 3.5f;
                    } else if (this.func_110143_aJ() < 4.0f && this.gateOpened >= 4.0f) {
                        this.closeGates();
                        return;
                    }
                }
                if (this.gateOpened < Math.min(gate, 7.0f)) {
                    if (!this.func_184587_cr()) {
                        this.func_70095_a(true);
                        this.func_184598_c(EnumHand.MAIN_HAND);
                    }
                } else if (this.func_184587_cr()) {
                    this.func_184602_cy();
                    this.func_70095_a(false);
                }
                this.closeGatesCountdown = 100;
            } else {
                this.swapWithInventory(EntityEquipmentSlot.MAINHAND, 0);
            }
        }

        private void closeGates() {
            if (this.getGateOpened() > 0.0f) {
                this.swapWithInventory(EntityEquipmentSlot.MAINHAND, 0);
                this.gateOpened = 0.0f;
                this.gateCooldown = 600;
            }
        }

        private float getGateOpened() {
            ItemStack stack = this.func_184614_ca();
            return stack.func_77973_b() == ItemEightGates.block ? ((ItemEightGates.RangedItem)stack.func_77973_b()).getGateOpened(stack) : 0.0f;
        }

        private void debugChatInfo() {
            float gateOpened = this.getGateOpened();
            ProcedureUtils.sendChatAll("main hand:" + this.func_184614_ca() + ", gate opened:" + gateOpened + ", dmg:" + ProcedureUtils.getModifiedAttackDamage((EntityLivingBase)this) + ", health:" + this.func_110138_aP());
        }

        private void clampVelocity(double d) {
            Vec3d vec3d = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (vec3d.func_72433_c() > d) {
                vec3d = vec3d.func_186678_a(d / vec3d.func_72433_c());
                ProcedureUtils.setVelocity((Entity)this, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            }
        }

        public void func_70030_z() {
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
                ProcedureUtils.sendChatAll(I18n.func_74838_a((String)"chattext.mightguy.arrival"));
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:howl_youth")), 10.0f, 1.0f);
            }
            if (this.field_70173_aa % 100 == 0) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 101, 5, false, false));
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(5.0f);
                }
            }
            if (this.customer != null && (!this.customer.func_70089_S() || this.customer instanceof EntityPlayerMP && ((EntityPlayerMP)this.customer).func_193105_t()) && this.isTrackingCustomer()) {
                this.stopTrackingCustomer();
            }
            this.clampVelocity(1.0);
            super.func_70030_z();
        }

        public void func_184724_a(boolean swingingArms) {
            this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
        }

        public boolean isSwingingArms() {
            return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
        }

        public void func_82196_d(EntityLivingBase target, float flval) {
            if (this.func_184614_ca().func_77973_b() == ItemEightGates.block) {
                ((ItemEightGates.RangedItem)this.func_184614_ca().func_77973_b()).attackHirudora((EntityLivingBase)this);
            }
        }

        public boolean func_184222_aU() {
            return false;
        }

        public void func_184178_b(EntityPlayerMP player) {
            super.func_184178_b(player);
            this.bossInfo.func_186760_a(player);
        }

        public void func_184203_c(EntityPlayerMP player) {
            super.func_184203_c(player);
            this.bossInfo.func_186761_b(player);
        }

        private void trackAttackingPlayer() {
            EntityLivingBase attacker = this.func_94060_bK();
            if (attacker instanceof EntityPlayerMP || (attacker = this.func_70638_az()) instanceof EntityPlayerMP) {
                this.bossInfo.func_186760_a((EntityPlayerMP)attacker);
            } else {
                ArrayList<EntityPlayerMP> list = new ArrayList<EntityPlayerMP>();
                for (EntityPlayerMP entityplayermp : this.bossInfo.func_186757_c()) {
                    list.add(entityplayermp);
                }
                for (EntityPlayerMP entityplayermp : list) {
                    this.bossInfo.func_186761_b(entityplayermp);
                }
            }
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            this.trackAttackingPlayer();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }
}

