/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.PlayerInput;
import net.narutomod.PlayerRender;
import net.narutomod.PlayerTracker;
import net.narutomod.entity.EntityClone;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.item.ItemInton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureOnLivingUpdate;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityMindTransfer
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 288;
    public static final int ENTITYID_RANGED = 289;

    public EntityMindTransfer(ElementsNarutomodMod instance) {
        super(instance, 607);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "mind_transfer"), 288).name("mind_transfer").tracker(64, 3, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityDuplicate.class).id(new ResourceLocation("narutomod", "mind_transfer_self"), 289).name("mind_transfer_self").tracker(64, 3, true).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EC.PlayerHook());
    }

    public static class EntityDuplicate
    extends EntityClone.Base {
        public EntityDuplicate(World world) {
            super(world);
            this.func_94061_f(true);
        }

        public EntityDuplicate(EntityLivingBase user) {
            super(user);
            this.func_94061_f(true);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)user.func_110138_aP());
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(user.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e());
            this.func_70606_j(user.func_110143_aJ());
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
        }
    }

    public static class EC
    extends Entity
    implements PlayerInput.Hook.IHandler {
        private EntityLivingBase user;
        private EntityLivingBase target;
        private EntityDuplicate clone;
        private Vec3d targetVec;
        private Vec3d motion2Target;
        private double chakraBurn;
        private final int move2TargetTime = 60;
        private PlayerInput.Hook userInput = new PlayerInput.Hook();

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
            this.field_70178_ae = true;
        }

        public EC(EntityLivingBase userIn, EntityLivingBase targetIn, double chakraBurnIn) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.target = targetIn;
            this.targetVec = this.target.func_174791_d().func_178787_e(Vec3d.field_186680_a);
            this.motion2Target = this.targetVec.func_178788_d(userIn.func_174791_d()).func_186678_a(1.0 / (double)this.move2TargetTime);
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
            this.chakraBurn = chakraBurnIn;
        }

        protected void func_70088_a() {
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                if (this.user != null) {
                    this.user.getEntityData().func_82580_o("MindTransferEntityIdKey");
                    if (this.clone != null) {
                        this.user.field_70177_z = this.clone.field_70177_z;
                        this.user.func_70634_a(this.clone.field_70165_t, this.clone.field_70163_u, this.clone.field_70161_v);
                    }
                    if (this.user instanceof EntityPlayer) {
                        PlayerRender.setSkinCloneTarget((EntityPlayer)this.user, null);
                        PlayerInput.Hook.copyInputFrom((EntityPlayerMP)this.user, this, false);
                        this.spectate((EntityPlayerMP)this.user, null);
                    }
                    this.user.func_189654_d(false);
                    this.user.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 600, 32));
                    this.user.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 600, 1));
                    this.user.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 600, 4));
                }
                if (this.target != null) {
                    if (this.target instanceof EntityPlayerMP) {
                        this.spectate((EntityPlayerMP)this.target, null);
                        this.target.func_70606_j(this.user.func_110143_aJ());
                    }
                    PlayerInput.Hook.haltTargetInput(this.target, false);
                }
                if (this.clone != null) {
                    if (this.user != null) {
                        this.user.func_70606_j(this.clone.func_110143_aJ());
                    }
                    this.clone.func_70106_y();
                }
            }
        }

        public void func_70071_h_() {
            if (this.user instanceof EntityPlayer && this.user.func_70089_S() && this.target != null && this.target.func_70089_S() && Chakra.pathway(this.user).consume(this.chakraBurn)) {
                this.func_70107_b(this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
                if (this.field_70173_aa == 1) {
                    this.clone = new EntityDuplicate(this.user);
                    this.field_70170_p.func_72838_d((Entity)this.clone);
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:mindtransfer")), 1.0f, 1.0f);
                }
                if (this.clone != null && this.clone.func_110143_aJ() < this.clone.func_110138_aP() * 0.2f) {
                    this.func_70106_y();
                }
                if (this.field_70173_aa <= this.move2TargetTime) {
                    if (this.field_70173_aa == 1) {
                        this.user.func_189654_d(true);
                        ProcedureOnLivingUpdate.setNoClip((Entity)this.user, true);
                    }
                    this.user.field_70159_w = this.motion2Target.field_72450_a;
                    this.user.field_70181_x = this.motion2Target.field_72448_b;
                    this.user.field_70179_y = this.motion2Target.field_72449_c;
                    this.user.field_70133_I = true;
                    this.user.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 2, 0, false, false));
                } else if (this.user.func_174813_aQ().func_72326_a(this.target.func_174813_aQ())) {
                    if (this.target instanceof EntityPlayer) {
                        if (this.field_70173_aa == this.move2TargetTime + 1) {
                            this.user.func_82149_j((Entity)this.target);
                            PlayerRender.setSkinCloneTarget((EntityPlayer)this.user, (EntityPlayer)this.target);
                            ProcedureOnLivingUpdate.setNoClip((Entity)this.user, false);
                            PlayerInput.Hook.haltTargetInput(this.target, true);
                            this.user.func_70606_j(this.target.func_110143_aJ());
                            this.user.func_189654_d(false);
                        }
                        this.spectate((EntityPlayerMP)this.target, (Entity)this.user);
                    } else {
                        if (this.field_70173_aa == this.move2TargetTime + 1) {
                            ProcedureOnLivingUpdate.setNoClip((Entity)this.user, false);
                            PlayerInput.Hook.copyInputFrom((EntityPlayerMP)this.user, this, true);
                            PlayerInput.Hook.haltTargetInput(this.target, true);
                            this.user.func_189654_d(false);
                        }
                        if (this.userInput.hasNewMovementInput()) {
                            this.userInput.handleMovement(this.target);
                        }
                        if (this.userInput.hasNewMouseEvent()) {
                            this.userInput.handleMouseEvent(this.target);
                        }
                        this.spectate((EntityPlayerMP)this.user, (Entity)this.target);
                    }
                } else {
                    this.func_70106_y();
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        private void spectate(EntityPlayerMP spectator, @Nullable Entity targetEntity) {
            ProcedureOnLivingUpdate.setNoClip((Entity)spectator, targetEntity != null, spectator == this.user);
            spectator.func_175399_e(targetEntity);
            if (targetEntity != null) {
                spectator.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 2, 0, false, false));
                spectator.getEntityData().func_74780_a(NarutomodModVariables.InvulnerableTime, 10.0);
                spectator.func_70634_a(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v);
            }
        }

        @Override
        public void handlePacket(@Nullable PlayerInput.Hook.MovementPacket movementPacket, @Nullable PlayerInput.Hook.MousePacket mousePacket) {
            if (movementPacket != null) {
                this.userInput.copyMovementInput(movementPacket);
            }
            if (mousePacket != null) {
                this.userInput.copyMouseInput(mousePacket);
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class PlayerHook {
            @SubscribeEvent
            public void onChangeDimension(EntityTravelToDimensionEvent event) {
                Entity entity1;
                int i;
                Entity entity = event.getEntity();
                if (entity instanceof EntityLivingBase && (i = entity.getEntityData().func_74762_e("MindTransferEntityIdKey")) > 0 && (entity1 = entity.field_70170_p.func_73045_a(i)) instanceof EC) {
                    entity1.func_70106_y();
                    event.setCanceled(true);
                }
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ECENTITYID = "MindTransferEntityIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Entity entity1 = entity.field_70170_p.func_73045_a(entity.getEntityData().func_74762_e(ECENTITYID));
                if (entity1 instanceof EC) {
                    entity1.func_70106_y();
                } else {
                    RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)entity, 30.0);
                    if (res != null && (res.field_72308_g instanceof EntityLiving || res.field_72308_g instanceof EntityPlayer)) {
                        double d = 1.0;
                        if (entity instanceof EntityPlayer) {
                            double d1 = PlayerTracker.getNinjaLevel((EntityPlayer)entity);
                            d = res.field_72308_g instanceof EntityPlayer ? Math.max(PlayerTracker.getNinjaLevel((EntityPlayer)res.field_72308_g) / d1, 1.0) : (res.field_72308_g instanceof EntityNinjaMob.Base ? Math.max((double)((EntityNinjaMob.Base)res.field_72308_g).getNinjaLevel() / d1, 1.0) : Math.max((double)(((EntityLivingBase)res.field_72308_g).func_110143_aJ() / entity.func_110143_aJ()), 1.0));
                        }
                        entity1 = new EC(entity, (EntityLivingBase)res.field_72308_g, ItemInton.MBTRANSFER.chakraUsage * d * 0.005);
                        entity.field_70170_p.func_72838_d(entity1);
                        entity.getEntityData().func_74768_a(ECENTITYID, entity1.func_145782_y());
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

