/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.item.ItemBijuMap;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityNinjaMerchant
extends ElementsNarutomodMod.ModElement {
    public EntityNinjaMerchant(ElementsNarutomodMod instance) {
        super(instance, 435);
    }

    public static abstract class Base
    extends EntityNinjaMob.Base
    implements IMerchant {
        private Map<TradeLevel, MerchantRecipeList> trades;
        private final List<UUID> assholeList = Lists.newArrayList();
        private EntityPlayer customer;
        private int homeCheckTimer;
        private Village village;
        private int recipeResetTime;
        private boolean hasTraded;
        private int level;
        protected EntityNinjaMob.AILeapAtTarget leapAI = new EntityNinjaMob.AILeapAtTarget((EntityLiving)this, 1.0f);

        public Base(World worldIn, int level) {
            this(worldIn, level, (double)level * (double)level);
        }

        public Base(World worldIn, int level, double maxchakra) {
            super(worldIn, level, maxchakra);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.leapAI);
            this.trades = this.getTrades();
            this.addRareTrades();
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        }

        public String toString() {
            return super.toString();
        }

        public abstract Map<TradeLevel, MerchantRecipeList> getTrades();

        private void addRareTrades() {
            MerchantRecipeList rareTrades = this.trades.get((Object)TradeLevel.RARE);
            if (rareTrades == null) {
                rareTrades = new MerchantRecipeList();
            }
            rareTrades.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 64), ItemStack.field_190927_a, new ItemStack(ItemBijuMap.block, 1), 0, 1));
            this.trades.put(TradeLevel.RARE, rareTrades);
        }

        public NBTTagCompound func_189511_e(NBTTagCompound compound) {
            compound.func_74757_a("hasTraded", this.hasTraded);
            compound.func_74768_a("level", this.level);
            NBTTagCompound tradesTag = new NBTTagCompound();
            for (Map.Entry<TradeLevel, MerchantRecipeList> entry : this.trades.entrySet()) {
                tradesTag.func_74782_a(entry.getKey().name(), (NBTBase)entry.getValue().func_77202_a());
            }
            compound.func_74782_a("trades", (NBTBase)tradesTag);
            return super.func_189511_e(compound);
        }

        public void func_70020_e(NBTTagCompound compound) {
            super.func_70020_e(compound);
            this.hasTraded = compound.func_74767_n("hasTraded");
            this.level = compound.func_74762_e("level");
            NBTTagCompound tradesTag = compound.func_74775_l("trades");
            this.trades = Maps.newHashMap();
            for (String key : tradesTag.func_150296_c()) {
                TradeLevel level = TradeLevel.valueOf(key);
                NBTTagCompound recipeListTag = tradesTag.func_74775_l(key);
                MerchantRecipeList recipeList = new MerchantRecipeList();
                recipeList.func_77201_a(recipeListTag);
                this.trades.put(level, recipeList);
            }
        }

        protected boolean func_70692_ba() {
            return !this.hasTraded;
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AITradePlayer(this));
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIWatchCustomer(this));
            this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
            this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 15.0f, 0.05f));
            this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
            this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIDefendVillage(this));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        }

        public void func_70932_a_(@Nullable EntityPlayer player) {
            this.customer = player;
        }

        @Nullable
        public EntityPlayer func_70931_l_() {
            return this.customer;
        }

        public boolean isTrading() {
            return this.customer != null;
        }

        @Nullable
        public MerchantRecipeList func_70934_b(EntityPlayer player) {
            MerchantRecipeList recipes = this.trades.entrySet().stream().filter(entry -> ((TradeLevel)((Object)((Object)entry.getKey()))).ordinal() <= this.level).flatMap(entry -> ((MerchantRecipeList)entry.getValue()).stream()).collect(Collectors.toCollection(MerchantRecipeList::new));
            return recipes.isEmpty() ? null : recipes;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
        }

        public void func_70933_a(MerchantRecipe recipe) {
            recipe.func_77399_f();
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
            if (recipe.func_82784_g() && this.recipeResetTime <= 0) {
                this.recipeResetTime = 6000;
            }
            if (this.customer != null && this.village != null) {
                this.village.modifyPlayerReputation(this.customer.func_110124_au(), 1);
            }
        }

        public void func_110297_a_(ItemStack stack) {
            if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
                this.field_70757_a = -this.func_70627_aG();
                this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
                this.hasTraded = true;
                ++this.level;
            }
        }

        public Village getVillage() {
            return this.village;
        }

        @Override
        protected void func_70619_bc() {
            if (--this.homeCheckTimer <= 0) {
                this.homeCheckTimer = 70 + this.field_70146_Z.nextInt(50);
                this.village = this.field_70170_p.func_175714_ae().func_176056_a(new BlockPos((Entity)this), 96);
                if (this.village == null) {
                    this.func_110177_bN();
                } else {
                    BlockPos blockpos = this.village.func_180608_a();
                    this.func_175449_a(blockpos, (int)((float)this.village.func_75568_b() * 0.6f));
                }
            }
            if (!this.isTrading() && this.recipeResetTime > 0) {
                --this.recipeResetTime;
                if (this.recipeResetTime <= 0) {
                    for (MerchantRecipeList recipeList : this.trades.values()) {
                        for (MerchantRecipe recipe : recipeList) {
                            if (!recipe.func_82784_g()) continue;
                            recipe.func_82783_a(1);
                        }
                    }
                }
            }
            super.func_70619_bc();
        }

        public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_190926_b() && this.func_70089_S() && !this.isTrading() && !player.func_70093_af()) {
                if (!this.field_70170_p.field_72995_K && this.func_70934_b(player) != null && !this.assholeList.contains(player.func_110124_au())) {
                    this.func_70932_a_(player);
                    player.func_180472_a((IMerchant)this);
                } else if (this.field_70170_p.field_72995_K) {
                    return true;
                }
            }
            return super.func_184645_a(player, hand);
        }

        @Override
        public boolean func_70601_bi() {
            this.village = this.field_70170_p.func_175714_ae().func_176056_a(new BlockPos((Entity)this), 32);
            if (this.village == null || this.field_70170_p.func_72872_a(Base.class, new AxisAlignedBB(this.village.func_180608_a()).func_72314_b(96.0, 10.0, 96.0)).size() >= 2 || this.field_70146_Z.nextInt(10) != 0) {
                return false;
            }
            return super.func_70601_bi();
        }

        public ITextComponent func_145748_c_() {
            return super.func_145748_c_();
        }

        public World func_190670_t_() {
            return this.field_70170_p;
        }

        public BlockPos func_190671_u_() {
            return new BlockPos((Entity)this);
        }

        @Override
        public SoundEvent func_184639_G() {
            return this.isTrading() ? SoundEvents.field_187914_gn : null;
        }

        public void func_70645_a(DamageSource cause) {
            if (this.field_70717_bb != null && this.village != null) {
                this.village.modifyPlayerReputation(this.field_70717_bb.func_110124_au(), -5);
            }
            super.func_70645_a(cause);
        }

        public void func_70604_c(@Nullable EntityLivingBase livingBase) {
            super.func_70604_c(livingBase);
            if (livingBase instanceof EntityPlayer) {
                this.assholeList.add(livingBase.func_110124_au());
                if (this.village != null) {
                    this.village.modifyPlayerReputation(livingBase.func_110124_au(), -1);
                }
            }
        }

        public class AIDefendVillage
        extends EntityAITarget {
            Base ninja;
            EntityLivingBase villageAgressorTarget;

            public AIDefendVillage(Base entityIn) {
                super((EntityCreature)entityIn, false, true);
                this.ninja = entityIn;
                this.func_75248_a(1);
            }

            public boolean func_75250_a() {
                Village village = this.ninja.getVillage();
                if (village == null) {
                    return false;
                }
                this.villageAgressorTarget = village.func_75571_b((EntityLivingBase)this.ninja);
                if (this.villageAgressorTarget instanceof EntityCreeper) {
                    return false;
                }
                if (this.func_75296_a(this.villageAgressorTarget, false)) {
                    return true;
                }
                this.villageAgressorTarget = this.findNearestVillagerChaser(this.ninja.field_70170_p, village);
                if (this.func_75296_a(this.villageAgressorTarget, false)) {
                    return true;
                }
                if (this.field_75299_d.func_70681_au().nextInt(20) == 0) {
                    this.villageAgressorTarget = village.func_82685_c((EntityLivingBase)this.ninja);
                    return this.func_75296_a(this.villageAgressorTarget, false);
                }
                return false;
            }

            @Nullable
            private EntityLivingBase findNearestVillagerChaser(World world, Village village) {
                List list = world.func_72872_a(EntityVillager.class, new AxisAlignedBB(village.func_180608_a()).func_72314_b((double)village.func_75568_b(), 8.0, (double)village.func_75568_b()));
                HashMap aggressorMap = Maps.newHashMap();
                for (EntityVillager villager : list) {
                    List list2 = world.func_72872_a(EntityZombie.class, villager.func_174813_aQ().func_72314_b(8.0, 3.0, 8.0));
                    if (list2.isEmpty()) continue;
                    list2.sort(new ProcedureUtils.EntitySorter((Entity)villager));
                    EntityZombie zombie = (EntityZombie)list2.get(0);
                    double d = zombie.func_70032_d((Entity)villager);
                    if (aggressorMap.containsKey(zombie) && !((Double)aggressorMap.get(zombie) > d)) continue;
                    aggressorMap.put(zombie, d);
                }
                LinkedHashMap sortedMap = new LinkedHashMap();
                aggressorMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEachOrdered(x -> {
                    Double cfr_ignored_0 = (Double)sortedMap.put(x.getKey(), x.getValue());
                });
                Iterator iter = sortedMap.keySet().iterator();
                return iter.hasNext() ? (EntityLivingBase)iter.next() : null;
            }

            public void func_75249_e() {
                this.ninja.func_70624_b(this.villageAgressorTarget);
                super.func_75249_e();
            }
        }

        public class AIWatchCustomer
        extends EntityAIWatchClosest {
            public AIWatchCustomer(Base merchant) {
                super((EntityLiving)merchant, EntityPlayer.class, 8.0f);
            }

            public boolean func_75250_a() {
                if (((Base)this.field_75332_b).isTrading()) {
                    this.field_75334_a = ((Base)this.field_75332_b).func_70931_l_();
                    return true;
                }
                return false;
            }
        }

        public class AITradePlayer
        extends EntityAIBase {
            private final Base merchant;

            public AITradePlayer(Base merchantIn) {
                this.merchant = merchantIn;
                this.func_75248_a(5);
            }

            public boolean func_75250_a() {
                if (!this.merchant.func_70089_S() || this.merchant.func_70090_H() || !this.merchant.field_70122_E || this.merchant.field_70133_I) {
                    return false;
                }
                EntityPlayer entityplayer = this.merchant.func_70931_l_();
                if (entityplayer == null || this.merchant.func_70068_e((Entity)entityplayer) > 16.0) {
                    return false;
                }
                return entityplayer.field_71070_bA != null;
            }

            public void func_75249_e() {
                this.merchant.func_70661_as().func_75499_g();
            }

            public void func_75251_c() {
                this.merchant.func_70932_a_(null);
            }
        }
    }

    public static enum TradeLevel {
        COMMON,
        UNCOMMON,
        RARE;

    }
}

