/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import java.util.List;
import java.util.Random;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityParticle
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 199;

    public EntityParticle(ElementsNarutomodMod instance) {
        super(instance, 516);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(Base.class).id(new ResourceLocation("narutomod", "particle"), 199).name("particle").tracker(64, 3, true).build());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(Base.class, renderManager -> new CustomRender(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class CustomRender
        extends Render<Base> {
            private final ResourceLocation texture;

            public CustomRender(RenderManager renderManager) {
                super(renderManager);
                this.texture = new ResourceLocation("narutomod:textures/particles.png");
            }

            public void doRender(Base entity, double x, double y, double z, float entityYaw, float partialTicks) {
                this.func_180548_c(entity);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                float scale = entity.getScale(partialTicks);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                GlStateManager.func_179114_b((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1.0f : 1.0f) * -this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
                double d = (double)entity.texU / 8.0;
                double d1 = d + 0.125;
                double d2 = (double)entity.getTexV() / 8.0;
                double d3 = d2 + 0.125;
                Vector4f vec = entity.getColor(partialTicks);
                if (vec.w < 1.0f) {
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                }
                GlStateManager.func_179132_a((!entity.shouldDisableDepth() ? 1 : 0) != 0);
                GlStateManager.func_179140_f();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int i = entity.func_70070_b();
                int j = i >> 16 & 0xFFFF;
                int k = i & 0xFFFF;
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                bufferbuilder.func_181662_b(-0.1, 0.0, 0.0).func_187315_a(d, d3).func_181666_a(vec.x, vec.y, vec.z, vec.w).func_187314_a(j, k).func_181675_d();
                bufferbuilder.func_181662_b(0.1, 0.0, 0.0).func_187315_a(d1, d3).func_181666_a(vec.x, vec.y, vec.z, vec.w).func_187314_a(j, k).func_181675_d();
                bufferbuilder.func_181662_b(0.1, 0.2, 0.0).func_187315_a(d1, d2).func_181666_a(vec.x, vec.y, vec.z, vec.w).func_187314_a(j, k).func_181675_d();
                bufferbuilder.func_181662_b(-0.1, 0.2, 0.0).func_187315_a(d, d2).func_181666_a(vec.x, vec.y, vec.z, vec.w).func_187314_a(j, k).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179145_e();
                GlStateManager.func_179132_a((boolean)true);
                if (vec.w < 1.0f) {
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179118_c();
                }
                GlStateManager.func_179121_F();
            }

            protected ResourceLocation getEntityTexture(Base entity) {
                return this.texture;
            }
        }
    }

    public static class Base
    extends Entity {
        private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Integer> MAXAGE = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Float> RED = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> GREEN = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> BLUE = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> ALPHA = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        protected int texU;

        public Base(World worldIn) {
            super(worldIn);
            this.func_70105_a(0.2f, 0.2f);
            this.field_70178_ae = true;
        }

        public Base(World worldIn, double x, double y, double z, double mX, double mY, double mZ, int color, float scale, int maxAgeIn) {
            this(worldIn);
            this.func_70107_b(x, y, z);
            this.field_70159_w = mX;
            this.field_70181_x = mY;
            this.field_70179_y = mZ;
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.1f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = MathHelper.func_76131_a((float)((float)(color >> 16 & 0xFF) / 255.0f + f), (float)0.0f, (float)1.0f);
            float g = MathHelper.func_76131_a((float)((float)(color >> 8 & 0xFF) / 255.0f + f), (float)0.0f, (float)1.0f);
            float b = MathHelper.func_76131_a((float)((float)(color & 0xFF) / 255.0f + f), (float)0.0f, (float)1.0f);
            this.setColor(r, g, b, a);
            this.setScale(scale);
            if (maxAgeIn > 0) {
                this.setMaxAge((int)((this.field_70146_Z.nextFloat() * 0.4f + 0.8f) * (float)maxAgeIn));
            }
        }

        protected void func_70088_a() {
            this.field_70180_af.func_187214_a(AGE, (Object)0);
            this.field_70180_af.func_187214_a(MAXAGE, (Object)((int)(20.0 / (this.field_70146_Z.nextDouble() * 0.8 + 0.2))));
            this.field_70180_af.func_187214_a(RED, (Object)Float.valueOf(1.0f));
            this.field_70180_af.func_187214_a(GREEN, (Object)Float.valueOf(1.0f));
            this.field_70180_af.func_187214_a(BLUE, (Object)Float.valueOf(1.0f));
            this.field_70180_af.func_187214_a(ALPHA, (Object)Float.valueOf(1.0f));
            this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(1.0f));
        }

        public int getAge() {
            return (Integer)this.field_70180_af.func_187225_a(AGE);
        }

        protected void setAge(int age) {
            this.field_70180_af.func_187227_b(AGE, (Object)age);
        }

        public int getMaxAge() {
            return (Integer)this.field_70180_af.func_187225_a(MAXAGE);
        }

        protected void setMaxAge(int age) {
            this.field_70180_af.func_187227_b(MAXAGE, (Object)age);
        }

        public float getScale() {
            return ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue();
        }

        public float getScale(float partialTicks) {
            return this.getScale();
        }

        protected void setScale(float f) {
            this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(f));
        }

        public int getColorInt() {
            Vector4f vec = this.getColor();
            return (int)(vec.w * 255.0f) << 24 | (int)(vec.x * 255.0f) << 16 | (int)(vec.y * 255.0f) << 8 | (int)(vec.z * 255.0f);
        }

        public Vector4f getColor() {
            return new Vector4f(((Float)this.field_70180_af.func_187225_a(RED)).floatValue(), ((Float)this.field_70180_af.func_187225_a(GREEN)).floatValue(), ((Float)this.field_70180_af.func_187225_a(BLUE)).floatValue(), ((Float)this.field_70180_af.func_187225_a(ALPHA)).floatValue());
        }

        public Vector4f getColor(float partialTicks) {
            return this.getColor();
        }

        protected void setColor(float r, float g, float b, float a) {
            this.field_70180_af.func_187227_b(RED, (Object)Float.valueOf(r));
            this.field_70180_af.func_187227_b(GREEN, (Object)Float.valueOf(g));
            this.field_70180_af.func_187227_b(BLUE, (Object)Float.valueOf(b));
            this.field_70180_af.func_187227_b(ALPHA, (Object)Float.valueOf(a));
        }

        public void func_184206_a(DataParameter<?> key) {
            super.func_184206_a(key);
            if (SCALE.equals(key) && this.field_70170_p.field_72995_K) {
                float scale = this.getScale();
                this.func_70105_a(0.2f * scale, 0.2f * scale);
            }
        }

        public boolean shouldDisableDepth() {
            return false;
        }

        public boolean func_70067_L() {
            return !this.field_70128_L;
        }

        public void move(double x, double y, double z) {
            double d0 = y;
            double origX = x;
            double origZ = z;
            if (!this.field_70145_X) {
                List list = this.field_70170_p.func_184144_a(null, this.func_174813_aQ().func_72321_a(x, y, z));
                for (AxisAlignedBB axisalignedbb : list) {
                    y = axisalignedbb.func_72323_b(this.func_174813_aQ(), y);
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
                for (AxisAlignedBB axisalignedbb1 : list) {
                    x = axisalignedbb1.func_72316_a(this.func_174813_aQ(), x);
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(x, 0.0, 0.0));
                for (AxisAlignedBB axisalignedbb2 : list) {
                    z = axisalignedbb2.func_72322_c(this.func_174813_aQ(), z);
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, z));
            } else {
                this.func_174826_a(this.func_174813_aQ().func_72317_d(x, y, z));
            }
            this.func_174829_m();
            this.field_70123_F = origX != x || origZ != z;
            this.field_70124_G = d0 != y;
            this.field_70132_H = this.field_70123_F || this.field_70124_G;
            boolean bl = this.field_70122_E = this.field_70124_G && d0 < 0.0;
            if (origX != x) {
                this.field_70159_w = 0.0;
            }
            if (origZ != z) {
                this.field_70179_y = 0.0;
            }
        }

        public void onDeath() {
            this.func_70106_y();
        }

        public void func_70071_h_() {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.move(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.8;
            this.field_70181_x *= 0.8;
            this.field_70179_y *= 0.8;
            int age = this.getAge() + 1;
            this.setAge(age);
            if (age > this.getMaxAge()) {
                this.onDeath();
            }
        }

        public void setParticleTextureOffset(int offset) {
            this.texU = offset;
        }

        protected int getTexV() {
            return 0;
        }

        public double getVelocity() {
            return ProcedureUtils.getVelocity(this);
        }

        public Random getRNG() {
            return this.field_70146_Z;
        }

        protected void func_70037_a(NBTTagCompound compound) {
            this.setAge(compound.func_74762_e("age"));
            this.setMaxAge(compound.func_74762_e("maxAge"));
            this.setColor(compound.func_74760_g("red"), compound.func_74760_g("green"), compound.func_74760_g("blue"), compound.func_74760_g("alpha"));
            this.setScale(compound.func_74760_g("scale"));
        }

        protected void func_70014_b(NBTTagCompound compound) {
            compound.func_74768_a("age", this.getAge());
            compound.func_74768_a("maxAge", this.getMaxAge());
            Vector4f vec = this.getColor();
            compound.func_74776_a("red", vec.x);
            compound.func_74776_a("green", vec.y);
            compound.func_74776_a("blue", vec.z);
            compound.func_74776_a("alpha", vec.w);
            compound.func_74776_a("scale", this.getScale());
        }
    }
}

