/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityPuppet;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.item.ItemSenbon;

@ElementsNarutomodMod.ModElement.Tag
public class EntityPuppetKarasu
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 379;
    public static final int ENTITYID_RANGED = 380;

    public EntityPuppetKarasu(ElementsNarutomodMod instance) {
        super(instance, 738);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "puppet_karasu"), 379).name("puppet_karasu").tracker(64, 3, true).build());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new EntityPuppet.ClientClass.Renderer<EntityCustom>(renderManager, (ModelBase)new ModelKarasu(), 0.5f){
                private final ResourceLocation texture;
                {
                    this.texture = new ResourceLocation("narutomod:textures/karasu.png");
                }

                protected ResourceLocation getEntityTexture(EntityCustom entity) {
                    return this.texture;
                }
            });
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelKarasu
        extends ModelBiped {
            private final ModelRenderer rightArm2;
            private final ModelRenderer leftArm2;

            public ModelKarasu() {
                this.field_78090_t = 64;
                this.field_78089_u = 64;
                this.field_78116_c = new ModelRenderer((ModelBase)this);
                this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_78116_c.field_78804_l.add(new ModelBox(this.field_78116_c, 0, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f, false));
                this.field_178720_f = new ModelRenderer((ModelBase)this);
                this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_178720_f.field_78804_l.add(new ModelBox(this.field_178720_f, 32, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.5f, false));
                this.field_78115_e = new ModelRenderer((ModelBase)this);
                this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 16, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.0f, false));
                this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 32, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.5f, false));
                this.field_178723_h = new ModelRenderer((ModelBase)this);
                this.field_178723_h.func_78793_a(-5.0f, 2.5f, 0.0f);
                this.setRotationAngle(this.field_178723_h, 0.0f, 0.0f, 0.3491f);
                this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 16, -2.0f, -2.0f, -2.0f, 3, 12, 4, -0.2f, false));
                this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 32, -2.0f, -2.0f, -2.0f, 3, 12, 4, 0.5f, false));
                this.field_178724_i = new ModelRenderer((ModelBase)this);
                this.field_178724_i.func_78793_a(5.0f, 2.5f, 0.0f);
                this.setRotationAngle(this.field_178724_i, 0.0f, 0.0f, -0.3491f);
                this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 32, 48, -1.0f, -2.0f, -2.0f, 3, 12, 4, -0.2f, false));
                this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 48, 48, -1.0f, -2.0f, -2.0f, 3, 12, 4, 0.5f, false));
                this.field_178721_j = new ModelRenderer((ModelBase)this);
                this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
                this.setRotationAngle(this.field_178721_j, 0.0f, 0.0f, 0.0873f);
                this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 16, -1.5f, 0.0f, -2.0f, 3, 12, 4, -0.2f, false));
                this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 32, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.5f, false));
                this.field_178722_k = new ModelRenderer((ModelBase)this);
                this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
                this.setRotationAngle(this.field_178722_k, 0.0f, 0.0f, -0.0873f);
                this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 16, 48, -1.5f, 0.0f, -2.0f, 3, 12, 4, -0.2f, false));
                this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 0, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.5f, false));
                this.rightArm2 = new ModelRenderer((ModelBase)this);
                this.rightArm2.func_78793_a(-5.0f, 7.5f, 0.0f);
                this.setRotationAngle(this.rightArm2, 0.0f, 0.0f, 0.2182f);
                this.rightArm2.field_78804_l.add(new ModelBox(this.rightArm2, 40, 16, -2.0f, -2.0f, -2.0f, 3, 12, 4, -0.2f, false));
                this.rightArm2.field_78804_l.add(new ModelBox(this.rightArm2, 40, 32, -2.0f, -2.0f, -2.0f, 3, 12, 4, 0.3f, false));
                this.leftArm2 = new ModelRenderer((ModelBase)this);
                this.leftArm2.func_78793_a(5.0f, 7.5f, 0.0f);
                this.setRotationAngle(this.leftArm2, 0.0f, 0.0f, -0.2618f);
                this.leftArm2.field_78804_l.add(new ModelBox(this.leftArm2, 32, 48, -1.0f, -2.0f, -2.0f, 3, 12, 4, -0.2f, false));
                this.leftArm2.field_78804_l.add(new ModelBox(this.leftArm2, 48, 48, -1.0f, -2.0f, -2.0f, 3, 12, 4, 0.3f, false));
            }

            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
                this.rightArm2.func_78785_a(f5);
                this.leftArm2.func_78785_a(f5);
            }

            public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
                modelRenderer.field_78795_f = x;
                modelRenderer.field_78796_g = y;
                modelRenderer.field_78808_h = z;
            }

            public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
                super.func_78087_a(0.0f, 0.0f, f2, f3, f4, f5, e);
                this.field_178723_h.field_78808_h += 0.3491f;
                this.field_178724_i.field_78808_h += -0.3491f;
                this.rightArm2.field_78808_h = MathHelper.func_76134_b((float)(f2 * 0.09f)) * 0.03f + 0.2182f + 0.03f;
                this.leftArm2.field_78808_h = -MathHelper.func_76134_b((float)(f2 * 0.09f)) * 0.03f - 0.2618f - 0.03f;
                this.rightArm2.field_78795_f = MathHelper.func_76126_a((float)(f2 * 0.067f)) * 0.03f;
                this.leftArm2.field_78795_f = -MathHelper.func_76126_a((float)(f2 * 0.067f)) * 0.03f;
                double velocity = ((EntityCustom)e).getVelocity();
                if (velocity > 0.001) {
                    float fa = MathHelper.func_76131_a((float)((float)velocity), (float)0.0f, (float)1.0f) * 45.0f * (float)Math.PI / 180.0f;
                    this.field_178723_h.field_78795_f += fa;
                    this.field_178724_i.field_78795_f += fa;
                    this.rightArm2.field_78795_f = this.field_178723_h.field_78795_f;
                    this.rightArm2.field_78796_g = this.field_178723_h.field_78796_g;
                    this.rightArm2.field_78808_h = this.field_178723_h.field_78808_h - 0.1309f;
                    this.leftArm2.field_78795_f = this.field_178724_i.field_78795_f;
                    this.leftArm2.field_78796_g = this.field_178724_i.field_78796_g;
                    this.leftArm2.field_78808_h = this.field_178724_i.field_78808_h + 0.1309f;
                    this.field_178721_j.field_78795_f += fa;
                    this.field_178722_k.field_78795_f += fa;
                }
            }
        }
    }

    public static class EntityCustom
    extends EntityPuppet.Base
    implements IRangedAttackMob {
        public static final float MAXHEALTH = 40.0f;

        public EntityCustom(World worldIn) {
            super(worldIn);
            this.func_70105_a(0.6f, 2.0f);
        }

        public EntityCustom(EntityLivingBase ownerIn) {
            super(ownerIn);
            this.func_70105_a(0.6f, 2.0f);
            Vec3d vec = ownerIn.func_70040_Z();
            vec = ownerIn.func_174791_d().func_72441_c(vec.field_72450_a, 1.0, vec.field_72449_c);
            this.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, ownerIn.field_70177_z, 0.0f);
        }

        @Override
        protected Vec3d getOffsetToOwner() {
            return new Vec3d(0.8, 0.5, 4.0);
        }

        @Override
        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.2, 20, 48.0f));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityPuppet.Base.AIChargeAttack(this));
        }

        @Override
        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        }

        public void func_184724_a(boolean swingingArms) {
        }

        public void func_82196_d(EntityLivingBase target, float flval) {
            Vec3d vec = target.func_174824_e(1.0f);
            for (int i = 0; i < 8; ++i) {
                ItemSenbon.spawnArrow((EntityLivingBase)this, vec);
            }
        }
    }
}

