/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.item.ItemGourd;
import net.narutomod.item.ItemJiton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.potion.PotionParalysis;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntitySandBind
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 206;
    public static final int ENTITYID_RANGED = 207;

    public EntitySandBind(ElementsNarutomodMod instance) {
        super(instance, 521);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "sand_bind"), 206).name("sand_bind").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new CustomRender(renderManager));
    }

    public static boolean sandFuneral(EntityLivingBase attacker) {
        RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)attacker, 50.0, true);
        if (res != null && res.field_72308_g instanceof EC && ((EC)res.field_72308_g).canFuneral() && Chakra.pathway(attacker).consume(50.0)) {
            attacker.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:sabakusoso")), SoundCategory.PLAYERS, 1.0f, 1.0f);
            ((EC)res.field_72308_g).sandFuneral();
            return true;
        }
        return false;
    }

    public static class EC
    extends Entity {
        private EntityLivingBase user;
        private EntityLivingBase targetEntity;
        private ItemJiton.SwarmTarget sandTarget;
        private Vec3d capturedVec;
        private int funeralTime;
        private final float funeralDamage = 4.0f;
        private static final int MAXTIME = 600;

        public EC(World world) {
            super(world);
            this.func_70105_a(0.2f, 0.2f);
            this.field_70178_ae = true;
            this.funeralTime = -1;
        }

        public EC(EntityLivingBase userIn, EntityLivingBase targetIn, ItemJiton.Type sandType) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.targetEntity = targetIn;
            Vec3d vec = this.getGourdMouthPos();
            this.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            this.sandTarget = new ItemJiton.SwarmTarget(this.field_70170_p, 100, vec, this.getTargetVector(), new Vec3d(0.1, 0.4, 0.1), 0.95f, 0.03f, false, 2.0f, sandType.getColor());
        }

        protected void func_70088_a() {
        }

        private Vec3d getGourdMouthPos() {
            if (this.user != null) {
                return ItemGourd.getMouthPos(this.user);
            }
            return this.func_174791_d();
        }

        private AxisAlignedBB getTargetVector() {
            return this.targetEntity.func_174813_aQ();
        }

        private boolean isTargetCaptured() {
            boolean flag;
            if (!ItemJutsu.canTarget((Entity)this.targetEntity)) {
                this.capturedVec = null;
                return false;
            }
            boolean bl = flag = this.capturedVec != null;
            if (!flag && this.func_174813_aQ().func_72326_a(this.targetEntity.func_174813_aQ())) {
                AxisAlignedBB bb = this.func_174813_aQ().func_191500_a(this.targetEntity.func_174813_aQ());
                boolean bl2 = flag = bb.equals((Object)this.targetEntity.func_174813_aQ()) && this.func_174813_aQ().func_72320_b() < this.targetEntity.func_174813_aQ().func_72320_b() * 2.0;
            }
            if (flag && this.capturedVec == null) {
                this.capturedVec = this.targetEntity.func_174791_d();
            } else if (!flag) {
                this.capturedVec = null;
            }
            return flag;
        }

        public void sandFuneral() {
            this.funeralTime = 20;
        }

        private boolean canFuneral() {
            return this.funeralTime < 0 && this.targetEntity != null && this.targetEntity.func_70089_S() && this.isTargetCaptured();
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && this.sandTarget != null && !this.sandTarget.shouldRemove()) {
                ItemStack stack;
                this.sandTarget.forceRemove();
                if (this.user != null && (stack = this.user.func_184582_a(EntityEquipmentSlot.CHEST)).func_77973_b() == ItemGourd.body) {
                    stack.func_96631_a(20, this.field_70146_Z, null);
                }
            }
        }

        private void attackTargetEntity(float amount) {
            this.targetEntity.field_70172_ad = 10;
            this.targetEntity.func_70097_a(ItemJutsu.causeJutsuDamage(this, this.user).func_76348_h(), amount);
        }

        private void holdTarget() {
            this.targetEntity.func_70690_d(new PotionEffect(PotionParalysis.potion, 2, 0, false, false));
            this.targetEntity.func_70634_a(this.capturedVec.field_72450_a, this.capturedVec.field_72448_b, this.capturedVec.field_72449_c);
        }

        public void func_70071_h_() {
            if (this.user != null && this.user.func_70089_S() && this.sandTarget != null && !this.sandTarget.shouldRemove() && this.targetEntity != null) {
                if (this.targetEntity.func_70089_S() && this.funeralTime != 0 && this.field_70173_aa < 600) {
                    if (this.isTargetCaptured()) {
                        if (this.funeralTime > 0) {
                            this.sandTarget.setTarget(this.getTargetVector(), 0.95f, 0.03f, false);
                            this.attackTargetEntity(this.funeralDamage);
                            --this.funeralTime;
                        } else {
                            this.sandTarget.setTarget(this.getTargetVector(), this.func_174813_aQ().func_72320_b() < this.targetEntity.func_174813_aQ().func_72320_b() * 2.0 ? 0.0f : 0.3f, 0.0f, false);
                        }
                        this.holdTarget();
                    } else {
                        this.sandTarget.setTarget(this.getTargetVector(), 2.0f, 0.03f, false);
                    }
                } else {
                    this.sandTarget.setTarget(this.getGourdMouthPos(), 0.8f, 0.02f, true);
                }
                this.sandTarget.onUpdate();
                this.func_174826_a(this.sandTarget.getBorders());
                this.func_174829_m();
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        public void func_174826_a(AxisAlignedBB bb) {
            super.func_174826_a(bb);
            this.field_70130_N = (float)Math.min(bb.field_72336_d - bb.field_72340_a, bb.field_72334_f - bb.field_72339_c);
            this.field_70131_O = (float)(bb.field_72337_e - bb.field_72338_b);
        }

        public void func_174829_m() {
            super.func_174829_m();
            if (!this.field_70170_p.field_72995_K && this.isAddedToWorld()) {
                ProcedureSync.ResetBoundingBox.sendToTracking(this);
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                RayTraceResult result = ProcedureUtils.objectEntityLookingAt((Entity)entity, 30.0, 2.0, true);
                if (result != null) {
                    if (result.field_72308_g instanceof EC) {
                        result.field_72308_g.field_70173_aa = 600;
                        return false;
                    }
                    if (result.field_72308_g instanceof EntityLivingBase) {
                        for (EC ec : entity.field_70170_p.func_72872_a(EC.class, entity.func_174813_aQ().func_186662_g(30.0))) {
                            if (!result.field_72308_g.equals((Object)ec.targetEntity)) continue;
                            return false;
                        }
                        EC entity1 = new EC(entity, (EntityLivingBase)result.field_72308_g, ItemJiton.getSandType(stack));
                        entity.field_70170_p.func_72838_d((Entity)entity1);
                        return true;
                    }
                }
                return false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class CustomRender
    extends Render<EC> {
        public CustomRender(RenderManager renderManagerIn) {
            super(renderManagerIn);
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return null;
        }
    }
}

