/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.item.ItemJiton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntitySandGathering
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 430;
    public static final int ENTITYID_RANGED = 431;
    private static final float SCALE = 8.0f;

    public EntitySandGathering(ElementsNarutomodMod instance) {
        super(instance, 858);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "sand_gathering"), 430).name("sand_gathering").tracker(64, 3, true).build());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new CustomRender(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelSandPyramid
        extends ModelBase {
            private final ModelRenderer bone;
            private final ModelRenderer bone3;
            private final ModelRenderer bone4;
            private final ModelRenderer bone2;
            private final ModelRenderer bb_main;

            public ModelSandPyramid() {
                this.field_78090_t = 16;
                this.field_78089_u = 16;
                this.bone = new ModelRenderer((ModelBase)this);
                this.bone.func_78793_a(0.0f, 0.0f, 0.0f);
                this.setRotationAngle(this.bone, 0.3927f, 0.0f, 0.0f);
                this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 0, -3.0f, -8.0f, 0.0f, 6, 8, 0, 0.0f, false));
                this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 0, -3.0f, -8.0f, 0.0f, 6, 8, 0, -0.05f, false));
                this.bone3 = new ModelRenderer((ModelBase)this);
                this.bone3.func_78793_a(0.0f, 0.0f, 0.0f);
                this.setRotationAngle(this.bone3, 0.0f, 1.5708f, -0.3927f);
                this.bone3.field_78804_l.add(new ModelBox(this.bone3, 0, 0, -3.0f, -8.0f, 0.0f, 6, 8, 0, 0.0f, false));
                this.bone3.field_78804_l.add(new ModelBox(this.bone3, 0, 0, -3.0f, -8.0f, 0.0f, 6, 8, 0, -0.05f, false));
                this.bone4 = new ModelRenderer((ModelBase)this);
                this.bone4.func_78793_a(0.0f, 0.0f, 0.0f);
                this.setRotationAngle(this.bone4, 0.0f, -1.5708f, 0.3927f);
                this.bone4.field_78804_l.add(new ModelBox(this.bone4, 0, 0, -3.0f, -8.0f, 0.0f, 6, 8, 0, 0.0f, true));
                this.bone4.field_78804_l.add(new ModelBox(this.bone4, 0, 0, -3.0f, -8.0f, 0.0f, 6, 8, 0, -0.05f, true));
                this.bone2 = new ModelRenderer((ModelBase)this);
                this.bone2.func_78793_a(0.0f, 0.0f, 0.0f);
                this.setRotationAngle(this.bone2, -2.7489f, 0.0f, -3.1416f);
                this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 0, -3.0f, -8.0f, 0.0f, 6, 8, 0, 0.0f, false));
                this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 0, -3.0f, -8.0f, 0.0f, 6, 8, 0, -0.05f, false));
                this.bb_main = new ModelRenderer((ModelBase)this);
                this.bb_main.func_78793_a(0.0f, 0.0f, 0.0f);
                this.bb_main.field_78804_l.add(new ModelBox(this.bb_main, -6, 10, -3.0f, -7.17f, -3.0f, 6, 0, 6, 0.0f, false));
            }

            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                this.bone.func_78785_a(f5);
                this.bone3.func_78785_a(f5);
                this.bone4.func_78785_a(f5);
                this.bone2.func_78785_a(f5);
                this.bb_main.func_78785_a(f5);
            }

            public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
                modelRenderer.field_78795_f = x;
                modelRenderer.field_78796_g = y;
                modelRenderer.field_78808_h = z;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class CustomRender
        extends Render<EC> {
            private final ResourceLocation texture;
            private final ModelSandPyramid model;

            public CustomRender(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.texture = new ResourceLocation("narutomod:textures/sandpyramid.png");
                this.model = new ModelSandPyramid();
                this.field_76989_e = 2.4f;
            }

            public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
                GlStateManager.func_179094_E();
                this.func_180548_c(entity);
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                float f = (float)entity.field_70173_aa + partialTicks;
                int i = entity.getDeathTicks();
                float scale = i > 0 ? (1.0f - Math.min((partialTicks + (float)i) / 20.0f, 1.0f)) * 8.0f : Math.min(f / (40.0f / 8.0f), 8.0f);
                GlStateManager.func_179114_b((float)(scale == 8.0f ? f * 20.0f : 0.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GlStateManager.func_179121_F();
            }

            protected ResourceLocation getEntityTexture(EC entity) {
                return this.texture;
            }
        }
    }

    public static class EC
    extends Entity {
        private static final DataParameter<Integer> DEATH_TICKS = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187192_b);
        private EntityLivingBase summoner;
        private ItemJiton.SwarmTarget sandCloud;
        private final int waitTime = 40;
        private boolean riseAgain;
        private double accelX;
        private double accelY;
        private double accelZ;

        public EC(World world) {
            super(world);
            this.func_70105_a(3.0f, 3.5f);
            this.field_70178_ae = true;
        }

        public EC(EntityLivingBase summonerIn) {
            this(summonerIn.field_70170_p);
            this.summoner = summonerIn;
            Vec3d vec = summonerIn.func_70040_Z().func_186678_a(2.0);
            vec = summonerIn.func_174791_d().func_72441_c(vec.field_72450_a, 3.0, vec.field_72449_c);
            this.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            this.sandCloud = new ItemJiton.SwarmTarget(this.field_70170_p, 50, this.getMouthPos(), this.func_174813_aQ(), new Vec3d(0.4, 0.0, 0.4), 0.5f, 0.03f, false, 2.0f, ItemJiton.Type.IRON.getColor());
        }

        protected void func_70088_a() {
            this.field_70180_af.func_187214_a(DEATH_TICKS, (Object)0);
        }

        public int getDeathTicks() {
            return (Integer)this.field_70180_af.func_187225_a(DEATH_TICKS);
        }

        private void setDeathTicks(int i) {
            this.field_70180_af.func_187227_b(DEATH_TICKS, (Object)i);
        }

        private Vec3d getMouthPos() {
            return this.summoner != null ? this.summoner.func_174791_d().func_72441_c(0.0, 1.5, 0.0) : this.func_174791_d();
        }

        private void updateSandParticles() {
            int i = this.getDeathTicks();
            if (this.sandCloud != null) {
                if (this.sandCloud.shouldRemove()) {
                    this.sandCloud = null;
                } else {
                    if (i == 0 && this.sandCloud.getTicks() > this.waitTime) {
                        this.sandCloud.forceRemove();
                    }
                    this.sandCloud.onUpdate();
                }
            } else if (!this.field_70170_p.field_72995_K && i > 0) {
                this.sandCloud = new ItemJiton.SwarmTarget(this.field_70170_p, 50, this.func_174813_aQ(), this.getMouthPos(), new Vec3d(0.2, -0.1, 0.2), 0.5f, 0.03f, true, 2.0f, ItemJiton.Type.IRON.getColor());
            }
        }

        private void onDeathUpdate() {
            int i = this.getDeathTicks() + 1;
            this.setDeathTicks(i);
            if (i > 2 && this.sandCloud == null) {
                this.func_70106_y();
            }
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            this.updateSandParticles();
            if (this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0) {
                RayTraceResult result = this.forwardsRaycast(true);
                if (!this.field_70170_p.field_72995_K && result != null) {
                    this.field_70170_p.func_72876_a((Entity)this.summoner, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c, 3.0f, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.summoner));
                    this.accelX = 0.0;
                    this.accelY = 0.0;
                    this.accelZ = 0.0;
                    this.field_70159_w = 0.0;
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.1;
                    this.riseAgain = true;
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            this.field_70159_w += this.accelX;
            this.field_70181_x += this.accelY;
            this.field_70179_y += this.accelZ;
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
            if (this.riseAgain && this.summoner != null && this.field_70163_u >= this.summoner.field_70163_u + 3.0) {
                this.riseAgain = false;
                this.field_70181_x = 0.0;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (!(this.field_70170_p.field_72995_K || this.summoner != null && this.getDeathTicks() <= 0 && this.field_70173_aa <= 300)) {
                this.onDeathUpdate();
            }
        }

        public void shoot(Vec3d vec) {
            Vec3d vec1 = vec.func_72432_b().func_186678_a(0.15);
            this.accelX = vec1.field_72450_a;
            this.accelY = vec1.field_72448_b;
            this.accelZ = vec1.field_72449_c;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.riseAgain = false;
        }

        protected RayTraceResult forwardsRaycast(boolean includeEntities) {
            return EntityScalableProjectile.forwardsRaycast(this, ProcedureUtils.getMotion(this), includeEntities, false, null);
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ID_KEY = "JitonSandGatheringEntityIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Entity entity1 = entity.field_70170_p.func_73045_a(entity.getEntityData().func_74762_e(ID_KEY));
                if (!(entity1 instanceof EC)) {
                    entity1 = new EC(entity);
                    entity.field_70170_p.func_72838_d(entity1);
                    entity.getEntityData().func_74768_a(ID_KEY, entity1.func_145782_y());
                    return true;
                }
                RayTraceResult res = ProcedureUtils.raytraceBlocks((Entity)entity, 40.0);
                if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK) {
                    ((EC)entity1).shoot(res.field_72307_f.func_178788_d(entity1.func_174791_d()));
                }
                return false;
            }
        }
    }
}

